/*
 * Decompiled with CFR 0.152.
 */
package org.kson.schema.validators;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.kson.KsonString;
import org.kson.parser.MessageSink;
import org.kson.parser.messages.MessageType;
import org.kson.schema.JsonStringValidator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/kson/schema/validators/PatternValidator;", "Lorg/kson/schema/JsonStringValidator;", "pattern", "", "<init>", "(Ljava/lang/String;)V", "Lkotlin/text/Regex;", "validateString", "", "node", "Lorg/kson/KsonString;", "messageSink", "Lorg/kson/parser/MessageSink;", "kson"})
public final class PatternValidator
extends JsonStringValidator {
    @NotNull
    private final Regex pattern;

    public PatternValidator(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.pattern = new Regex(pattern);
    }

    @Override
    public void validateString(@NotNull KsonString node, @NotNull MessageSink messageSink) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)messageSink, (String)"messageSink");
        String str = node.getValue();
        if (!this.pattern.containsMatchIn((CharSequence)str)) {
            String[] stringArray = new String[]{this.pattern.getPattern()};
            messageSink.error(node.getLocation(), MessageType.SCHEMA_STRING_PATTERN_MISMATCH.create(stringArray));
        }
    }
}

