/*
 * Decompiled with CFR 0.152.
 */
package org.kson.schema.validators;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kson.KsonValue;
import org.kson.parser.MessageSink;
import org.kson.schema.JsonSchema;
import org.kson.schema.JsonSchemaValidator;
import org.kson.schema.ResolvedRef;
import org.kson.schema.SchemaIdLookup;
import org.kson.schema.SchemaParser;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/kson/schema/validators/RefValidator;", "Lorg/kson/schema/JsonSchemaValidator;", "resolvedRef", "Lorg/kson/schema/ResolvedRef;", "idLookup", "Lorg/kson/schema/SchemaIdLookup;", "<init>", "(Lorg/kson/schema/ResolvedRef;Lorg/kson/schema/SchemaIdLookup;)V", "refSchema", "Lorg/kson/schema/JsonSchema;", "getRefSchema", "()Lorg/kson/schema/JsonSchema;", "refSchema$delegate", "Lkotlin/Lazy;", "validate", "", "ksonValue", "Lorg/kson/KsonValue;", "messageSink", "Lorg/kson/parser/MessageSink;", "kson"})
public final class RefValidator
implements JsonSchemaValidator {
    @NotNull
    private final ResolvedRef resolvedRef;
    @NotNull
    private final SchemaIdLookup idLookup;
    @NotNull
    private final Lazy refSchema$delegate;

    public RefValidator(@NotNull ResolvedRef resolvedRef, @NotNull SchemaIdLookup idLookup) {
        Intrinsics.checkNotNullParameter((Object)resolvedRef, (String)"resolvedRef");
        Intrinsics.checkNotNullParameter((Object)idLookup, (String)"idLookup");
        this.resolvedRef = resolvedRef;
        this.idLookup = idLookup;
        this.refSchema$delegate = LazyKt.lazy(() -> RefValidator.refSchema_delegate$lambda$0(this));
    }

    private final JsonSchema getRefSchema() {
        Lazy lazy = this.refSchema$delegate;
        return (JsonSchema)lazy.getValue();
    }

    @Override
    public void validate(@NotNull KsonValue ksonValue, @NotNull MessageSink messageSink) {
        Intrinsics.checkNotNullParameter((Object)ksonValue, (String)"ksonValue");
        Intrinsics.checkNotNullParameter((Object)messageSink, (String)"messageSink");
        JsonSchema jsonSchema = this.getRefSchema();
        if (jsonSchema == null) {
            return;
        }
        JsonSchema schema = jsonSchema;
        schema.validate(ksonValue, messageSink);
    }

    private static final JsonSchema refSchema_delegate$lambda$0(RefValidator this$0) {
        MessageSink messageSink = new MessageSink();
        return SchemaParser.INSTANCE.parseSchemaElement(this$0.resolvedRef.getResolvedValue(), messageSink, this$0.resolvedRef.getResolvedValueBaseUri(), this$0.idLookup);
    }
}

