/*
 * Decompiled with CFR 0.152.
 */
package org.kson.schema.validators;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kson.KsonList;
import org.kson.KsonValue;
import org.kson.parser.MessageSink;
import org.kson.parser.messages.MessageType;
import org.kson.schema.JsonArrayValidator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/kson/schema/validators/UniqueItemsValidator;", "Lorg/kson/schema/JsonArrayValidator;", "uniqueItems", "", "<init>", "(Z)V", "validateArray", "", "node", "Lorg/kson/KsonList;", "messageSink", "Lorg/kson/parser/MessageSink;", "areItemsUnique", "elements", "", "Lorg/kson/KsonValue;", "kson"})
public final class UniqueItemsValidator
extends JsonArrayValidator {
    private final boolean uniqueItems;

    public UniqueItemsValidator(boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
    }

    @Override
    public void validateArray(@NotNull KsonList node, @NotNull MessageSink messageSink) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)messageSink, (String)"messageSink");
        if (this.uniqueItems && !this.areItemsUnique(node.getElements())) {
            messageSink.error(node.getLocation(), MessageType.SCHEMA_ARRAY_ITEMS_NOT_UNIQUE.create(new String[0]));
        }
    }

    private final boolean areItemsUnique(List<? extends KsonValue> elements) {
        int n = ((Collection)elements).size();
        for (int i = 0; i < n; ++i) {
            int n2 = elements.size();
            for (int j = i + 1; j < n2; ++j) {
                if (!elements.get(i).dataEquals(elements.get(j))) continue;
                return false;
            }
        }
        return true;
    }
}

