/*
 * Decompiled with CFR 0.152.
 */
package org.kson.validation;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kson.ast.AstNode;
import org.kson.ast.EmbedBlockNode;
import org.kson.ast.FalseNode;
import org.kson.ast.KsonRoot;
import org.kson.ast.KsonRootImpl;
import org.kson.ast.KsonValueNode;
import org.kson.ast.KsonValueNodeError;
import org.kson.ast.ListElementNode;
import org.kson.ast.ListElementNodeImpl;
import org.kson.ast.ListNode;
import org.kson.ast.NullNode;
import org.kson.ast.NumberNode;
import org.kson.ast.ObjectNode;
import org.kson.ast.ObjectPropertyNode;
import org.kson.ast.ObjectPropertyNodeImpl;
import org.kson.ast.QuotedStringNode;
import org.kson.ast.TrueNode;
import org.kson.ast.UnquotedStringNode;
import org.kson.parser.Coordinates;
import org.kson.parser.Location;
import org.kson.parser.MessageSink;
import org.kson.parser.messages.MessageType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002JR\u0010\u0015\u001a\u00020\u0005\"\b\b\u0000\u0010\u0016*\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/kson/validation/IndentValidator;", "", "<init>", "()V", "validate", "", "ast", "Lorg/kson/ast/KsonRoot;", "messageSink", "Lorg/kson/parser/MessageSink;", "validateNode", "node", "Lorg/kson/ast/KsonValueNode;", "previousNodeLine", "", "validateObject", "objNode", "Lorg/kson/ast/ObjectNode;", "validateList", "listNode", "Lorg/kson/ast/ListNode;", "validateAlignment", "T", "Lorg/kson/ast/AstNode;", "items", "", "misalignmentMessage", "Lorg/kson/parser/messages/MessageType;", "validateChild", "Lkotlin/Function2;", "kson"})
public final class IndentValidator {
    public final void validate(@NotNull KsonRoot ast, @NotNull MessageSink messageSink) {
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)messageSink, (String)"messageSink");
        if (ast instanceof KsonRootImpl) {
            this.validateNode(((KsonRootImpl)ast).getRootNode(), -1, messageSink);
        }
    }

    private final void validateNode(KsonValueNode node, int previousNodeLine, MessageSink messageSink) {
        int previousLine = node instanceof ObjectNode && !((Collection)((ObjectNode)node).getProperties()).isEmpty() && ((ObjectNode)node).getLocation().getStart().getColumn() != ((ObjectPropertyNode)CollectionsKt.first(((ObjectNode)node).getProperties())).getLocation().getStart().getColumn() ? ((ObjectNode)node).getLocation().getStart().getLine() : (node instanceof ListNode && !((Collection)((ListNode)node).getElements()).isEmpty() && ((ListNode)node).getLocation().getStart().getColumn() != ((ListElementNode)CollectionsKt.first(((ListNode)node).getElements())).getLocation().getStart().getColumn() ? ((ListNode)node).getLocation().getStart().getLine() : previousNodeLine);
        KsonValueNode ksonValueNode = node;
        if (ksonValueNode instanceof ObjectNode) {
            this.validateObject((ObjectNode)node, previousLine, messageSink);
        } else if (ksonValueNode instanceof ListNode) {
            this.validateList((ListNode)node, previousLine, messageSink);
        } else if (ksonValueNode instanceof EmbedBlockNode || ksonValueNode instanceof UnquotedStringNode || ksonValueNode instanceof QuotedStringNode || ksonValueNode instanceof NumberNode || ksonValueNode instanceof TrueNode || ksonValueNode instanceof FalseNode || ksonValueNode instanceof NullNode || ksonValueNode instanceof KsonValueNodeError) {
            // empty if block
        }
    }

    private final void validateObject(ObjectNode objNode, int previousNodeLine, MessageSink messageSink) {
        this.validateAlignment(objNode.getProperties(), previousNodeLine, MessageType.OBJECT_PROPERTIES_MISALIGNED, messageSink, (arg_0, arg_1) -> IndentValidator.validateObject$lambda$0(this, messageSink, arg_0, arg_1));
    }

    private final void validateList(ListNode listNode, int previousNodeLine, MessageSink messageSink) {
        this.validateAlignment(listNode.getElements(), previousNodeLine, MessageType.DASH_LIST_ITEMS_MISALIGNED, messageSink, (arg_0, arg_1) -> IndentValidator.validateList$lambda$1(this, messageSink, arg_0, arg_1));
    }

    private final <T extends AstNode> void validateAlignment(List<? extends T> items, int previousNodeLine, MessageType misalignmentMessage, MessageSink messageSink, Function2<? super T, ? super Integer, Unit> validateChild) {
        AstNode previousItem = null;
        for (AstNode item : items) {
            Object object = previousItem;
            int previousItemLine = object != null && (object = object.getLocation()) != null && (object = ((Location)object).getEnd()) != null ? ((Coordinates)object).getLine() : previousNodeLine;
            previousItem = item;
            validateChild.invoke((Object)item, (Object)previousItemLine);
        }
        if (items.size() < 2) {
            return;
        }
        int prevLine = previousNodeLine;
        Integer expectedColumn = null;
        for (AstNode item : items) {
            int itemColumn;
            if (item.getLocation().getStart().getLine() == prevLine) {
                prevLine = item.getLocation().getEnd().getLine();
                continue;
            }
            prevLine = item.getLocation().getEnd().getLine();
            if (expectedColumn == null) {
                expectedColumn = item.getLocation().getStart().getColumn();
            }
            if ((itemColumn = item.getLocation().getStart().getColumn()) == expectedColumn) continue;
            messageSink.error(item.getLocation().trimToFirstLine(), misalignmentMessage.create(new String[0]));
        }
    }

    private static final Unit validateObject$lambda$0(IndentValidator this$0, MessageSink $messageSink, ObjectPropertyNode property, int n) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (property instanceof ObjectPropertyNodeImpl) {
            this$0.validateNode(((ObjectPropertyNodeImpl)property).getValue(), ((ObjectPropertyNodeImpl)property).getKey().getLocation().getEnd().getLine(), $messageSink);
        }
        return Unit.INSTANCE;
    }

    private static final Unit validateList$lambda$1(IndentValidator this$0, MessageSink $messageSink, ListElementNode element, int lineBeforeElem) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof ListElementNodeImpl) {
            KsonValueNode value = ((ListElementNodeImpl)element).getValue();
            int prevLineNum = value instanceof ObjectNode || value instanceof ListNode ? ((ListElementNodeImpl)element).getLocation().getStart().getLine() : lineBeforeElem;
            this$0.validateNode(value, prevLineNum, $messageSink);
        }
        return Unit.INSTANCE;
    }
}

