/*
 * Decompiled with CFR 0.152.
 */
package org.kson;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kson.Analysis;
import org.kson.AstParseResult;
import org.kson.CompileTarget;
import org.kson.FormatOptions;
import org.kson.JsonParseResult;
import org.kson.KsonCore;
import org.kson.KsonKt;
import org.kson.Message;
import org.kson.MessageSeverity;
import org.kson.Position;
import org.kson.Result;
import org.kson.SchemaParseResult;
import org.kson.SchemaResult;
import org.kson.SchemaValidator;
import org.kson.YamlParseResult;
import org.kson.parser.LoggedMessage;
import org.kson.schema.JsonSchema;
import org.kson.tools.FormatterKt;
import org.kson.tools.KsonFormatterConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014H\u0000\u00a2\u0006\u0002\b\u0018\u00a8\u0006\u0019"}, d2={"Lorg/kson/Kson;", "", "<init>", "()V", "format", "", "kson", "formatOptions", "Lorg/kson/FormatOptions;", "toJson", "Lorg/kson/Result;", "retainEmbedTags", "", "toYaml", "analyze", "Lorg/kson/Analysis;", "parseSchema", "Lorg/kson/SchemaResult;", "schemaKson", "publishMessages", "", "Lorg/kson/Message;", "loggedMessages", "Lorg/kson/parser/LoggedMessage;", "publishMessages$kson_lib", "kson-lib"})
@SourceDebugExtension(value={"SMAP\nKson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Kson.kt\norg/kson/Kson\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,475:1\n1563#2:476\n1634#2,3:477\n*S KotlinDebug\n*F\n+ 1 Kson.kt\norg/kson/Kson\n*L\n106#1:476\n106#1:477,3\n*E\n"})
public final class Kson {
    @NotNull
    public static final Kson INSTANCE = new Kson();

    private Kson() {
    }

    @NotNull
    public final String format(@NotNull String kson, @NotNull FormatOptions formatOptions) {
        Intrinsics.checkNotNullParameter((Object)kson, (String)"kson");
        Intrinsics.checkNotNullParameter((Object)formatOptions, (String)"formatOptions");
        return FormatterKt.format((String)kson, (KsonFormatterConfig)formatOptions.toInternal$kson_lib());
    }

    public static /* synthetic */ String format$default(Kson kson, String string, FormatOptions formatOptions, int n, Object object) {
        if ((n & 2) != 0) {
            formatOptions = new FormatOptions(null, null, 3, null);
        }
        return kson.format(string, formatOptions);
    }

    @NotNull
    public final Result toJson(@NotNull String kson, boolean retainEmbedTags) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)kson, (String)"kson");
        CompileTarget.Json compileConfig = new CompileTarget.Json(retainEmbedTags, null, 2, null);
        JsonParseResult jsonParseResult = KsonCore.INSTANCE.parseToJson(kson, compileConfig);
        if (jsonParseResult.hasErrors()) {
            result = new Result.Failure(this.publishMessages$kson_lib(jsonParseResult.getMessages()));
        } else {
            String string = jsonParseResult.getJson();
            Intrinsics.checkNotNull((Object)string);
            result = new Result.Success(string);
        }
        return result;
    }

    public static /* synthetic */ Result toJson$default(Kson kson, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return kson.toJson(string, bl);
    }

    @NotNull
    public final Result toYaml(@NotNull String kson, boolean retainEmbedTags) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)kson, (String)"kson");
        CompileTarget.Yaml compileConfig = new CompileTarget.Yaml(false, retainEmbedTags, null, 5, null);
        YamlParseResult yamlParseResult = KsonCore.INSTANCE.parseToYaml(kson, compileConfig);
        if (yamlParseResult.hasErrors()) {
            result = new Result.Failure(this.publishMessages$kson_lib(yamlParseResult.getMessages()));
        } else {
            String string = yamlParseResult.getYaml();
            Intrinsics.checkNotNull((Object)string);
            result = new Result.Success(string);
        }
        return result;
    }

    public static /* synthetic */ Result toYaml$default(Kson kson, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return kson.toYaml(string, bl);
    }

    @NotNull
    public final Analysis analyze(@NotNull String kson) {
        Intrinsics.checkNotNullParameter((Object)kson, (String)"kson");
        AstParseResult parseResult = KsonCore.parseToAst$default((KsonCore)KsonCore.INSTANCE, (String)kson, null, (int)2, null);
        List tokens = KsonKt.access$convertTokens(parseResult.getLexedTokens());
        List<Message> messages = this.publishMessages$kson_lib(parseResult.getMessages());
        return new Analysis(messages, tokens);
    }

    @NotNull
    public final SchemaResult parseSchema(@NotNull String schemaKson) {
        Intrinsics.checkNotNullParameter((Object)schemaKson, (String)"schemaKson");
        SchemaParseResult schemaParseResult = KsonCore.INSTANCE.parseSchema(schemaKson);
        List<Message> messages = this.publishMessages$kson_lib(schemaParseResult.getMessages());
        JsonSchema jsonSchema = schemaParseResult.getJsonSchema();
        if (jsonSchema == null) {
            return new SchemaResult.Failure(messages);
        }
        JsonSchema jsonSchema2 = jsonSchema;
        if (!((Collection)messages).isEmpty()) {
            return new SchemaResult.Failure(messages);
        }
        return new SchemaResult.Success(new SchemaValidator(jsonSchema2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Message> publishMessages$kson_lib(@NotNull List<LoggedMessage> loggedMessages) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(loggedMessages, (String)"loggedMessages");
        Iterable $this$map$iv = loggedMessages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LoggedMessage loggedMessage = (LoggedMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            MessageSeverity severity = switch (WhenMappings.$EnumSwitchMapping$0[it.getMessage().getType().getSeverity().ordinal()]) {
                case 1 -> MessageSeverity.ERROR;
                case 2 -> MessageSeverity.WARNING;
                default -> throw new NoWhenBranchMatchedException();
            };
            collection.add(new Message(it.getMessage().toString(), severity, new Position(it.getLocation().getStart()), new Position(it.getLocation().getEnd())));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[org.kson.parser.messages.MessageSeverity.values().length];
            try {
                nArray[org.kson.parser.messages.MessageSeverity.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[org.kson.parser.messages.MessageSeverity.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

