/*
 * Decompiled with CFR 0.152.
 */
package org.kson;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kson.AstParseResult;
import org.kson.Kson;
import org.kson.KsonCore;
import org.kson.KsonValue;
import org.kson.Message;
import org.kson.parser.MessageSink;
import org.kson.schema.JsonSchema;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/kson/SchemaValidator;", "", "schema", "Lorg/kson/schema/JsonSchema;", "<init>", "(Lorg/kson/schema/JsonSchema;)V", "validate", "", "Lorg/kson/Message;", "kson", "", "kson-lib"})
public final class SchemaValidator {
    @NotNull
    private final JsonSchema schema;

    public SchemaValidator(@NotNull JsonSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.schema = schema;
    }

    @NotNull
    public final List<Message> validate(@NotNull String kson) {
        Intrinsics.checkNotNullParameter((Object)kson, (String)"kson");
        AstParseResult astParseResult = KsonCore.parseToAst$default((KsonCore)KsonCore.INSTANCE, (String)kson, null, (int)2, null);
        if (astParseResult.hasErrors()) {
            return Kson.INSTANCE.publishMessages$kson_lib(astParseResult.getMessages());
        }
        MessageSink messageSink = new MessageSink();
        KsonValue ksonValue = astParseResult.getKsonValue();
        if (ksonValue != null) {
            this.schema.validate(ksonValue, messageSink);
        }
        return Kson.INSTANCE.publishMessages$kson_lib(messageSink.loggedMessages());
    }
}

