/*
 * Decompiled with CFR 0.152.
 */
package org.kt3k.straw.plugin;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import org.kt3k.straw.StrawDrink;
import org.kt3k.straw.StrawPlugin;
import org.kt3k.straw.annotation.PluginAction;

public class UriPlugin
extends StrawPlugin {
    static final String NO_URI = "13001";
    static final String ACTIVITY_NOT_FOUND = "13002";

    public String getName() {
        return "uri";
    }

    @PluginAction
    public void open(StrawPlugin.SingleStringParam param, StrawDrink drink) {
        String uri = param.value;
        if (uri == null) {
            drink.fail(NO_URI, "no uri given");
            return;
        }
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)uri));
        try {
            this.activity.startActivity(intent);
            drink.success();
        }
        catch (ActivityNotFoundException e) {
            drink.fail(ACTIVITY_NOT_FOUND, "activity not found for uri: " + uri);
        }
    }
}

