/*
 * Decompiled with CFR 0.152.
 */
package org.kt3k.straw;

import com.google.gson.JsonSyntaxException;
import org.kt3k.straw.ActionResult;
import org.kt3k.straw.Straw;
import org.kt3k.straw.StrawLog;
import org.kt3k.straw.StrawPluginAction;
import org.kt3k.straw.StrawPluginActionRepository;
import org.kt3k.straw.StrawUtil;

public class StrawDrink {
    private Straw straw;
    private Boolean keepAlive = false;
    private String pluginName;
    private String actionName;
    private String argumentJson;
    private String callbackId;
    private String resultJson;
    private Boolean isSuccess = false;

    public StrawDrink(String pluginName, String actionName, String argumentJson, String callbackId, Straw straw) {
        this.straw = straw;
        this.pluginName = pluginName;
        this.actionName = actionName;
        this.argumentJson = argumentJson;
        this.callbackId = callbackId;
    }

    public void exec() {
        Object argumentObject;
        StrawPluginActionRepository repo = this.straw.getRegistry().getActionRepositoryForPluginName(this.pluginName);
        if (repo == null) {
            StrawLog.printFrameworkError("No such plugin: " + this.toString());
            return;
        }
        StrawPluginAction action = repo.get(this.actionName);
        if (action == null) {
            StrawLog.printFrameworkError("No such plugin action: " + this.toString());
            return;
        }
        try {
            argumentObject = StrawUtil.jsonToObj(this.argumentJson, action.getArgumentType());
        }
        catch (JsonSyntaxException e) {
            StrawLog.printFrameworkError(e, "JSON parse error: " + this.toString());
            return;
        }
        action.invoke(argumentObject, this);
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    public String getResultJson() {
        return this.resultJson;
    }

    public String getArgumentJson() {
        return this.argumentJson;
    }

    public Boolean isSuccess() {
        return this.isSuccess;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Boolean bool) {
        this.keepAlive = bool;
    }

    public void success() {
        this.postResult(true, new Object());
    }

    public void success(Integer value) {
        this.postResult(true, new SingleIntegerValueResult(value));
    }

    public void success(String value) {
        this.postResult(true, new SingleStringValueResult(value));
    }

    public void success(Object value) {
        this.postResult(true, value);
    }

    public void fail(String errorId, String errorMessage) {
        this.postResult(false, new ErrorResult(errorId, errorMessage));
    }

    private void postResult(Boolean isSuccess, Object value) {
        this.isSuccess = isSuccess;
        try {
            this.resultJson = StrawUtil.objToJson(value);
        }
        catch (Throwable e) {
            StrawLog.printFrameworkError(e, "unknown error: " + this.toString());
            return;
        }
        this.straw.postJsMessage(ActionResult.toJsMessage(this));
    }

    public String toString() {
        return "plugin=" + this.getPluginName() + " action=" + this.getActionName() + " argumentJson=" + this.getArgumentJson() + " callbackId=" + this.getCallbackId();
    }

    static class ErrorResult {
        public String code;
        public String message;

        public ErrorResult(String id, String message) {
            this.code = id;
            this.message = message;
        }
    }

    public static class SingleIntegerValueResult {
        public Integer value;

        public SingleIntegerValueResult(Integer value) {
            this.value = value;
        }
    }

    public static class SingleStringValueResult {
        public String value;

        public SingleStringValueResult(String value) {
            this.value = value;
        }
    }
}

