/*
 * Decompiled with CFR 0.152.
 */
package org.kt3k.straw;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.kt3k.straw.StrawEvent;
import org.kt3k.straw.StrawEventHandler;
import org.kt3k.straw.StrawPlugin;
import org.kt3k.straw.StrawUtil;
import org.kt3k.straw.annotation.Background;
import org.kt3k.straw.annotation.EventHandler;
import org.kt3k.straw.annotation.RunOnUiThread;

public class StrawEventHandlerFactory {
    private static final Boolean DEFAULT_BACKGROUND = false;

    public static StrawEventHandler create(StrawPlugin plugin, Method method) {
        EventHandler annotation = method.getAnnotation(EventHandler.class);
        if (annotation != null && StrawEventHandlerFactory.hasValidSignature(method).booleanValue()) {
            return new StrawEventHandler(plugin, annotation.value(), method, StrawEventHandlerFactory.isBackgroundHandler(method));
        }
        return null;
    }

    public static List<StrawEventHandler> create(StrawPlugin plugin) {
        ArrayList<StrawEventHandler> handlers = new ArrayList<StrawEventHandler>();
        for (Method method : plugin.getClass().getMethods()) {
            StrawEventHandler handler = StrawEventHandlerFactory.create(plugin, method);
            if (handler == null) continue;
            handlers.add(handler);
        }
        return handlers;
    }

    public static List<StrawEventHandler> create(StrawPlugin[] plugins) {
        ArrayList<StrawEventHandler> handlers = new ArrayList<StrawEventHandler>();
        for (StrawPlugin plugin : plugins) {
            for (StrawEventHandler handler : StrawEventHandlerFactory.create(plugin)) {
                handlers.add(handler);
            }
        }
        return handlers;
    }

    private static Boolean hasValidSignature(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length == 1 && parameterTypes[0] == StrawEvent.class;
    }

    static Boolean isBackgroundHandler(Method method) {
        if (StrawUtil.hasAnnotation(method, Background.class).booleanValue()) {
            return true;
        }
        if (StrawUtil.hasAnnotation(method, RunOnUiThread.class).booleanValue()) {
            return false;
        }
        return DEFAULT_BACKGROUND;
    }
}

