/*
 * Decompiled with CFR 0.152.
 */
package org.kt3k.straw;

import android.util.Printer;
import org.kt3k.straw.StrawLogErrorPrinter;

public class StrawLog {
    static final String MESSAGE_FRAMEWORK_ERROR = "Straw Framework Error: ";
    static final String MESSAGE_PLUGIN_ERROR = "Straw Plugin Error: ";
    static Printer output = new StrawLogErrorPrinter();
    static Boolean printStackTrace = true;

    private static void printError(String message, Throwable e) {
        output.println(message);
        if (e != null) {
            output.println(e.toString());
            for (StackTraceElement elm : e.getStackTrace()) {
                output.println(elm.toString());
            }
        }
    }

    public static void setPrinter(Printer printer) {
        output = printer;
    }

    public static Boolean getPrintStackTrace() {
        return printStackTrace;
    }

    public static void setPrintStackTrace(Boolean printStackTrace) {
        StrawLog.printStackTrace = printStackTrace;
    }

    public static void printFrameworkError(Throwable e, String message) {
        StrawLog.printError(MESSAGE_FRAMEWORK_ERROR + message, e);
    }

    public static void printFrameworkError(String message) {
        StrawLog.printError(MESSAGE_FRAMEWORK_ERROR + message, null);
    }

    public static void printPluginError(Throwable e, String message) {
        StrawLog.printError(MESSAGE_PLUGIN_ERROR + message, e);
    }

    public static void printPluginError(String message) {
        StrawLog.printError(MESSAGE_PLUGIN_ERROR + message, null);
    }
}

