/*
 * Decompiled with CFR 0.152.
 */
package org.kt3k.straw;

import android.app.Activity;
import android.content.Context;
import android.webkit.WebView;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.kt3k.straw.StrawLog;
import org.kt3k.straw.StrawPluginAction;
import org.kt3k.straw.StrawPluginActionFactory;

public abstract class StrawPlugin {
    protected WebView webView;
    protected Context context;
    protected Activity activity;

    public List<StrawPluginAction> createPluginActions() {
        Method[] methods = this.getClass().getDeclaredMethods();
        ArrayList<StrawPluginAction> actions = new ArrayList<StrawPluginAction>();
        for (Method method : methods) {
            StrawPluginAction action = StrawPluginActionFactory.createPluginAction(method, this);
            if (action == null) continue;
            actions.add(action);
        }
        return actions;
    }

    public void setWebView(WebView webView) {
        this.webView = webView;
    }

    public void setContext(Context context) {
        this.context = context;
        if (context instanceof Activity) {
            this.activity = (Activity)context;
        } else {
            StrawLog.printFrameworkError("WebView.getContext() is not an Activity. A Plugin which depends on activity doesn't work.");
        }
    }

    public abstract String getName();

    public static class SingleIntegerParam {
        public Integer value;
    }

    public static class SingleStringParam {
        public String value;
    }

    public static class EventType {
        public static final String BACK_PRESSED = "backPressed";
    }
}

