/*
 * Decompiled with CFR 0.152.
 */
package org.kt3k.straw;

import java.lang.reflect.Method;
import org.kt3k.straw.StrawDrink;
import org.kt3k.straw.StrawLog;
import org.kt3k.straw.StrawPlugin;
import org.kt3k.straw.StrawPluginAction;
import org.kt3k.straw.annotation.Background;
import org.kt3k.straw.annotation.PluginAction;
import org.kt3k.straw.annotation.RunOnUiThread;

public class StrawPluginActionFactory {
    static final Boolean IS_BACKGROUND_DEFAULT = true;

    public static StrawPluginAction createPluginAction(Method method, StrawPlugin plugin) {
        if (StrawPluginActionFactory.isValidPluginAction(method).booleanValue()) {
            Boolean isBackground = IS_BACKGROUND_DEFAULT;
            if (StrawPluginActionFactory.hasRunOnUiThreadAnnotation(method).booleanValue()) {
                isBackground = false;
            }
            if (StrawPluginActionFactory.hasBackgroundAnnotation(method).booleanValue()) {
                isBackground = true;
            }
            return new StrawPluginAction(plugin, method, method.getName(), StrawPluginActionFactory.getArgumentTypeOfPluginAction(method), isBackground);
        }
        return null;
    }

    private static Boolean isValidPluginActionParameterTypes(Class<?>[] parameterTypes) {
        return parameterTypes.length == 2 && StrawDrink.class.isAssignableFrom(parameterTypes[1]);
    }

    private static Boolean isValidPluginAction(Method method) {
        if (StrawPluginActionFactory.hasPluginActionAnnotation(method).booleanValue()) {
            if (StrawPluginActionFactory.isValidPluginActionParameterTypes(method.getParameterTypes()).booleanValue()) {
                return true;
            }
            StrawLog.printFrameworkError("Wrong Parameter Signature For Action Method: action=" + method.getName() + " for class=" + method.getClass().getCanonicalName());
        }
        return false;
    }

    private static Boolean hasPluginActionAnnotation(Method method) {
        return method.getAnnotation(PluginAction.class) != null;
    }

    private static Boolean hasRunOnUiThreadAnnotation(Method method) {
        return method.getAnnotation(RunOnUiThread.class) != null;
    }

    private static Boolean hasBackgroundAnnotation(Method method) {
        return method.getAnnotation(Background.class) != null;
    }

    private static Class<?> getArgumentTypeOfPluginAction(Method method) {
        return method.getParameterTypes()[0];
    }
}

