/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.SequenceAssociate;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;

public abstract class AwardAssociate
extends KraPersistableBusinessObjectBase
implements SequenceAssociate<Award>,
Serializable {
    private static final long serialVersionUID = -1966175324490120727L;
    private String awardNumber;
    private Integer sequenceNumber;
    private Award award;

    public String getAwardNumber() {
        return this.awardNumber;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Award getAward() {
        return this.award;
    }

    public void setAwardNumber(String awardNumber) {
        this.awardNumber = awardNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setAward(Award award) {
        this.award = award;
        if (award != null) {
            this.setSequenceNumber(award.getSequenceNumber());
            this.setAwardNumber(award.getAwardNumber());
        } else {
            this.setSequenceNumber(0);
            this.setAwardNumber("");
        }
    }

    @Override
    protected void prePersist() {
        super.prePersist();
        if (this.award != null && !StringUtils.equals((String)this.award.getAwardNumber(), (String)this.getAwardNumber())) {
            this.setSequenceNumber(this.award.getSequenceNumber());
            this.setAwardNumber(this.award.getAwardNumber());
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.awardNumber == null ? 0 : this.awardNumber.hashCode());
        result = 31 * result + (this.sequenceNumber == null ? 0 : this.sequenceNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwardAssociate)) {
            return false;
        }
        AwardAssociate other = (AwardAssociate)obj;
        if (this.awardNumber == null ? other.awardNumber != null : !this.awardNumber.equals(other.awardNumber)) {
            return false;
        }
        return !(this.sequenceNumber == null ? other.sequenceNumber != null : !this.sequenceNumber.equals(other.sequenceNumber));
    }

    @Override
    public Award getSequenceOwner() {
        return this.getAward();
    }

    @Override
    public void setSequenceOwner(Award newlyVersionedOwner) {
        this.setAward(newlyVersionedOwner);
    }
}

