/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.sql.Date;
import org.kuali.rice.krad.util.MessageMap;

public class AwardDateRulesHelper {
    public static final String OBLIGATION_START_DATE = "Obligation Start Date";
    public static final String OBLIGATION_END_DATE = "Obligation End Date";
    public static final String PROJECT_START_DATE = "Project Start Date";
    public static final String PROJECT_END_DATE = "Project End Date";

    public static boolean validateObligationStartBeforeObligationEnd(MessageMap errorMap, Date obligationStartDate, Date obligationEndDate, String fieldName, String awardID) {
        boolean success = true;
        if (AwardDateRulesHelper.isDateOneAfterDateTwo(obligationStartDate, obligationEndDate)) {
            success = false;
            errorMap.putError(fieldName, "error.start.date.on.or.before", new String[]{OBLIGATION_START_DATE, OBLIGATION_END_DATE, awardID});
        }
        return success;
    }

    public static boolean validateObligationStartBeforeProjectEnd(MessageMap errorMap, Date obligationStartDate, Date projectEndDate, String fieldName, String awardID) {
        boolean success = true;
        if (AwardDateRulesHelper.isDateOneAfterDateTwo(obligationStartDate, projectEndDate)) {
            success = false;
            errorMap.putError(fieldName, "error.start.date.on.or.before", new String[]{OBLIGATION_START_DATE, PROJECT_END_DATE, awardID});
        }
        return success;
    }

    public static boolean validateObligationEndBeforeProjectEnd(MessageMap errorMap, Date obligationEndDate, Date projectEndDate, String fieldName, String awardID) {
        boolean success = true;
        if (AwardDateRulesHelper.isDateOneAfterDateTwo(obligationEndDate, projectEndDate)) {
            success = false;
            errorMap.putError(fieldName, "error.start.date.on.or.before", new String[]{OBLIGATION_END_DATE, PROJECT_END_DATE, awardID});
        }
        return success;
    }

    public static boolean validateProjectStartBeforeObligationStart(MessageMap errorMap, Date projectStartDate, Date obligationStartDate, String fieldName, String awardID) {
        boolean success = true;
        if (AwardDateRulesHelper.isDateOneAfterDateTwo(projectStartDate, obligationStartDate)) {
            success = false;
            errorMap.putError(fieldName, "error.start.date.on.or.before", new String[]{PROJECT_START_DATE, OBLIGATION_START_DATE, awardID});
        }
        return success;
    }

    public static boolean validateProjectStartBeforeObligationEnd(MessageMap errorMap, Date projectStartDate, Date obligationEndDate, String fieldName, String awardID) {
        boolean success = true;
        if (AwardDateRulesHelper.isDateOneAfterDateTwo(projectStartDate, obligationEndDate)) {
            success = false;
            errorMap.putError(fieldName, "error.start.date.on.or.before", new String[]{PROJECT_START_DATE, OBLIGATION_END_DATE, awardID});
        }
        return success;
    }

    public static boolean validateProjectStartBeforeProjectEnd(MessageMap errorMap, Date projectStartDate, Date projectEndDate, String fieldName, String awardID) {
        boolean success = true;
        if (AwardDateRulesHelper.isDateOneAfterDateTwo(projectStartDate, projectEndDate)) {
            success = false;
            errorMap.putError(fieldName, "error.start.date.on.or.before", new String[]{PROJECT_START_DATE, PROJECT_END_DATE, awardID});
        }
        return success;
    }

    public static boolean isDateOneAfterDateTwo(Date dateOne, Date dateTwo) {
        boolean valid = false;
        if (dateOne != null && dateTwo != null && dateOne.after(dateTwo)) {
            valid = true;
        }
        return valid;
    }
}

