/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.AwardTemplateSyncScope;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyBean;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyTempObject;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncBean;
import org.kuali.kra.award.budget.AwardBudgetLimitsBean;
import org.kuali.kra.award.budget.BudgetLimitSummaryHelper;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.commitments.CostShareFormHelper;
import org.kuali.kra.award.contacts.AwardCentralAdminContactsBean;
import org.kuali.kra.award.contacts.AwardCreditSplitBean;
import org.kuali.kra.award.contacts.AwardProjectPersonnelBean;
import org.kuali.kra.award.contacts.AwardSponsorContactsBean;
import org.kuali.kra.award.contacts.AwardUnitContactsBean;
import org.kuali.kra.award.customdata.CustomDataHelper;
import org.kuali.kra.award.detailsdates.DetailsAndDatesFormHelper;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.approvedsubawards.ApprovedSubawardFormHelper;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposalBean;
import org.kuali.kra.award.notesandattachments.attachments.AwardAttachmentFormBean;
import org.kuali.kra.award.notesandattachments.comments.AwardCommentBean;
import org.kuali.kra.award.notesandattachments.notes.AwardNotepadBean;
import org.kuali.kra.award.notification.AwardNotificationContext;
import org.kuali.kra.award.paymentreports.ReportClass;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportsBean;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTracking;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTrackingBean;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingService;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseoutBean;
import org.kuali.kra.award.paymentreports.paymentschedule.PaymentScheduleBean;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.ApprovedEquipmentBean;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.ApprovedForeignTravelBean;
import org.kuali.kra.award.permissions.PermissionsHelper;
import org.kuali.kra.award.printing.AwardPrintNotice;
import org.kuali.kra.award.printing.AwardTransactionSelectorBean;
import org.kuali.kra.award.specialreview.SpecialReviewHelper;
import org.kuali.kra.award.web.struts.action.SponsorTermFormHelper;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.common.notification.web.struts.form.NotificationHelper;
import org.kuali.kra.common.permissions.web.struts.form.PermissionsForm;
import org.kuali.kra.external.award.web.AccountCreationPresentationHelper;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.medusa.MedusaBean;
import org.kuali.kra.service.AwardHierarchyUIService;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.kra.web.struts.form.Auditable;
import org.kuali.kra.web.struts.form.BudgetVersionFormBase;
import org.kuali.kra.web.struts.form.CustomDataDocumentForm;
import org.kuali.kra.web.struts.form.MultiLookupFormBase;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.datadictionary.HeaderNavigation;
import org.kuali.rice.kns.util.ActionFormUtilMap;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.kns.web.ui.HeaderField;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class AwardForm
extends BudgetVersionFormBase
implements MultiLookupFormBase,
Auditable,
PermissionsForm,
CustomDataDocumentForm {
    public static final String SAVE = "save";
    public static final String RELOAD = "reload";
    private static final String CUSTOM_DATA_NAV_TO = "customData";
    private static final int NUMBER_30 = 30;
    public static final String COLUMN = ":";
    public static final String UPDATE_TIMESTAMP_DD_NAME = "DataDictionary.Award.attributes.updateTimestamp";
    public static final String SPONSOR_DD_NAME = "DataDictionary.Sponsor.attributes.sponsorName";
    private static final Log LOG = LogFactory.getLog(AwardForm.class);
    private final String AWARD_HIERARCHY_TEMP_OBJ_PARAM_NAME_PREFIX = "awardHierarchyTempObject[";
    private final int AWARD_HIERARCHY_TEMP_OBJ_PARAM_NAME_PREFIX_LENGTH = "awardHierarchyTempObject[".length();
    private static final long serialVersionUID = -7633960906991275328L;
    private static final String PAYMENT_SCHEDULE_ACTIVE_LINKS_PARAMETER = "AwardPaymentScheduleActiveLinks";
    private static Boolean displayAwardPaymentScheduleActiveLinkFields;
    private String lookupResultsBOClassName;
    private String lookupResultsSequenceNumber;
    private String prevAwardNumber;
    private String prevRootAwardNumber;
    private AwardComment newAwardCostShareComment;
    private AwardFandaRate newAwardFandaRate;
    private List<ConcreteKeyValue> reportClasses;
    private String directIndirectViewEnabled;
    private ApprovedEquipmentBean approvedEquipmentBean;
    private AwardProjectPersonnelBean projectPersonnelBean;
    private AwardUnitContactsBean unitContactsBean;
    private AwardCentralAdminContactsBean centralAdminContactsBean;
    private AwardSponsorContactsBean sponsorContactsBean;
    private CostShareFormHelper costShareFormHelper;
    private SponsorTermFormHelper sponsorTermFormHelper;
    private ApprovedSubawardFormHelper approvedSubawardFormHelper;
    private DetailsAndDatesFormHelper detailsAndDatesFormHelper;
    private AwardCloseoutBean awardCloseoutBean;
    private ReportClass reportClassForPaymentsAndInvoices;
    private PaymentScheduleBean paymentScheduleBean;
    private ApprovedForeignTravelBean approvedForeignTravelBean;
    private AwardReportsBean awardReportsBean;
    private AwardCommentBean awardCommentBean;
    private AwardNotepadBean awardNotepadBean;
    private AwardAttachmentFormBean awardAttachmentFormBean;
    private MedusaBean medusaBean;
    private AwardBudgetLimitsBean awardBudgetLimitsBean;
    private boolean auditActivated;
    private CustomDataHelper customDataHelper = new CustomDataHelper(this);
    private PermissionsHelper permissionsHelper;
    private SpecialReviewHelper specialReviewHelper;
    private NotificationHelper<AwardNotificationContext> notificationHelper;
    private AwardCreditSplitBean awardCreditSplitBean;
    private Map<String, AwardHierarchy> awardHierarchyNodes;
    private String awardNumberInputTemp;
    private AwardFundingProposalBean fundingProposalBean;
    private String awardHierarchy;
    private String awardNumber;
    private String addRA;
    private String deletedRas;
    private String rootAwardNumber;
    private AwardHierarchyBean awardHierarchyBean;
    private AwardPrintNotice awardPrintNotice;
    private AwardTransactionSelectorBean awardPrintChangeReport;
    private AwardTransactionSelectorBean awardTimeAndMoneyTransactionReport;
    private List<AwardComment> awardCommentHistoryByType;
    private Map<AwardTemplateSyncScope, Boolean> syncRequiresConfirmationMap;
    private AwardTemplateSyncScope[] currentSyncScopes;
    private String currentSyncQuestionId;
    private Integer oldTemplateCode;
    private boolean templateLookup = false;
    private String newProposalBudgetPeriods;
    private String currentAwardNumber;
    private String currentSeqNumber;
    private List<List<BudgetDecimal>> personnelBudgetLimits = new ArrayList<List<BudgetDecimal>>();
    private List<List<BudgetDecimal>> nonPersonnelBudgetLimits = new ArrayList<List<BudgetDecimal>>();
    private List<List<BudgetDecimal>> totalBudgetLimits = new ArrayList<List<BudgetDecimal>>();
    private List<ReportTracking> reportTrackingsToDelete = new ArrayList<ReportTracking>();
    private boolean viewFundingSource;
    private boolean syncMode;
    private AwardSyncBean awardSyncBean;
    private Long placeHolderAwardId;
    private boolean docOpenedFromAwardSearch;
    private BudgetLimitSummaryHelper budgetLimitSummary;
    private transient ParameterService parameterService;
    private transient AwardHierarchyUIService awardHierarchyUIService;
    private transient ReportTrackingService reportTrackingService;
    private List<ReportTrackingBean> reportTrackingBeans;
    private AccountCreationPresentationHelper accountCreationHelper;

    public AwardForm() {
        this.initialize();
    }

    @Override
    protected String getDefaultDocumentTypeName() {
        return "AwardDocument";
    }

    public void initialize() {
        this.newAwardFandaRate = new AwardFandaRate();
        this.awardCommentHistoryByType = new ArrayList<AwardComment>();
        this.costShareFormHelper = new CostShareFormHelper(this);
        this.centralAdminContactsBean = new AwardCentralAdminContactsBean(this);
        this.sponsorTermFormHelper = new SponsorTermFormHelper(this);
        this.approvedSubawardFormHelper = new ApprovedSubawardFormHelper(this);
        this.approvedEquipmentBean = new ApprovedEquipmentBean(this);
        this.paymentScheduleBean = new PaymentScheduleBean(this);
        this.approvedForeignTravelBean = new ApprovedForeignTravelBean(this);
        this.projectPersonnelBean = new AwardProjectPersonnelBean(this);
        this.unitContactsBean = new AwardUnitContactsBean(this);
        this.sponsorContactsBean = new AwardSponsorContactsBean(this);
        this.detailsAndDatesFormHelper = new DetailsAndDatesFormHelper(this);
        this.awardReportsBean = new AwardReportsBean(this);
        this.awardNotepadBean = new AwardNotepadBean(this);
        this.awardAttachmentFormBean = new AwardAttachmentFormBean(this);
        this.setPermissionsHelper(new PermissionsHelper(this));
        this.setSpecialReviewHelper(new SpecialReviewHelper(this));
        this.setNotificationHelper(new NotificationHelper<AwardNotificationContext>());
        this.awardCreditSplitBean = new AwardCreditSplitBean(this);
        this.awardCommentBean = new AwardCommentBean(this);
        this.awardCloseoutBean = new AwardCloseoutBean(this);
        this.awardHierarchyNodes = new TreeMap<String, AwardHierarchy>();
        this.fundingProposalBean = new AwardFundingProposalBean(this);
        this.awardPrintNotice = new AwardPrintNotice();
        this.awardPrintChangeReport = new AwardTransactionSelectorBean();
        this.buildReportTrackingBeans();
        this.awardHierarchyBean = new AwardHierarchyBean(this);
        this.medusaBean = new MedusaBean();
        this.syncRequiresConfirmationMap = null;
        this.currentSyncScopes = null;
        this.syncMode = false;
        this.awardSyncBean = new AwardSyncBean(this);
        this.setDirectIndirectViewEnabled(this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST"));
        this.budgetLimitSummary = new BudgetLimitSummaryHelper();
        this.awardBudgetLimitsBean = new AwardBudgetLimitsBean(this);
        this.accountCreationHelper = new AccountCreationPresentationHelper();
    }

    public void buildReportTrackingBeans() {
        this.reportTrackingBeans = new ArrayList<ReportTrackingBean>();
        int numberOfReportItems = this.getAwardDocument().getAward().getAwardReportTermItems().size();
        for (int i = 0; i < numberOfReportItems; ++i) {
            this.reportTrackingBeans.add(new ReportTrackingBean());
        }
    }

    public AwardDocument getAwardDocument() {
        return (AwardDocument)super.getDocument();
    }

    public ApprovedEquipmentBean getApprovedEquipmentBean() {
        return this.approvedEquipmentBean;
    }

    public ApprovedForeignTravelBean getApprovedForeignTravelBean() {
        return this.approvedForeignTravelBean;
    }

    public AwardCentralAdminContactsBean getCentralAdminContactsBean() {
        return this.centralAdminContactsBean;
    }

    public CostShareFormHelper getCostShareFormHelper() {
        return this.costShareFormHelper;
    }

    public AwardCommentBean getAwardCommentBean() {
        return this.awardCommentBean;
    }

    public void initializeFormOrDocumentBasedOnCommand() {
        if ("initiate".equals(this.getCommand())) {
            this.getAwardDocument().initialize();
        } else {
            this.initialize();
        }
    }

    public AwardComment getNewAwardCostShareComment() {
        return this.newAwardCostShareComment;
    }

    public void setNewAwardCostShareComment(AwardComment newAwardCostShareComment) {
        this.newAwardCostShareComment = newAwardCostShareComment;
    }

    public AwardFandaRate getNewAwardFandaRate() {
        return this.newAwardFandaRate;
    }

    public void setNewAwardFandaRate(AwardFandaRate newAwardFandaRate) {
        this.newAwardFandaRate = newAwardFandaRate;
    }

    @Override
    protected void setSaveDocumentControl(Map editMode) {
        this.getDocumentActions().put("canSave", "true");
    }

    @Override
    protected String getLockRegion() {
        return "AWARD";
    }

    @Override
    public String getLookupResultsBOClassName() {
        return this.lookupResultsBOClassName;
    }

    @Override
    public void setLookupResultsBOClassName(String lookupResultsBOClassName) {
        this.lookupResultsBOClassName = lookupResultsBOClassName;
    }

    @Override
    public String getLookupResultsSequenceNumber() {
        return this.lookupResultsSequenceNumber;
    }

    @Override
    public void setLookupResultsSequenceNumber(String lookupResultsSequenceNumber) {
        this.lookupResultsSequenceNumber = lookupResultsSequenceNumber;
    }

    public List<AwardComment> getAwardCommentHistoryByType() {
        return this.awardCommentHistoryByType;
    }

    public void setAwardCommentHistoryByType(List<AwardComment> awardCommentHistoryByType) {
        this.awardCommentHistoryByType = awardCommentHistoryByType;
    }

    public String getSelectedLeadUnit() {
        return this.projectPersonnelBean.getSelectedLeadUnit();
    }

    public AwardSponsorContactsBean getSponsorContactsBean() {
        return this.sponsorContactsBean;
    }

    public AccountCreationPresentationHelper getAccountCreationHelper() {
        return this.accountCreationHelper;
    }

    public AwardUnitContactsBean getUnitContactsBean() {
        return this.unitContactsBean;
    }

    public AwardProjectPersonnelBean getProjectPersonnelBean() {
        return this.projectPersonnelBean;
    }

    public List<ConcreteKeyValue> getReportClasses() {
        if (this.reportClasses != null) {
            Collections.sort(this.reportClasses);
        }
        return this.reportClasses;
    }

    public void setReportClasses(List<ConcreteKeyValue> reportClasses) {
        this.reportClasses = reportClasses;
    }

    public ApprovedSubawardFormHelper getApprovedSubawardFormHelper() {
        return this.approvedSubawardFormHelper;
    }

    public void setApprovedSubawardFormHelper(ApprovedSubawardFormHelper approvedSubawardFormHelper) {
        this.approvedSubawardFormHelper = approvedSubawardFormHelper;
    }

    public ReportClass getReportClassForPaymentsAndInvoices() {
        return this.reportClassForPaymentsAndInvoices;
    }

    public void setReportClassForPaymentsAndInvoices(ReportClass reportClassForPaymentsAndInvoices) {
        this.reportClassForPaymentsAndInvoices = reportClassForPaymentsAndInvoices;
    }

    public SponsorTermFormHelper getSponsorTermFormHelper() {
        return this.sponsorTermFormHelper;
    }

    public void setSelectedLeadUnit(String unitName) {
        this.projectPersonnelBean.setSelectedLeadUnit(unitName);
    }

    public void setSponsorTermFormHelper(SponsorTermFormHelper sponsorTermFormHelper) {
        this.sponsorTermFormHelper = sponsorTermFormHelper;
    }

    public PaymentScheduleBean getPaymentScheduleBean() {
        return this.paymentScheduleBean;
    }

    public void setPaymentScheduleBean(PaymentScheduleBean paymentScheduleBean) {
        this.paymentScheduleBean = paymentScheduleBean;
    }

    @Override
    public boolean isAuditActivated() {
        return this.auditActivated;
    }

    @Override
    public void setAuditActivated(boolean auditActivated) {
        this.auditActivated = auditActivated;
    }

    public boolean isAwardInMultipleNodeHierarchy() {
        return this.getAwardDocument().getAward().isAwardInMultipleNodeHierarchy();
    }

    public boolean isAwardHasAssociatedTandMOrIsVersioned() {
        return this.getAwardDocument().getAward().isAwardHasAssociatedTandMOrIsVersioned();
    }

    public int getIndexOfAwardAmountInfoForDisplay() throws WorkflowException {
        return this.getAwardDocument().getAward().getIndexOfAwardAmountInfoForDisplay();
    }

    public DetailsAndDatesFormHelper getDetailsAndDatesFormHelper() {
        return this.detailsAndDatesFormHelper;
    }

    public void setDetailsAndDatesFormHelper(DetailsAndDatesFormHelper detailsAndDatesFormHelper) {
        this.detailsAndDatesFormHelper = detailsAndDatesFormHelper;
    }

    public SpecialReviewHelper getSpecialReviewHelper() {
        return this.specialReviewHelper;
    }

    public void setSpecialReviewHelper(SpecialReviewHelper specialReviewHelper) {
        this.specialReviewHelper = specialReviewHelper;
    }

    public NotificationHelper<AwardNotificationContext> getNotificationHelper() {
        return this.notificationHelper;
    }

    public void setNotificationHelper(NotificationHelper<AwardNotificationContext> notificationHelper) {
        this.notificationHelper = notificationHelper;
    }

    @Override
    public PermissionsHelper getPermissionsHelper() {
        return this.permissionsHelper;
    }

    public void setPermissionsHelper(PermissionsHelper awardPermissionsHelper) {
        this.permissionsHelper = awardPermissionsHelper;
    }

    public String getDocumentTypeName() {
        return "AwardDocument";
    }

    @Override
    public String getActionName() {
        return "award";
    }

    @Override
    public CustomDataHelper getCustomDataHelper() {
        return this.customDataHelper;
    }

    public void setCustomDataHelper(CustomDataHelper customDataHelper) {
        this.customDataHelper = customDataHelper;
    }

    public void setAwardAuditActivated(boolean awardAuditActivated) {
        this.auditActivated = awardAuditActivated;
    }

    public AwardCreditSplitBean getAwardCreditSplitBean() {
        return this.awardCreditSplitBean;
    }

    public void setAwardCreditSplitBean(AwardCreditSplitBean awardCreditSplitBean) {
        this.awardCreditSplitBean = awardCreditSplitBean;
    }

    public void setAwardProjectPersonnelBean(AwardProjectPersonnelBean projectPersonnelBean) {
        this.projectPersonnelBean = projectPersonnelBean;
    }

    public AwardReportsBean getAwardReportsBean() {
        return this.awardReportsBean;
    }

    public void setAwardReportsBean(AwardReportsBean awardReportsBean) {
        this.awardReportsBean = awardReportsBean;
    }

    public AwardCloseoutBean getAwardCloseoutBean() {
        return this.awardCloseoutBean;
    }

    public void setAwardCloseoutBean(AwardCloseoutBean awardCloseoutBean) {
        this.awardCloseoutBean = awardCloseoutBean;
    }

    public AwardNotepadBean getAwardNotepadBean() {
        return this.awardNotepadBean;
    }

    public void setAwardNotepadBean(AwardNotepadBean awardNotepadBean) {
        this.awardNotepadBean = awardNotepadBean;
    }

    public AwardAttachmentFormBean getAwardAttachmentFormBean() {
        return this.awardAttachmentFormBean;
    }

    public void setAwardAttachmentFormBean(AwardAttachmentFormBean awardAttachmentFormBean) {
        this.awardAttachmentFormBean = awardAttachmentFormBean;
    }

    public AwardFundingProposalBean getFundingProposalBean() {
        return this.fundingProposalBean;
    }

    public Map<String, AwardHierarchy> getAwardHierarchyNodes() {
        if (this.awardHierarchyNodes == null || this.awardHierarchyNodes.size() == 0) {
            this.awardHierarchyNodes = this.getAwardHierarchyBean().getAwardHierarchy(this.getAwardHierarchyBean().getRootNode(), new ArrayList<String>());
        }
        return this.awardHierarchyNodes;
    }

    public void setAwardHierarchyNodes(Map<String, AwardHierarchy> awardHierarchyNodes) {
        this.awardHierarchyNodes = awardHierarchyNodes;
    }

    public String getPrevAwardNumber() {
        return this.prevAwardNumber;
    }

    public void setPrevAwardNumber(String prevAwardNumber) {
        this.prevAwardNumber = prevAwardNumber;
    }

    public String getPrevRootAwardNumber() {
        return this.prevRootAwardNumber;
    }

    public void setPrevRootAwardNumber(String prevRootAwardNumber) {
        this.prevRootAwardNumber = prevRootAwardNumber;
    }

    public String getAwardNumberInputTemp() {
        return this.awardNumberInputTemp;
    }

    public void setAwardNumberInputTemp(String awardNumberInputTemp) {
        this.awardNumberInputTemp = awardNumberInputTemp;
    }

    public AwardHierarchyBean getAwardHierarchyBean() {
        return this.awardHierarchyBean;
    }

    public String getAwardHierarchy() throws ParseException {
        this.awardHierarchy = "";
        if (StringUtils.isBlank((String)this.awardNumber)) {
            this.awardNumber = this.getRootAwardNumber();
        }
        if (this.awardNumber != null && StringUtils.isNotBlank((String)this.addRA) && this.addRA.equals("E")) {
            this.setAwardHierarchy(this.getAwardHierarchyUIService().getSubAwardHierarchiesForTreeView(this.awardNumber, this.currentAwardNumber, this.currentSeqNumber));
        } else if (this.awardNumber != null && StringUtils.isNotBlank((String)this.addRA) && this.addRA.equals("N")) {
            this.setAwardHierarchy(this.getAwardHierarchyUIService().getRootAwardNode(this.awardNumber, this.currentAwardNumber, this.currentSeqNumber));
        }
        return this.awardHierarchy;
    }

    public void setAwardHierarchy(String awardHierarchy) {
        this.awardHierarchy = awardHierarchy;
    }

    public String getAwardNumber() {
        return this.awardNumber;
    }

    public void setAwardNumber(String awardNumber) {
        this.awardNumber = awardNumber;
    }

    public String getAddRA() {
        return this.addRA;
    }

    public void setAddRA(String addRA) {
        this.addRA = addRA;
    }

    public String getDeletedRas() {
        return this.deletedRas;
    }

    public void setDeletedRas(String deletedRas) {
        this.deletedRas = deletedRas;
    }

    private AwardHierarchyUIService getAwardHierarchyUIService() {
        if (this.awardHierarchyUIService == null) {
            this.awardHierarchyUIService = KraServiceLocator.getService(AwardHierarchyUIService.class);
        }
        return this.awardHierarchyUIService;
    }

    private ReportTrackingService getReportTrackingService() {
        if (this.reportTrackingService == null) {
            this.reportTrackingService = KraServiceLocator.getService(ReportTrackingService.class);
        }
        return this.reportTrackingService;
    }

    public boolean getDisplayRegenerateButton() {
        return !this.getReportTrackingService().autoRegenerateReports(this.getAwardDocument().getAward());
    }

    public String getRootAwardNumber() {
        return this.rootAwardNumber;
    }

    public void setRootAwardNumber(String rootAwardNumber) {
        this.rootAwardNumber = rootAwardNumber;
    }

    public AwardPrintNotice getAwardPrintNotice() {
        return this.awardPrintNotice;
    }

    public void setAwardPrintNotice(AwardPrintNotice awardPrintNotice) {
        this.awardPrintNotice = awardPrintNotice;
    }

    public AwardTransactionSelectorBean getAwardPrintChangeReport() {
        return this.awardPrintChangeReport;
    }

    public void setAwardPrintChangeReport(AwardTransactionSelectorBean awardPrintChangeReport) {
        this.awardPrintChangeReport = awardPrintChangeReport;
    }

    public List<AwardHierarchyTempObject> getAwardHierarchyTempObjects() {
        if (this.getAwardDocument().getAward().getAwardHierarchyTempObjects() == null) {
            this.getAwardDocument().getAward().initializeAwardHierarchyTempObjects();
        }
        return this.getAwardDocument().getAward().getAwardHierarchyTempObjects();
    }

    public AwardHierarchyTempObject getAwardHierarchyTempObject(int index) {
        while (this.getAwardHierarchyTempObjects().size() <= index) {
            this.getAwardDocument().getAward().getAwardHierarchyTempObjects().add(new AwardHierarchyTempObject());
        }
        return this.getAwardDocument().getAward().getAwardHierarchyTempObjects().get(index);
    }

    public String getValueFinderResultDoNotCache() {
        if (this.getActionFormUtilMap() instanceof ActionFormUtilMap) {
            ((ActionFormUtilMap)this.getActionFormUtilMap()).setCacheValueFinderResults(false);
        }
        return "";
    }

    public String getValueFinderResultCache() {
        if (this.getActionFormUtilMap() instanceof ActionFormUtilMap) {
            ((ActionFormUtilMap)this.getActionFormUtilMap()).setCacheValueFinderResults(true);
        }
        return "";
    }

    public List<ExtraButton> getExtraTopButtons() {
        this.extraButtons.clear();
        String externalImageURL = "kra.externalizable.images.url";
        String generatePeriodImage = this.lookupKualiConfigurationService().getPropertyValueAsString(externalImageURL) + "tinybutton-timemoney.gif";
        this.addExtraButton("methodToCall.timeAndMoney", generatePeriodImage, "Time And Money");
        return this.extraButtons;
    }

    private ConfigurationService lookupKualiConfigurationService() {
        return KRADServiceLocator.getKualiConfigurationService();
    }

    @Override
    protected void addExtraButton(String property, String source, String altText) {
        ExtraButton newButton = new ExtraButton();
        newButton.setExtraButtonProperty(property);
        newButton.setExtraButtonSource(source);
        newButton.setExtraButtonAltText(altText);
        this.extraButtons.add(newButton);
    }

    public MedusaBean getMedusaBean() {
        return this.medusaBean;
    }

    public void setMedusaBean(MedusaBean medusaBean) {
        this.medusaBean = medusaBean;
    }

    public void postprocessRequestParameters(Map requestParameters) {
        super.postprocessRequestParameters(requestParameters);
        Map parms = requestParameters;
        for (String parmKey : parms.keySet()) {
            if (!parmKey.startsWith("awardHierarchyTempObject[")) continue;
            this.populateAwardHierarchyTempObject(parms, parmKey);
        }
    }

    private void populateAwardHierarchyTempObject(Map<String, Object> parms, String parmKey) {
        int indexOfClosingBracket = parmKey.indexOf("]");
        String fieldName = parmKey.substring(indexOfClosingBracket + 2);
        Object fieldValue = parms.get(parmKey);
        int tempObjectIndex = Integer.valueOf(parmKey.substring(this.AWARD_HIERARCHY_TEMP_OBJ_PARAM_NAME_PREFIX_LENGTH, indexOfClosingBracket));
        AwardHierarchyTempObject tempObject = this.getAwardHierarchyTempObject(tempObjectIndex);
        this.populateAwardHierarchyTempObjectFromRequestParms(tempObject, fieldName, fieldValue);
        if (tempObject.getCopyDescendants() == null) {
            tempObject.setCopyDescendants(false);
        }
    }

    private void populateAwardHierarchyTempObjectFromRequestParms(AwardHierarchyTempObject tempObject, String fieldName, Object fieldValue) {
        try {
            BeanUtils.setProperty((Object)tempObject, (String)fieldName, (Object)fieldValue);
        }
        catch (Exception e) {
            String message = String.format("Attempt to set %s property to %s on AwardHierarchyTempObject resulted in exception", fieldName, fieldValue.toString());
            LOG.error((Object)message, (Throwable)e);
            throw new IllegalArgumentException(message, e);
        }
    }

    public Map<AwardTemplateSyncScope, Boolean> getSyncRequiresConfirmationMap() {
        return this.syncRequiresConfirmationMap;
    }

    public void setSyncRequiresConfirmationMap(Map<AwardTemplateSyncScope, Boolean> syncRequiresConfirmationMap) {
        this.syncRequiresConfirmationMap = syncRequiresConfirmationMap;
    }

    public void setCurrentSyncQuestionId(String currentSyncQuestionId) {
        this.currentSyncQuestionId = currentSyncQuestionId;
    }

    public String getCurrentSyncQuestionId() {
        return this.currentSyncQuestionId;
    }

    public AwardTemplateSyncScope[] getCurrentSyncScopes() {
        return this.currentSyncScopes;
    }

    public void setCurrentSyncScopes(AwardTemplateSyncScope[] currentSyncOperations) {
        this.currentSyncScopes = currentSyncOperations;
    }

    public Integer getOldTemplateCode() {
        return this.oldTemplateCode;
    }

    public void setOldTemplateCode(Integer oldTemplateCode) {
        this.oldTemplateCode = oldTemplateCode;
    }

    public boolean isTemplateLookup() {
        return this.templateLookup;
    }

    public void setTemplateLookup(boolean templateCodeChange) {
        this.templateLookup = templateCodeChange;
    }

    public List<Long> getLinkedProposals() {
        ArrayList<Long> linkedProposals = new ArrayList<Long>();
        if (this.getAwardDocument() != null && this.getAwardDocument().getAward() != null) {
            for (AwardFundingProposal fundingProposal : this.getAwardDocument().getAward().getFundingProposals()) {
                linkedProposals.add(fundingProposal.getProposalId());
            }
        }
        return linkedProposals;
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        AwardDocument awardDocument = this.getAwardDocument();
        this.getDocInfo().clear();
        this.getDocInfo().add(new HeaderField("DataDictionary.KraAttributeReferenceDummy.attributes.principalInvestigator", awardDocument.getAward().getPrincipalInvestigatorName()));
        String docIdAndStatus = COLUMN;
        if (workflowDocument != null) {
            docIdAndStatus = this.getAwardDocument().getDocumentNumber() + COLUMN + workflowDocument.getStatus().getLabel();
        }
        this.getDocInfo().add(new HeaderField("DataDictionary.Award.attributes.docIdStatus", docIdAndStatus));
        String unitName = awardDocument.getAward().getUnitName();
        if (StringUtils.isNotBlank((String)unitName) && unitName.length() > 30) {
            unitName = unitName.substring(0, 30);
        }
        this.getDocInfo().add(new HeaderField("DataDictionary.AwardPersonUnit.attributes.leadUnit", unitName));
        this.getDocInfo().add(new HeaderField("DataDictionary.Award.attributes.awardIdAccount", this.getAwardIdAccount(awardDocument)));
        this.setupSponsor(awardDocument);
        this.setupLastUpdate(awardDocument);
    }

    private String getAwardIdAccount(AwardDocument awardDocument) {
        String awardNum = awardDocument.getAward().getAwardNumber();
        String account = awardDocument.getAward().getAccountNumber() != null ? awardDocument.getAward().getAccountNumber() : "";
        return awardNum + COLUMN + account;
    }

    private void setupLastUpdate(AwardDocument awardDocument) {
        String createDateStr = null;
        String updateUser = null;
        if (awardDocument.getUpdateTimestamp() != null) {
            createDateStr = CoreApiServiceLocator.getDateTimeService().toString((Date)awardDocument.getUpdateTimestamp(), "MM/dd/yy");
            updateUser = awardDocument.getUpdateUser().length() > 30 ? awardDocument.getUpdateUser().substring(0, 30) : awardDocument.getUpdateUser();
            this.getDocInfo().add(new HeaderField(UPDATE_TIMESTAMP_DD_NAME, createDateStr + " by " + updateUser));
        } else {
            this.getDocInfo().add(new HeaderField(UPDATE_TIMESTAMP_DD_NAME, ""));
        }
    }

    private void setupSponsor(AwardDocument awardDocument) {
        if (awardDocument.getAward().getSponsor() == null) {
            this.getDocInfo().add(new HeaderField(SPONSOR_DD_NAME, ""));
        } else {
            String sponsorName = awardDocument.getAward().getSponsorName();
            if (StringUtils.isNotBlank((String)sponsorName) && sponsorName.length() > 30) {
                sponsorName = sponsorName.substring(0, 30);
            }
            this.getDocInfo().add(new HeaderField(SPONSOR_DD_NAME, sponsorName));
        }
    }

    public String getNewProposalBudgetPeriods() {
        return this.newProposalBudgetPeriods;
    }

    public void setNewProposalBudgetPeriods(String newProposalBudgetPeriods) {
        this.newProposalBudgetPeriods = newProposalBudgetPeriods;
    }

    public boolean getDisplayEditButton() {
        VersionHistory activeVersion;
        boolean displayEditButton;
        boolean bl = displayEditButton = !this.isViewOnly() && !this.getAwardDocument().isCanceled();
        if (this.isDocOpenedFromAwardSearch() || this.getAwardDocument().isPlaceHolderDocument()) {
            displayEditButton = true;
        }
        if ((activeVersion = this.getVersionHistoryService().findActiveVersion(Award.class, this.getAwardDocument().getAward().getAwardNumber())) != null) {
            displayEditButton &= activeVersion.getSequenceOwnerSequenceNumber().equals(this.getAwardDocument().getAward().getSequenceNumber());
        }
        return displayEditButton;
    }

    protected VersionHistoryService getVersionHistoryService() {
        return KraServiceLocator.getService(VersionHistoryService.class);
    }

    public String getCurrentAwardNumber() {
        return this.currentAwardNumber;
    }

    public void setCurrentAwardNumber(String currentAwardNumber) {
        this.currentAwardNumber = currentAwardNumber;
    }

    public String getCurrentSeqNumber() {
        return this.currentSeqNumber;
    }

    public void setCurrentSeqNumber(String currentSeqNumber) {
        this.currentSeqNumber = currentSeqNumber;
    }

    public String getCanCreateAward() {
        Boolean aFlag = this.getEditingMode().containsKey("canCreateAward");
        return aFlag.toString();
    }

    public boolean getViewFundingSource() {
        return this.viewFundingSource;
    }

    public void setViewFundingSource(boolean viewFundingSource) {
        this.viewFundingSource = viewFundingSource;
    }

    public void setAwardTimeAndMoneyTransactionReport(AwardTransactionSelectorBean awardTimeAndMoneyTransactionReport) {
        this.awardTimeAndMoneyTransactionReport = awardTimeAndMoneyTransactionReport;
    }

    public AwardTransactionSelectorBean getAwardTimeAndMoneyTransactionReport() {
        return this.awardTimeAndMoneyTransactionReport;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public String getDirectIndirectViewEnabled() {
        return this.directIndirectViewEnabled;
    }

    public boolean isSyncMode() {
        return this.syncMode;
    }

    public void setSyncMode(boolean syncMode) {
        this.syncMode = syncMode;
    }

    public AwardSyncBean getAwardSyncBean() {
        return this.awardSyncBean;
    }

    public void setAwardSyncBean(AwardSyncBean awardSyncBean) {
        this.awardSyncBean = awardSyncBean;
    }

    public void setDirectIndirectViewEnabled(String directIndirectViewEnabled) {
        this.directIndirectViewEnabled = directIndirectViewEnabled;
    }

    public HeaderNavigation[] getHeaderNavigationTabs() {
        HeaderNavigation[] navigation = super.getHeaderNavigationTabs();
        ArrayList<HeaderNavigation> resultList = new ArrayList<HeaderNavigation>();
        for (HeaderNavigation nav : navigation) {
            if (StringUtils.equals((String)nav.getHeaderTabNavigateTo(), (String)CUSTOM_DATA_NAV_TO)) {
                boolean displayTab = !this.getCustomDataHelper().getCustomAttributeDocuments().isEmpty();
                nav.setDisabled(!displayTab);
                if (!displayTab) continue;
                resultList.add(nav);
                continue;
            }
            resultList.add(nav);
        }
        HeaderNavigation[] result = new HeaderNavigation[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    public List<ExtraButton> getExtraActionsButtons() {
        this.extraButtons.clear();
        String externalImageURL = "kra.externalizable.images.url";
        ConfigurationService configurationService = KRADServiceLocator.getKualiConfigurationService();
        String sendNotificationImage = configurationService.getPropertyValueAsString(externalImageURL) + "buttonsmall_send_notification.gif";
        this.addExtraButton("methodToCall.sendNotification", sendNotificationImage, "Send Notification");
        return this.extraButtons;
    }

    public Long getPlaceHolderAwardId() {
        return this.placeHolderAwardId;
    }

    public void setPlaceHolderAwardId(Long placeHolderAwardId) {
        this.placeHolderAwardId = placeHolderAwardId;
    }

    public boolean isDocOpenedFromAwardSearch() {
        return this.docOpenedFromAwardSearch;
    }

    public void setDocOpenedFromAwardSearch(boolean docOpenedFromAwardSearch) {
        this.docOpenedFromAwardSearch = docOpenedFromAwardSearch;
    }

    public BudgetLimitSummaryHelper getBudgetLimitSummary() {
        return this.budgetLimitSummary;
    }

    public void setBudgetLimitSummary(BudgetLimitSummaryHelper budgetLimitSummary) {
        this.budgetLimitSummary = budgetLimitSummary;
    }

    public AwardBudgetLimitsBean getAwardBudgetLimitsBean() {
        return this.awardBudgetLimitsBean;
    }

    public void setAwardBudgetLimitsBean(AwardBudgetLimitsBean awardBudgetLimitsBean) {
        this.awardBudgetLimitsBean = awardBudgetLimitsBean;
    }

    public void setAwardHierarchyUIService(AwardHierarchyUIService awardHierarchyUIService) {
        this.awardHierarchyUIService = awardHierarchyUIService;
    }

    public List<ReportTracking> getReportTrackingsToDelete() {
        return this.reportTrackingsToDelete;
    }

    public void setReportTrackingsToDelete(List<ReportTracking> reportTrackingsToDelete) {
        this.reportTrackingsToDelete = reportTrackingsToDelete;
    }

    public boolean getDisplayAwardPaymentScheduleActiveLinkFields() {
        if (displayAwardPaymentScheduleActiveLinkFields == null) {
            String parmVal = this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", PAYMENT_SCHEDULE_ACTIVE_LINKS_PARAMETER);
            displayAwardPaymentScheduleActiveLinkFields = StringUtils.equalsIgnoreCase((String)"Y", (String)parmVal);
        }
        return displayAwardPaymentScheduleActiveLinkFields;
    }

    public void setReportTrackingService(ReportTrackingService reportTrackingService) {
        this.reportTrackingService = reportTrackingService;
    }

    public List<ReportTrackingBean> getReportTrackingBeans() {
        return this.reportTrackingBeans;
    }

    public void setReportTrackingBeans(List<ReportTrackingBean> reportTrackingBeans) {
        this.reportTrackingBeans = reportTrackingBeans;
    }

    public String determineRootAwardNumber(AwardForm awardForm) {
        String prevRootAwardNumber = this.getPrevRootAwardNumber();
        return prevRootAwardNumber != null ? prevRootAwardNumber : this.getAwardDocument().getAward().getAwardNumber();
    }

    public String determineParentAwardNumber(AwardForm awardForm) {
        String prevAwardNumber = this.getPrevAwardNumber();
        return prevAwardNumber != null ? prevAwardNumber : "000000-00000";
    }

    public List<Award> getAwardsForHistoryDisplay() {
        Award award;
        ArrayList<Award> results = new ArrayList<Award>();
        List<Award> rawList = this.getAwardDocument().getAward().getAwardVersions();
        for (int i = 0; i < rawList.size() && (award = rawList.get(i)).getSequenceNumber().compareTo(this.getAwardDocument().getAward().getSequenceNumber()) <= 0; ++i) {
            results.add(0, award);
        }
        return results;
    }
}

