/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.krms.service.KcKrmsFactBuilderService;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.framework.support.krms.RulesEngineExecutor;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.krms.api.engine.Engine;
import org.kuali.rice.krms.api.engine.EngineResults;
import org.kuali.rice.krms.api.engine.Facts;
import org.kuali.rice.krms.api.engine.SelectionCriteria;
import org.w3c.dom.Document;

public class AwardRulesEngineExecutorImpl
implements RulesEngineExecutor {
    public EngineResults execute(RouteContext routeContext, Engine engine) {
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        contextQualifiers.put("namespaceCode", "KC-AWARD");
        contextQualifiers.put("name", "KC Award Context");
        String docContent = routeContext.getDocument().getDocContent();
        String unitNumber = this.getElementValue(docContent, "//leadUnit/unitNumber");
        SelectionCriteria selectionCriteria = SelectionCriteria.createCriteria(null, contextQualifiers, Collections.singletonMap("Unit Number", unitNumber));
        KcKrmsFactBuilderService fbService = (KcKrmsFactBuilderService)KraServiceLocator.getService("awardFactBuilderService");
        Facts.Builder factsBuilder = Facts.Builder.create();
        fbService.addFacts(factsBuilder, docContent);
        EngineResults results = engine.execute(selectionCriteria, factsBuilder.build(), null);
        return results;
    }

    private String getElementValue(String docContent, String xpathExpression) {
        try {
            Document document = XmlHelper.trimXml((InputStream)new ByteArrayInputStream(docContent.getBytes()));
            XPath xpath = XPathHelper.newXPath();
            String value = (String)xpath.evaluate(xpathExpression, document, XPathConstants.STRING);
            return value;
        }
        catch (Exception e) {
            throw new RiceRuntimeException();
        }
    }
}

