/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.AwardSponsorTerm;
import org.kuali.kra.bo.SponsorTermType;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.keyvalues.PersistableBusinessObjectValuesFinder;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class AwardTermsAuditRule
implements DocumentAuditRule {
    private static final int FIVE = 5;
    private static final int ZERO = 0;
    private static final String TERMS_AUDIT_ERRORS = "termsAuditErrors";
    private static final String DESCRIPTION = "description";
    private static final String SPONSOR_TERM_TYPE_CODE = "sponsorTermTypeCode";
    private static final String DOT = ".";
    private List<AuditError> auditErrors;
    private List<KeyValue> sponsorTermTypes;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        AwardDocument awardDocument = (AwardDocument)document;
        this.auditErrors = new ArrayList<AuditError>();
        this.setSponsorTermTypes();
        List<AwardSponsorTerm> awardSponsorTerms = awardDocument.getAward().getAwardSponsorTerms();
        for (KeyValue sponsorTermType : this.sponsorTermTypes) {
            boolean sponsorTermTypeExists = this.isSponsorTermTypeInAwardSponsorTerms(sponsorTermType.getKey().toString(), awardSponsorTerms);
            if (sponsorTermTypeExists) continue;
            valid &= false;
            this.addErrorToAuditErrors(sponsorTermType.getValue());
        }
        this.reportAndCreateAuditCluster();
        return valid;
    }

    protected void setSponsorTermTypes() {
        if (this.sponsorTermTypes == null) {
            this.sponsorTermTypes = (ArrayList)this.getSponsorTermTypesFromDatabase();
        }
    }

    protected void setSponsorTermTypes(List<KeyValue> sponsorTermTypes) {
        this.sponsorTermTypes = sponsorTermTypes;
    }

    protected boolean isSponsorTermTypeInAwardSponsorTerms(String key, List<AwardSponsorTerm> awardSponsorTerms) {
        boolean valid = false;
        for (AwardSponsorTerm awardSponsorTerm : awardSponsorTerms) {
            if (!awardSponsorTerm.getSponsorTermTypeCode().equals(key)) continue;
            valid = true;
            break;
        }
        return valid;
    }

    protected void addErrorToAuditErrors(String description) {
        String[] params = new String[5];
        params[0] = description;
        StringBuilder sb = new StringBuilder();
        sb.append("paymentReportsAndTerms");
        sb.append(DOT);
        sb.append("Terms");
        this.auditErrors.add(new AuditError("document.termsAuditRules", "error.empty.terms", sb.toString(), params));
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put(TERMS_AUDIT_ERRORS, new AuditCluster("Terms", this.auditErrors, "Validation Errors"));
        }
    }

    protected List<KeyValue> getSponsorTermTypesFromDatabase() {
        PersistableBusinessObjectValuesFinder persistableBusinessObjectValuesFinder = new PersistableBusinessObjectValuesFinder();
        persistableBusinessObjectValuesFinder.setBusinessObjectClass(SponsorTermType.class);
        persistableBusinessObjectValuesFinder.setKeyAttributeName(SPONSOR_TERM_TYPE_CODE);
        persistableBusinessObjectValuesFinder.setLabelAttributeName(DESCRIPTION);
        return persistableBusinessObjectValuesFinder.getKeyValues();
    }
}

