/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.awardhierarchy.MissingHierarchyException;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.util.MessageList;
import org.kuali.rice.krad.util.ErrorMessage;

public class AwardHierarchyBean
implements Serializable {
    private static final Log LOG = LogFactory.getLog(AwardHierarchyBean.class);
    private AwardForm awardForm;
    private transient AwardHierarchyService awardHierarchyService;
    private Map<String, AwardHierarchy> rootNodes;
    private AwardHierarchy rootNode;
    private Map<String, AwardHierarchy> hierarchy;
    private List<String> hierarchyOrder;
    private List<String> allAwardNumbers;
    private List<String> finalAwardNumbers;
    private static final String ERROR_AWARD_HIERARCHY_NOTSAVED = "error.award.hierarchy.notsaved";

    public AwardHierarchyBean(AwardForm awardForm) {
        this.awardForm = awardForm;
        this.init();
    }

    AwardHierarchyBean(AwardForm awardForm, AwardHierarchyService awardHierarchyService) {
        this.awardForm = awardForm;
        this.awardHierarchyService = awardHierarchyService;
        this.init();
    }

    public AwardHierarchy copyAwardAndDescendantsAsChildOfAnotherAward(String sourceAwardNumber, String targetParentAwardNumber) {
        return this.getRootNode().findNodeInHierarchy(targetParentAwardNumber) != null ? this.copyAwardAndDescendantsAsChildOfAnAwardInCurrentHierarchy(sourceAwardNumber, targetParentAwardNumber) : this.copyAwardAndDescendantsAsChildOfAnAwardInAnotherHierarchy(sourceAwardNumber, targetParentAwardNumber);
    }

    public AwardHierarchy copyAwardAndDescendantsAsChildOfAnAwardInCurrentHierarchy(String sourceAwardNumber, String targetParentAwardNumber) {
        AwardHierarchy sourceNode = this.getRootNode().findNodeInHierarchy(sourceAwardNumber);
        AwardHierarchy targetParentNode = this.getRootNode().findNodeInHierarchy(targetParentAwardNumber);
        AwardHierarchy newNode = this.getAwardHierarchyService().copyAwardAndDescendantsAsChildOfAnAwardInCurrentHierarchy(sourceNode, targetParentNode);
        return newNode;
    }

    public AwardHierarchy copyAwardAndDescendantsAsChildOfAnAwardInAnotherHierarchy(String sourceAwardNumber, String targetParentAwardNumber) {
        AwardHierarchy sourceNode = this.getRootNode().findNodeInHierarchy(sourceAwardNumber);
        AwardHierarchy foreignRoot = this.getAwardHierarchyService().loadFullHierarchyFromAnyNode(targetParentAwardNumber);
        AwardHierarchy targetParentNode = foreignRoot.findNodeInHierarchy(targetParentAwardNumber);
        AwardHierarchy newBranchNode = this.getAwardHierarchyService().copyAwardAndDescendantsAsChildOfAnAwardInAnotherHierarchy(sourceNode, targetParentNode);
        this.rootNodes.put(foreignRoot.getAwardNumber(), foreignRoot);
        this.saveHierarchyChanges();
        return newBranchNode;
    }

    public AwardHierarchy copyAwardAsChildOfAnotherAward(String sourceAwardNumber, String targetParentAwardNumber) {
        return this.getRootNode().findNodeInHierarchy(targetParentAwardNumber) != null ? this.copyAwardAsChildOfAnAwardInCurrentHierarchy(sourceAwardNumber, targetParentAwardNumber) : this.copyAwardAsChildOfAnAwardInAnotherHierarchy(sourceAwardNumber, targetParentAwardNumber);
    }

    public AwardHierarchy copyAwardAsChildOfAnAwardInCurrentHierarchy(String sourceAwardNumber, String targetParentAwardNumber) {
        AwardHierarchy sourceNode = this.getRootNode().findNodeInHierarchy(sourceAwardNumber);
        AwardHierarchy targetParentNode = sourceNode.findNodeInHierarchy(targetParentAwardNumber);
        return this.getAwardHierarchyService().copyAwardAsChildOfAnAwardInCurrentHierarchy(sourceNode, targetParentNode);
    }

    public AwardHierarchy copyAwardAsChildOfAnAwardInAnotherHierarchy(String sourceAwardNumber, String targetParentAwardNumber) {
        AwardHierarchy sourceNode = this.getRootNode().findNodeInHierarchy(sourceAwardNumber);
        AwardHierarchy foreignRoot = this.getAwardHierarchyService().loadFullHierarchyFromAnyNode(targetParentAwardNumber);
        AwardHierarchy targetParentNode = foreignRoot.findNodeInHierarchy(targetParentAwardNumber);
        AwardHierarchy newNode = this.getAwardHierarchyService().copyAwardAsChildOfAnAwardInAnotherHierarchy(sourceNode, targetParentNode);
        this.rootNodes.put(foreignRoot.getAwardNumber(), foreignRoot);
        this.saveHierarchyChanges();
        return newNode;
    }

    public AwardHierarchy copyAwardAndAllDescendantsAsNewHierarchy(String awardNumber) {
        AwardHierarchy newRoot = this.getAwardHierarchyService().copyAwardAndAllDescendantsAsNewHierarchy(this.getRootNode().findNodeInHierarchy(awardNumber));
        this.rootNodes.put(newRoot.getAwardNumber(), newRoot);
        return newRoot;
    }

    public AwardHierarchy copyAwardAsNewHierarchy(String awardNumber) {
        AwardHierarchy newRoot = this.getAwardHierarchyService().copyAwardAsNewHierarchy(this.getRootNode().findNodeInHierarchy(awardNumber));
        this.rootNodes.put(newRoot.getAwardNumber(), newRoot);
        return newRoot;
    }

    public AwardHierarchy createNewChildAward(String awardNumber) {
        AwardHierarchy targetNode = this.getRootNode().findNodeInHierarchy(awardNumber);
        return this.getAwardHierarchyService().createNewChildAward(targetNode);
    }

    public AwardHierarchy createNewChildAwardBasedOnAnotherAwardInHierarchy(String nodeToCopyFromAwardNumber, String targetParentNodeAwardNumber) {
        AwardHierarchy nodeToCopyFrom = null;
        AwardHierarchy foreignRoot = this.getAwardHierarchyService().loadFullHierarchyFromAnyNode(nodeToCopyFromAwardNumber);
        if (foreignRoot != null) {
            nodeToCopyFrom = foreignRoot.findNodeInHierarchy(nodeToCopyFromAwardNumber);
        }
        if (nodeToCopyFrom == null) {
            throw new MissingHierarchyException(nodeToCopyFromAwardNumber);
        }
        AwardHierarchy targetParentNode = this.getRootNode().findNodeInHierarchy(targetParentNodeAwardNumber);
        if (targetParentNode == null) {
            throw new MissingHierarchyException(targetParentNodeAwardNumber);
        }
        return this.getAwardHierarchyService().createNewAwardBasedOnAnotherAwardInHierarchy(nodeToCopyFrom, targetParentNode);
    }

    public AwardHierarchy createNewAwardBasedOnParent(String awardNumber) {
        AwardHierarchy targetNode = this.getRootNode().findNodeInHierarchy(awardNumber);
        AwardHierarchy newNode = this.getAwardHierarchyService().createNewAwardBasedOnParent(targetNode);
        return newNode;
    }

    public Map<String, AwardHierarchy> getCurrentAwardHierarchy() {
        if (this.hierarchy == null) {
            this.loadHierarchy(this.getAwardForm().getAwardDocument().getAward().getAwardNumber());
        }
        return this.hierarchy;
    }

    public List<String> getCurrentHierarchyOrder() {
        return this.hierarchyOrder;
    }

    public Map<String, AwardHierarchy> getAwardHierarchy(AwardHierarchy rootNode, List<String> order) {
        return this.getAwardHierarchyService().getAwardHierarchy(rootNode, order);
    }

    public Map<String, AwardHierarchy> getAwardHierarchy(String awardNumber, List<String> order) {
        return this.getAwardHierarchyService().getAwardHierarchy(awardNumber, order);
    }

    public void createDefaultAwardHierarchy() {
        String awardNumber = this.awardForm.getAwardDocument().getAward().getAwardNumber();
        AwardHierarchy newNode = new AwardHierarchy();
        newNode.setAwardNumber(awardNumber);
        newNode.setParentAwardNumber(this.getAwardForm().determineParentAwardNumber(this.awardForm));
        newNode.setRootAwardNumber(this.getAwardForm().determineRootAwardNumber(this.awardForm));
        newNode.setOriginatingAwardNumber(awardNumber);
        newNode.setAward(this.awardForm.getAwardDocument().getAward());
        if (newNode.isRootNode()) {
            this.rootNode = newNode;
            this.rootNodes.put(awardNumber, newNode);
            this.hierarchy = new HashMap<String, AwardHierarchy>();
            this.hierarchy.put(awardNumber, newNode);
        }
    }

    public AwardHierarchy getCurrentAwardHierarchyNode() {
        return this.getRootNode().findNodeInHierarchy(this.getAward().getAwardNumber());
    }

    public AwardHierarchy getCurrentRootNode() {
        return this.rootNode;
    }

    public boolean saveHierarchyChanges() {
        boolean result;
        MessageList messageList = new MessageList();
        MessageList originalMessageList = KNSGlobalVariables.getMessageList();
        if (originalMessageList != null) {
            messageList.addAll((Collection)originalMessageList);
        }
        try {
            this.getAwardHierarchyService().persistAwardHierarchies(this.rootNodes.values());
            this.refreshCurrentHierarchy();
            LOG.info((Object)"Hierarchy changes saved");
            result = true;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            messageList.add((Object)new ErrorMessage(ERROR_AWARD_HIERARCHY_NOTSAVED, new String[]{e.getMessage()}));
            result = false;
        }
        KNSGlobalVariables.setMessageList((MessageList)messageList);
        return result;
    }

    public Integer getMaxAwardNumber() {
        String nextAwardNumber = this.getRootNode().generateNextAwardNumberInSequence();
        String[] parts = nextAwardNumber.split("-");
        return Integer.valueOf(parts[1]);
    }

    public AwardHierarchy getRootNode() {
        String currentAwardNumber = this.getAward().getAwardNumber();
        AwardHierarchy thisRootNode = this.findRootNodeForCurrentAward(currentAwardNumber);
        if (thisRootNode == null) {
            thisRootNode = this.loadRootNodeForAwardNumber(currentAwardNumber);
        }
        return thisRootNode;
    }

    public void refreshCurrentHierarchy() {
        this.rootNodes.clear();
        this.loadHierarchy(this.getAward().getAwardNumber());
    }

    protected void loadHierarchy(String awardNumber) {
        this.hierarchyOrder = new ArrayList<String>();
        this.hierarchy = this.getAwardHierarchyService().getAwardHierarchy(awardNumber, this.hierarchyOrder);
        if (!this.hierarchyOrder.isEmpty()) {
            this.rootNode = this.hierarchy.get(this.hierarchyOrder.get(0));
            this.rootNodes.put(this.rootNode.getAwardNumber(), this.rootNode);
        }
        this.allAwardNumbers = this.hierarchyOrder;
        this.finalAwardNumbers = this.hierarchyOrder;
    }

    public void recordTargetNodeState(AwardHierarchy targetNode) {
        this.awardForm.setPrevAwardNumber(targetNode.getAwardNumber());
        this.awardForm.setPrevRootAwardNumber(targetNode.getRootAwardNumber());
    }

    void init() {
        this.rootNodes = new TreeMap<String, AwardHierarchy>();
        this.awardHierarchyService = this.getAwardHierarchyService();
        String awardNumber = this.getAward().getAwardNumber();
        if ("000000-00000".equals(awardNumber)) {
            awardNumber = this.awardForm.getPrevRootAwardNumber();
        }
        if (awardNumber != null) {
            this.loadHierarchy(awardNumber);
        }
    }

    Award getAward() {
        return this.awardForm.getAwardDocument().getAward();
    }

    AwardHierarchyService getAwardHierarchyService() {
        if (this.awardHierarchyService == null) {
            this.awardHierarchyService = KraServiceLocator.getService(AwardHierarchyService.class);
        }
        return this.awardHierarchyService;
    }

    AwardForm getAwardForm() {
        return this.awardForm;
    }

    void setAwardForm(AwardForm awardForm) {
        this.awardForm = awardForm;
    }

    private AwardHierarchy findNodeInAnyHierarchy(String awardNumber) {
        String rootNodeAwardNumber;
        AwardHierarchy rootNode;
        AwardHierarchy foundNode = null;
        Iterator<String> i$ = this.rootNodes.keySet().iterator();
        while (i$.hasNext() && (foundNode = (rootNode = this.rootNodes.get(rootNodeAwardNumber = i$.next())).findNodeInHierarchy(awardNumber)) == null) {
        }
        if (foundNode == null) {
            foundNode = this.loadRootNodeForAwardNumber(awardNumber);
        }
        return foundNode;
    }

    private AwardHierarchy findRootNodeForCurrentAward(String currentAwardNumber) {
        AwardHierarchy thisRootNode = null;
        for (AwardHierarchy rootNode : this.rootNodes.values()) {
            if (rootNode.findNodeInHierarchy(currentAwardNumber) == null) continue;
            thisRootNode = rootNode;
            break;
        }
        return thisRootNode;
    }

    private AwardHierarchy loadRootNodeForAwardNumber(String currentAwardNumber) {
        AwardHierarchy thisRootNode = this.getAwardHierarchyService().loadFullHierarchyFromAnyNode(currentAwardNumber);
        if (thisRootNode != null) {
            this.rootNodes.put(thisRootNode.getAwardNumber(), thisRootNode);
        } else {
            thisRootNode = AwardHierarchy.createRootNode(currentAwardNumber);
        }
        return thisRootNode;
    }

    public List<String> getAllAwardNumbers() {
        return this.allAwardNumbers;
    }

    public void setAllAwardNumbers(List<String> allAwardNumbers) {
        this.allAwardNumbers = allAwardNumbers;
    }

    public List<String> getFinalAwardNumbers() {
        return this.finalAwardNumbers;
    }

    public void setFinalAwardNumbers(List<String> finalAwardNumbers) {
        this.finalAwardNumbers = finalAwardNumbers;
    }

    public Map<String, AwardHierarchy> getRootNodes() {
        return this.rootNodes;
    }

    public void setRootNodes(Map<String, AwardHierarchy> rootNodes) {
        this.rootNodes = rootNodes;
    }
}

