/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync.helpers;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncException;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncXmlExport;
import org.kuali.kra.award.awardhierarchy.sync.helpers.AwardSyncHelperBase;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipient;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class AwardSyncReportRecipientHelper
extends AwardSyncHelperBase {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void applySyncChange(Award award, AwardSyncChange change) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, InstantiationException, AwardSyncException {
        List<AwardReportTerm> reports = award.getAwardReportTermItems();
        AwardReportTerm report = (AwardReportTerm)this.getAwardSyncUtilityService().findMatchingBo(reports, change.getXmlExport().getKeys());
        if (StringUtils.equals((String)change.getSyncType(), (String)AwardSyncType.ADD_SYNC.getSyncValue())) {
            if (report == null) throw new AwardSyncException("Not applicable", true);
            this.setValuesOnSyncable((PersistableBusinessObject)report, change.getXmlExport().getValues(), change);
            return;
        } else {
            if (report == null) throw new AwardSyncException("Not applicable", true);
            Object o = change.getXmlExport().getValues().get("awardReportTermRecipients");
            if (o instanceof List) {
                List recipientChanges = (List)o;
                for (AwardSyncXmlExport recipientChange : recipientChanges) {
                    AwardReportTermRecipient recipient = (AwardReportTermRecipient)this.getAwardSyncUtilityService().findMatchingBo(report.getAwardReportTermRecipients(), recipientChange.getKeys());
                    if (recipient == null) continue;
                    report.getAwardReportTermRecipients().remove(recipient);
                }
                return;
            } else {
                if (!(o instanceof AwardSyncXmlExport)) throw new AwardSyncException("Unrecognized data", false);
                AwardSyncXmlExport recipientChange = (AwardSyncXmlExport)o;
                AwardReportTermRecipient recipient = (AwardReportTermRecipient)this.getAwardSyncUtilityService().findMatchingBo(report.getAwardReportTermRecipients(), recipientChange.getKeys());
                if (recipient == null) return;
                report.getAwardReportTermRecipients().remove(recipient);
            }
        }
    }

    @Override
    protected String getObjectDesc(PersistableBusinessObject syncableObject, String attrName) {
        return "Recipient";
    }

    @Override
    protected String getDataDesc(PersistableBusinessObject syncableObject, String attrName) {
        AwardReportTermRecipient recipient = (AwardReportTermRecipient)syncableObject;
        String retval = "";
        if (recipient.getContactType() != null) {
            retval = retval + recipient.getContactType().getDescription();
        }
        retval = retval + " : ";
        retval = recipient.getRolodex().getFullName() != null ? retval + recipient.getRolodex().getFullName() : retval + recipient.getRolodex().getOrganization();
        return retval;
    }
}

