/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync.helpers;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncException;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncXmlExport;
import org.kuali.kra.award.awardhierarchy.sync.helpers.AwardSyncHelperBase;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class AwardSyncUnitHelper
extends AwardSyncHelperBase {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void applySyncChange(Award award, AwardSyncChange change) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, InstantiationException, AwardSyncException {
        List<AwardPerson> awardPersons = award.getProjectPersons();
        AwardSyncXmlExport unitExport = (AwardSyncXmlExport)change.getXmlExport().getValues().get("units");
        AwardPerson person = (AwardPerson)this.getAwardSyncUtilityService().findMatchingBo(awardPersons, change.getXmlExport().getKeys());
        if (StringUtils.equals((String)change.getSyncType(), (String)AwardSyncType.ADD_SYNC.getSyncValue())) {
            if (person == null) throw new AwardSyncException("Not applicable", true);
            this.checkAndFixLeadUnit(person, unitExport);
            this.setValuesOnSyncable((PersistableBusinessObject)person, change.getXmlExport().getValues(), change);
            this.fixLeadUnit(award, person);
            return;
        } else {
            if (person == null) throw new AwardSyncException("Not applicable", true);
            AwardPersonUnit unit = (AwardPersonUnit)this.getAwardSyncUtilityService().findMatchingBo(person.getUnits(), unitExport.getKeys());
            if (unit == null) return;
            person.getUnits().remove(unit);
        }
    }

    protected void checkAndFixLeadUnit(AwardPerson person, AwardSyncXmlExport export) {
        if (((Boolean)export.getValues().get("leadUnit")).booleanValue()) {
            for (AwardPersonUnit unit : person.getUnits()) {
                unit.setLeadUnit(false);
            }
        }
    }

    protected void fixLeadUnit(Award award, AwardPerson person) {
        if (person.isPrincipalInvestigator()) {
            for (AwardPersonUnit unit : person.getUnits()) {
                if (!unit.isLeadUnit() || StringUtils.equals((String)award.getLeadUnit().getUnitNumber(), (String)unit.getUnitNumber())) continue;
                award.setLeadUnit(unit.getUnit());
            }
        }
    }

    @Override
    protected String getObjectDesc(PersistableBusinessObject syncableObject, String attrName) {
        AwardPersonUnit unit = (AwardPersonUnit)syncableObject;
        if (unit.isLeadUnit()) {
            return "Lead Unit";
        }
        return "Unit";
    }

    @Override
    protected String getDataDesc(PersistableBusinessObject syncableObject, String attrName) {
        AwardPersonUnit unit = (AwardPersonUnit)syncableObject;
        return unit.getAwardPerson().getFullName() + " - " + unit.getUnitNumber() + " : " + unit.getUnitName();
    }
}

