/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetLimit;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.budget.calculator.AwardBudgetCalculationService;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardBudgetCostLimitAuditRule
implements DocumentAuditRule {
    public static final String AWARD_BUDGET_COST_LIMIT_ERROR_KEY = "awardBudgetCostLimitAuditErrors";
    public static final String AWARD_BUDGET_COST_LIMIT_WARNING_KEY = "awardBudgetCostLimitAuditWarnings";
    private BusinessObjectService businessObjectService;
    private AwardBudgetCalculationService awardBudgetCalculationService;
    private AwardBudgetService awardBudgetService;

    public boolean processRunAuditBusinessRules(Document document) {
        AwardBudgetDocument awardBudgetDocument = (AwardBudgetDocument)document;
        AwardBudgetExt budget = (AwardBudgetExt)((BudgetDocument)document).getBudget();
        Award currentAward = this.getAwardBudgetService().getActiveOrNewestAward(((AwardDocument)awardBudgetDocument.getParentDocument()).getAward().getAwardNumber());
        boolean valid = true;
        valid &= this.limitsMatch(currentAward.getAwardBudgetLimits(), budget.getAwardBudgetLimits());
        AwardBudgetExt prevBudget = this.loadBudget(budget.getPrevBudget());
        if (prevBudget != null) {
            this.getAwardBudgetCalculationService().calculateBudgetSummaryTotals(prevBudget, true);
        }
        for (AwardBudgetLimit budgetLimit : budget.getAwardBudgetLimits()) {
            if (budgetLimit.getLimitType() == AwardBudgetLimit.LIMIT_TYPE.TOTAL_COST || budgetLimit.getLimit() == null) continue;
            BudgetDecimal total = (BudgetDecimal)((Object)org.kuali.rice.krad.util.ObjectUtils.getPropertyValue((Object)budget, (String)budgetLimit.getLimitType().getBudgetProperty()));
            if (prevBudget != null) {
                total = (BudgetDecimal)total.add((BudgetDecimal)((Object)org.kuali.rice.krad.util.ObjectUtils.getPropertyValue((Object)prevBudget, (String)budgetLimit.getLimitType().getBudgetProperty())));
            }
            if (!total.isGreaterThan((AbstractKualiDecimal)budgetLimit.getLimit())) continue;
            this.getAuditErrors().add(new AuditError("document.budget." + budgetLimit.getLimitType().getBudgetProperty(), "error.budget.cost.limit", "parameters.BudgetPeriodsTotals", new String[]{budgetLimit.getLimitType().getDesc(), budgetLimit.getLimit().toString()}));
            valid = false;
        }
        return valid;
    }

    private AwardBudgetExt loadBudget(BudgetVersionOverview budgetOverview) {
        AwardBudgetExt retval = null;
        if (budgetOverview != null && budgetOverview.getBudgetId() != null) {
            retval = (AwardBudgetExt)this.getBusinessObjectService().findBySinglePrimaryKey(AwardBudgetExt.class, (Object)budgetOverview.getBudgetId());
        }
        return retval;
    }

    private List<AuditError> getAuditErrors() {
        return this.getAuditProblems(AWARD_BUDGET_COST_LIMIT_ERROR_KEY, "Validation Errors");
    }

    private List<AuditError> getAuditWarnings() {
        return this.getAuditProblems(AWARD_BUDGET_COST_LIMIT_WARNING_KEY, "Warnings");
    }

    protected AwardBudgetLimit getBudgetLimit(AwardBudgetLimit.LIMIT_TYPE type, List<AwardBudgetLimit> budgetLimits) {
        for (AwardBudgetLimit limit : budgetLimits) {
            if (limit.getLimitType() != type) continue;
            return limit;
        }
        return new AwardBudgetLimit(type);
    }

    protected boolean limitsMatch(List<AwardBudgetLimit> awardLimits, List<AwardBudgetLimit> budgetLimits) {
        if (awardLimits.size() < budgetLimits.size()) {
            this.getAuditWarnings().add(new AuditError("document.budget.awardBudgetLimits", "error.budget.cost.limits.changed", "parameters.BudgetPeriodsTotals"));
            return true;
        }
        for (AwardBudgetLimit limit : awardLimits) {
            AwardBudgetLimit budgetLimit = this.getBudgetLimit(limit.getLimitType(), budgetLimits);
            if (budgetLimit != null && ObjectUtils.equals((Object)limit.getLimit(), (Object)budgetLimit.getLimit())) continue;
            this.getAuditWarnings().add(new AuditError("document.budget.awardBudgetLimits", "error.budget.specific.cost.limit.changed", "parameters.BudgetPeriodsTotals", new String[]{budgetLimit.getLimitType().getDesc(), budgetLimit == null || budgetLimit.getLimit() == null ? "N/A" : budgetLimit.getLimit().toString(), limit == null || limit.getLimit() == null ? "N/A" : limit.getLimit().toString()}));
        }
        return true;
    }

    private List<AuditError> getAuditProblems(String auditKey, String problemType) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!KNSGlobalVariables.getAuditErrorMap().containsKey(auditKey)) {
            KNSGlobalVariables.getAuditErrorMap().put(auditKey, new AuditCluster("Award Budget Limits", auditErrors, problemType));
        } else {
            auditErrors = ((AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(auditKey)).getAuditErrorList();
        }
        return auditErrors;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected AwardBudgetCalculationService getAwardBudgetCalculationService() {
        if (this.awardBudgetCalculationService == null) {
            this.awardBudgetCalculationService = KraServiceLocator.getService(AwardBudgetCalculationService.class);
        }
        return this.awardBudgetCalculationService;
    }

    public void setAwardBudgetCalculationService(AwardBudgetCalculationService awardBudgetCalculationService) {
        this.awardBudgetCalculationService = awardBudgetCalculationService;
    }

    protected AwardBudgetService getAwardBudgetService() {
        if (this.awardBudgetService == null) {
            this.awardBudgetService = KraServiceLocator.getService(AwardBudgetService.class);
        }
        return this.awardBudgetService;
    }

    public void setAwardBudgetService(AwardBudgetService awardBudgetService) {
        this.awardBudgetService = awardBudgetService;
    }
}

