/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.AwardAssociate;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AwardBudgetLimit
extends AwardAssociate {
    private static final long serialVersionUID = 1215583539908050082L;
    private Long budgetLimitId;
    private Long awardId;
    private Long budgetId;
    private String limitTypeCode;
    private KualiDecimal limit;

    public AwardBudgetLimit() {
    }

    public AwardBudgetLimit(LIMIT_TYPE type) {
        this.setLimitType(type);
    }

    public AwardBudgetLimit(AwardBudgetLimit budgetLimit) {
        this.limitTypeCode = budgetLimit.getLimitTypeCode();
        this.limit = budgetLimit.getLimit();
    }

    public Long getBudgetLimitId() {
        return this.budgetLimitId;
    }

    public void setBudgetLimitId(Long budgetLimitId) {
        this.budgetLimitId = budgetLimitId;
    }

    public Long getAwardId() {
        return this.awardId;
    }

    public void setAwardId(Long awardId) {
        this.awardId = awardId;
    }

    public Long getBudgetId() {
        return this.budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public String getLimitTypeCode() {
        return this.limitTypeCode;
    }

    public void setLimitTypeCode(String limitTypeCode) {
        this.limitTypeCode = limitTypeCode;
    }

    public LIMIT_TYPE getLimitType() {
        if (this.limitTypeCode == null) {
            return null;
        }
        for (LIMIT_TYPE type : LIMIT_TYPE.values()) {
            if (!StringUtils.equals((String)this.limitTypeCode, (String)type.getType())) continue;
            return type;
        }
        return null;
    }

    public void setLimitType(LIMIT_TYPE type) {
        this.limitTypeCode = type.getType();
    }

    public KualiDecimal getLimit() {
        return this.limit;
    }

    public void setLimit(KualiDecimal limit) {
        this.limit = limit;
    }

    @Override
    public void resetPersistenceState() {
        this.setBudgetLimitId(null);
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.budgetLimitId == null ? 0 : this.budgetLimitId.hashCode());
        result = 31 * result + (this.awardId == null ? 0 : this.awardId.hashCode());
        result = 31 * result + (this.budgetId == null ? 0 : this.budgetId.hashCode());
        result = 31 * result + (this.limitTypeCode == null ? 0 : this.limitTypeCode.hashCode());
        result = 31 * result + (this.limit == null ? 0 : this.limit.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AwardBudgetLimit)) {
            return false;
        }
        AwardBudgetLimit l = (AwardBudgetLimit)o;
        return ObjectUtils.equals((Object)this.getBudgetLimitId(), (Object)l.getBudgetLimitId());
    }

    public static enum LIMIT_TYPE {
        TOTAL_COST("totalCost", "Total", "totalCost"),
        DIRECT_COST("directCost", "Total Direct", "totalDirectCost"),
        INDIRECT_COST("indirectCost", "Total F&A", "totalIndirectCost");

        private String type;
        private String desc;
        private String budgetProperty;

        private LIMIT_TYPE(String type, String desc, String budgetProperty) {
            this.type = type;
            this.desc = desc;
            this.budgetProperty = budgetProperty;
        }

        public String getType() {
            return this.type;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getBudgetProperty() {
            return this.budgetProperty;
        }
    }
}

