/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.budget.AwardBudgetLineItemExt;
import org.kuali.kra.award.budget.AwardBudgetPeriodSummaryCalculatedAmount;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.calculator.query.Equals;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;

public class AwardBudgetPeriodExt
extends BudgetPeriod {
    private static final long serialVersionUID = -4306012301567173292L;
    private BudgetDecimal obligatedAmount;
    private BudgetDecimal totalFringeAmount;
    private List<AwardBudgetPeriodSummaryCalculatedAmount> awardBudgetPeriodFringeAmounts = new ArrayList<AwardBudgetPeriodSummaryCalculatedAmount>();
    private List<AwardBudgetPeriodSummaryCalculatedAmount> awardBudgetPeriodFnAAmounts = new ArrayList<AwardBudgetPeriodSummaryCalculatedAmount>();
    private Map<String, BudgetDecimal> fringeForCostElements = new HashMap<String, BudgetDecimal>();
    private boolean rateOverrideFlag;

    public BudgetDecimal getObligatedAmount() {
        return this.obligatedAmount == null ? BudgetDecimal.ZERO : this.obligatedAmount;
    }

    public void setObligatedAmount(BudgetDecimal obligatedAmount) {
        this.obligatedAmount = obligatedAmount;
    }

    @Override
    public AwardBudgetLineItemExt getNewBudgetLineItem() {
        return new AwardBudgetLineItemExt();
    }

    private QueryList<AwardBudgetPeriodSummaryCalculatedAmount> filterEBRates() {
        QueryList<AwardBudgetPeriodSummaryCalculatedAmount> qlAwardBudgetPeriodSummaryCalculatedAmounts = new QueryList<AwardBudgetPeriodSummaryCalculatedAmount>(this.awardBudgetPeriodFringeAmounts);
        Equals ebClassType = new Equals("rateClassType", (Comparable)((Object)RateClassType.EMPLOYEE_BENEFITS.getRateClassType()));
        QueryList<AwardBudgetPeriodSummaryCalculatedAmount> ebCalculatedAmounts = qlAwardBudgetPeriodSummaryCalculatedAmounts.filter(ebClassType);
        return ebCalculatedAmounts;
    }

    public Map<String, BudgetDecimal> getFringeForCostElements() {
        QueryList<AwardBudgetPeriodSummaryCalculatedAmount> ebCalculatedAmounts = this.filterEBRates();
        for (AwardBudgetPeriodSummaryCalculatedAmount awardBudgetPeriodSummaryCalculatedAmount : ebCalculatedAmounts) {
            this.fringeForCostElements.put(awardBudgetPeriodSummaryCalculatedAmount.getCostElement(), awardBudgetPeriodSummaryCalculatedAmount.getCalculatedCost());
        }
        return this.fringeForCostElements;
    }

    public BudgetDecimal getTotalFringeAmount() {
        return this.totalFringeAmount == null ? BudgetDecimal.ZERO : this.totalFringeAmount;
    }

    public void setTotalFringeAmount(BudgetDecimal totalFringeAmount) {
        this.totalFringeAmount = totalFringeAmount;
    }

    public List<AwardBudgetPeriodSummaryCalculatedAmount> getAwardBudgetPeriodFringeAmounts() {
        return this.awardBudgetPeriodFringeAmounts;
    }

    public void setAwardBudgetPeriodFringeAmounts(List<AwardBudgetPeriodSummaryCalculatedAmount> awardBudgetPeriodFringeAmounts) {
        this.awardBudgetPeriodFringeAmounts = awardBudgetPeriodFringeAmounts;
    }

    public List<AwardBudgetPeriodSummaryCalculatedAmount> getAwardBudgetPeriodFnAAmounts() {
        return this.awardBudgetPeriodFnAAmounts;
    }

    public void setAwardBudgetPeriodFnAAmounts(List<AwardBudgetPeriodSummaryCalculatedAmount> awardBudgetPeriodFnAAmounts) {
        this.awardBudgetPeriodFnAAmounts = awardBudgetPeriodFnAAmounts;
    }

    public void setRateOverrideFlag(boolean rateOverrideFlag) {
        this.rateOverrideFlag = rateOverrideFlag;
    }

    public boolean getRateOverrideFlag() {
        return this.rateOverrideFlag;
    }

    public boolean isRateOverrideFlag() {
        return this.rateOverrideFlag;
    }

    @Override
    public List<BudgetLineItem> getBudgetLineItems() {
        List<BudgetLineItem> budgetLineItems = super.getBudgetLineItems();
        this.calculateLineItemTotals(budgetLineItems);
        return budgetLineItems;
    }

    protected void calculateLineItemTotals(List<BudgetLineItem> budgetLineItems) {
        BudgetDecimal runningTotal = BudgetDecimal.ZERO;
        int i = 0;
        int budgetLineItemsLength = budgetLineItems.size();
        for (BudgetLineItem item : budgetLineItems) {
            AwardBudgetLineItemExt ext = (AwardBudgetLineItemExt)item;
            runningTotal = (BudgetDecimal)runningTotal.add(ext.getLineItemCost());
            runningTotal = (BudgetDecimal)runningTotal.add(ext.getObligatedAmount());
            ext.setObjectTotal(runningTotal);
            if (i + 1 < budgetLineItems.size()) {
                AwardBudgetLineItemExt nextExt = (AwardBudgetLineItemExt)budgetLineItems.get(i + 1);
                if (!StringUtils.equals((String)ext.getCostElementName(), (String)nextExt.getCostElementName())) {
                    ext.setDisplayTotalDetail(true);
                    runningTotal = BudgetDecimal.ZERO;
                } else {
                    ext.setDisplayTotalDetail(false);
                }
            } else {
                ext.setDisplayTotalDetail(true);
            }
            ++i;
        }
    }
}

