/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetLimit;
import org.kuali.kra.award.budget.AwardBudgetLineItemCalculatedAmountExt;
import org.kuali.kra.award.budget.AwardBudgetLineItemExt;
import org.kuali.kra.award.budget.AwardBudgetPeriodExt;
import org.kuali.kra.award.budget.AwardBudgetPeriodSummaryCalculatedAmount;
import org.kuali.kra.award.budget.AwardBudgetPersonnelCalculatedAmountExt;
import org.kuali.kra.award.budget.AwardBudgetPersonnelDetailsExt;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.budget.AwardBudgetStatus;
import org.kuali.kra.award.budget.AwardBudgetType;
import org.kuali.kra.award.budget.AwardBudgetVersionOverviewExt;
import org.kuali.kra.award.budget.AwardBudgetVersionRule;
import org.kuali.kra.award.budget.BudgetLimitSummaryHelper;
import org.kuali.kra.award.budget.calculator.AwardBudgetCalculationService;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.BudgetCalculationService;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.calculator.query.And;
import org.kuali.kra.budget.calculator.query.Equals;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.rates.BudgetRate;
import org.kuali.kra.budget.rates.RateType;
import org.kuali.kra.budget.summary.BudgetSummaryService;
import org.kuali.kra.budget.versions.AddBudgetVersionEvent;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.budget.bo.ProposalDevelopmentBudgetExt;
import org.kuali.kra.service.DeepCopyPostProcessor;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.beans.BeanUtils;

public class AwardBudgetServiceImpl
implements AwardBudgetService {
    private static final String BUDGET_VERSION_ERROR_PREFIX = "document.parentDocument.budgetDocumentVersion";
    private ParameterService parameterService;
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    private BudgetService<Award> budgetService;
    private BudgetSummaryService budgetSummaryService;
    private BudgetCalculationService budgetCalculationService;
    private AwardBudgetCalculationService awardBudgetCalculationService;
    private VersionHistoryService versionHistoryService;
    private AwardService awardService;

    @Override
    public void post(AwardBudgetDocument awardBudgetDocument) {
        this.processStatusChange(awardBudgetDocument, "awardBudgetStatusPosted");
        this.saveDocument(awardBudgetDocument);
    }

    @Override
    public void toggleStatus(AwardBudgetDocument awardBudgetDocument) {
        String currentStatusCode = awardBudgetDocument.getAwardBudget().getAwardBudgetStatusCode();
        if (currentStatusCode.equals(this.getParameterValue("awardBudgetStatusToBePosted"))) {
            this.processStatusChange(awardBudgetDocument, "awardBudgetStatusDoNotPost");
        } else if (currentStatusCode.equals(this.getParameterValue("awardBudgetStatusDoNotPost"))) {
            this.processStatusChange(awardBudgetDocument, "awardBudgetStatusToBePosted");
        }
        this.saveDocument(awardBudgetDocument);
    }

    protected void saveDocument(AwardBudgetDocument awardBudgetDocument) {
        try {
            this.getDocumentService().saveDocument((Document)awardBudgetDocument);
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processApproval(AwardBudgetDocument awardBudgetDocument) {
        WorkflowDocument workFlowDocument = this.getWorkflowDocument((Document)awardBudgetDocument);
        if (workFlowDocument.isFinal()) {
            this.processStatusChange(awardBudgetDocument, "awardBudgetStatusToBePosted");
        }
        this.saveDocument(awardBudgetDocument);
    }

    @Override
    public void processDisapproval(AwardBudgetDocument awardBudgetDocument) {
        this.processStatusChange(awardBudgetDocument, "awardBudgetStatusRejected");
    }

    @Override
    public void processSubmision(AwardBudgetDocument awardBudgetDocument) {
        this.processStatusChange(awardBudgetDocument, "awardBudgetStatusSubmitted");
    }

    protected void processStatusChange(AwardBudgetDocument awardBudgetDocument, String routingStatus) {
        WorkflowDocument workflowDocument = this.getWorkflowDocument((Document)awardBudgetDocument);
        String submittedStatusCode = this.getParameterValue(routingStatus);
        String submittedStatus = this.findStatusDescription(submittedStatusCode);
        awardBudgetDocument.getAwardBudget().setAwardBudgetStatusCode(submittedStatusCode);
        workflowDocument.setApplicationDocumentStatus(submittedStatus);
    }

    protected String getParameterValue(String awardBudgetParameter) {
        return this.getParameterService().getParameterValueAsString(AwardBudgetDocument.class, awardBudgetParameter);
    }

    protected String findStatusDescription(String statusCode) {
        AwardBudgetStatus budgetStatus = (AwardBudgetStatus)this.getBusinessObjectService().findBySinglePrimaryKey(AwardBudgetStatus.class, (Object)statusCode);
        return budgetStatus.getDescription();
    }

    @Override
    public AwardBudgetDocument rebudget(AwardDocument awardDocument, String documentDescription) throws WorkflowException {
        AwardBudgetDocument rebudgetDocument = this.createNewBudgetDocument(documentDescription, awardDocument, true);
        return rebudgetDocument;
    }

    protected WorkflowDocument getWorkflowDocument(Document doc) {
        DocumentHeader header;
        WorkflowDocument workflowDocument = null;
        if (doc != null && (header = doc.getDocumentHeader()) != null) {
            try {
                workflowDocument = header.getWorkflowDocument();
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
        }
        return workflowDocument;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentservice) {
        this.documentService = documentservice;
    }

    @Override
    public BudgetDocument<Award> getNewBudgetVersion(BudgetParentDocument<Award> parentBudgetDocument, String documentDescription) throws WorkflowException {
        if (this.checkForOutstandingBudgets(parentBudgetDocument)) {
            return null;
        }
        AwardDocument parentDocument = (AwardDocument)parentBudgetDocument;
        AwardBudgetDocument awardBudgetDocument = this.createNewBudgetDocument(documentDescription, parentDocument, false);
        return awardBudgetDocument;
    }

    protected AwardBudgetDocument copyPostedBudgetVersion(AwardDocument parentDocument) {
        AwardBudgetExt previousPostedBudget = this.getLatestPostedBudget(parentDocument);
        return (AwardBudgetDocument)previousPostedBudget.getBudgetDocument();
    }

    protected AwardBudgetDocument createNewBudgetDocument(String documentDescription, AwardDocument parentDocument, boolean rebudget) throws WorkflowException {
        AwardBudgetDocument awardBudgetDocument;
        boolean success = new AwardBudgetVersionRule().processAddBudgetVersion(new AddBudgetVersionEvent(BUDGET_VERSION_ERROR_PREFIX, (Document)parentDocument, documentDescription));
        if (!success) {
            return null;
        }
        Integer budgetVersionNumber = parentDocument.getNextBudgetVersionNumber();
        if (this.isPostedBudgetExist(parentDocument)) {
            BudgetDecimal obligatedChangeAmount = this.getTotalCostLimit(parentDocument);
            AwardBudgetExt previousPostedBudget = this.getLatestPostedBudget(parentDocument);
            AwardBudgetDocument postedBudgetDocument = (AwardBudgetDocument)previousPostedBudget.getBudgetDocument();
            awardBudgetDocument = (AwardBudgetDocument)this.copyBudgetVersion(postedBudgetDocument);
            this.copyObligatedAmountToLineItems(awardBudgetDocument, obligatedChangeAmount);
        } else {
            awardBudgetDocument = (AwardBudgetDocument)this.documentService.getNewDocument(AwardBudgetDocument.class);
        }
        awardBudgetDocument.setParentDocument(parentDocument);
        awardBudgetDocument.setParentDocumentKey(parentDocument.getDocumentNumber());
        awardBudgetDocument.setParentDocumentTypeCode(parentDocument.getDocumentTypeCode());
        awardBudgetDocument.getDocumentHeader().setDocumentDescription(documentDescription);
        AwardBudgetExt awardBudget = awardBudgetDocument.getAwardBudget();
        awardBudget.setBudgetVersionNumber(budgetVersionNumber);
        awardBudget.setBudgetDocument(awardBudgetDocument);
        BudgetVersionOverview lastBudgetVersion = this.getLastBudgetVersion(parentDocument);
        awardBudget.setOnOffCampusFlag(lastBudgetVersion == null ? "D" : lastBudgetVersion.getOnOffCampusFlag());
        if (awardBudgetDocument.getDocumentHeader() != null && awardBudgetDocument.getDocumentHeader().hasWorkflowDocument()) {
            awardBudget.setBudgetInitiator(awardBudgetDocument.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
        }
        Award budgetParent = parentDocument.getBudgetParent();
        awardBudget.setStartDate(budgetParent.getRequestedStartDateInitial());
        awardBudget.setEndDate(budgetParent.getRequestedEndDateInitial());
        if (awardBudget.getOhRatesNonEditable()) {
            awardBudget.setOhRateClassCode(this.getAwardParameterValue("awardBudgetDefaultFnARateClassCode"));
            awardBudget.setUrRateClassCode(this.getAwardParameterValue("awardBudgetDefaultUnderrecoveryRateClassCode"));
        } else {
            awardBudget.setOhRateClassCode(this.getBudgetParameterValue("defaultOverheadRateClassCode"));
            awardBudget.setUrRateClassCode(this.getBudgetParameterValue("defaultUnderrecoveryRateClassCode"));
        }
        awardBudget.setOhRateTypeCode(this.getBudgetParameterValue("defaultOverheadRateTypeCode"));
        awardBudget.setModularBudgetFlag(this.parameterService.getParameterValueAsBoolean(BudgetDocument.class, "defaultModularFlag"));
        awardBudget.setBudgetStatus(this.getAwardParameterValue("awardBudgetStatusInProgress"));
        awardBudget.setBudgetAdjustmentDocumentNumber("");
        awardBudget.setRateClassTypesReloaded(true);
        this.setBudgetLimits(awardBudgetDocument, parentDocument);
        if (this.isPostedBudgetExist(parentDocument) && awardBudget.getTotalCostLimit().equals((Object)BudgetDecimal.ZERO)) {
            rebudget = true;
        }
        this.recalculateBudget(awardBudgetDocument.getBudget());
        this.saveBudgetDocument(awardBudgetDocument, rebudget);
        awardBudgetDocument = (AwardBudgetDocument)this.documentService.getByDocumentHeaderId(awardBudgetDocument.getDocumentNumber());
        parentDocument.refreshBudgetDocumentVersions();
        return awardBudgetDocument;
    }

    private String getBudgetParameterValue(String parameter) {
        return this.parameterService.getParameterValueAsString(BudgetDocument.class, parameter);
    }

    private String getAwardParameterValue(String parameter) {
        return this.parameterService.getParameterValueAsString(AwardBudgetDocument.class, parameter);
    }

    @Override
    public void setBudgetLimits(AwardBudgetDocument awardBudgetDocument, AwardDocument parentDocument) {
        AwardBudgetExt awardBudget = awardBudgetDocument.getAwardBudget();
        awardBudget.setTotalCostLimit(this.getTotalCostLimit(parentDocument));
        awardBudget.setObligatedTotal(new BudgetDecimal(parentDocument.getAward().getBudgetTotalCostLimit().bigDecimalValue()));
        awardBudget.getAwardBudgetLimits().clear();
        for (AwardBudgetLimit limit : parentDocument.getAward().getAwardBudgetLimits()) {
            awardBudget.getAwardBudgetLimits().add(new AwardBudgetLimit(limit));
        }
    }

    protected void copyObligatedAmountToLineItems(AwardBudgetDocument awardBudgetDocument, BudgetDecimal obligatedChangeAmount) {
        AwardBudgetExt newAwardBudgetFromPosted = awardBudgetDocument.getAwardBudget();
        List<BudgetPeriod> awardBudgetPeriods = newAwardBudgetFromPosted.getBudgetPeriods();
        for (BudgetPeriod budgetPeriod : awardBudgetPeriods) {
            AwardBudgetPeriodExt awardBudgetPeriod = (AwardBudgetPeriodExt)budgetPeriod;
            List<BudgetLineItem> lineItems = awardBudgetPeriod.getBudgetLineItems();
            for (BudgetLineItem budgetLineItem : lineItems) {
                AwardBudgetLineItemExt awardBudgetLineItem = (AwardBudgetLineItemExt)budgetLineItem;
                List<BudgetPersonnelDetails> personnelDetailsList = awardBudgetLineItem.getBudgetPersonnelDetailsList();
                for (BudgetPersonnelDetails budgetPersonnelDetails : personnelDetailsList) {
                    AwardBudgetPersonnelDetailsExt awardBudgetPersonnelDetails = (AwardBudgetPersonnelDetailsExt)budgetPersonnelDetails;
                    List personnelCalcAmounts = awardBudgetPersonnelDetails.getBudgetCalculatedAmounts();
                    for (AwardBudgetPersonnelCalculatedAmountExt awardBudgetPersonnelCalculatedAmountExt : personnelCalcAmounts) {
                        awardBudgetPersonnelCalculatedAmountExt.setObligatedAmount((BudgetDecimal)awardBudgetPersonnelCalculatedAmountExt.getObligatedAmount().add(awardBudgetPersonnelCalculatedAmountExt.getCalculatedCost().add(awardBudgetPersonnelCalculatedAmountExt.getCalculatedCostSharing())));
                        awardBudgetPersonnelCalculatedAmountExt.setCalculatedCost(BudgetDecimal.ZERO);
                        awardBudgetPersonnelCalculatedAmountExt.setCalculatedCostSharing(BudgetDecimal.ZERO);
                    }
                    awardBudgetPersonnelDetails.setObligatedAmount((BudgetDecimal)awardBudgetPersonnelDetails.getObligatedAmount().add(awardBudgetPersonnelDetails.getSalaryRequested().add(awardBudgetPersonnelDetails.getCostSharingAmount())));
                    awardBudgetPersonnelDetails.setPercentCharged(BudgetDecimal.ZERO);
                    awardBudgetPersonnelDetails.setPercentEffort(BudgetDecimal.ZERO);
                    awardBudgetPersonnelDetails.setSalaryRequested(BudgetDecimal.ZERO);
                    awardBudgetPersonnelDetails.setCostSharingAmount(BudgetDecimal.ZERO);
                }
                List calcAmounts = budgetLineItem.getBudgetCalculatedAmounts();
                for (AwardBudgetLineItemCalculatedAmountExt budgetLineItemCalculatedAmount : calcAmounts) {
                    budgetLineItemCalculatedAmount.setObligatedAmount((BudgetDecimal)budgetLineItemCalculatedAmount.getObligatedAmount().add(budgetLineItemCalculatedAmount.getCalculatedCost().add(budgetLineItemCalculatedAmount.getCalculatedCostSharing())));
                    budgetLineItemCalculatedAmount.setCalculatedCost(BudgetDecimal.ZERO);
                    budgetLineItemCalculatedAmount.setCalculatedCostSharing(BudgetDecimal.ZERO);
                }
                awardBudgetLineItem.setObligatedAmount((BudgetDecimal)awardBudgetLineItem.getObligatedAmount().add(awardBudgetLineItem.getLineItemCost().add(awardBudgetLineItem.getCostSharingAmount())));
                awardBudgetLineItem.setLineItemCost(BudgetDecimal.ZERO);
                awardBudgetLineItem.setCostSharingAmount(BudgetDecimal.ZERO);
            }
            awardBudgetPeriod.setObligatedAmount((BudgetDecimal)awardBudgetPeriod.getObligatedAmount().add(awardBudgetPeriod.getTotalCost()));
            awardBudgetPeriod.setTotalCost(BudgetDecimal.ZERO);
            awardBudgetPeriod.setTotalDirectCost(BudgetDecimal.ZERO);
            awardBudgetPeriod.setTotalIndirectCost(BudgetDecimal.ZERO);
            awardBudgetPeriod.setTotalCostLimit(obligatedChangeAmount);
        }
    }

    protected AwardBudgetExt getLatestPostedBudget(AwardDocument awardDocument) {
        List documentVersions = awardDocument.getBudgetDocumentVersions();
        QueryList<AwardBudgetVersionOverviewExt> awardBudgetVersionOverviews = new QueryList<AwardBudgetVersionOverviewExt>();
        for (BudgetDocumentVersion budgetDocumentVersion : documentVersions) {
            awardBudgetVersionOverviews.add((AwardBudgetVersionOverviewExt)budgetDocumentVersion.getBudgetVersionOverview());
        }
        Equals eqPostedStatus = new Equals("awardBudgetStatusCode", (Comparable)((Object)this.getAwardPostedStatusCode()));
        QueryList postedVersions = awardBudgetVersionOverviews.filter(eqPostedStatus);
        AwardBudgetExt postedBudget = null;
        if (!postedVersions.isEmpty()) {
            postedVersions.sort("budgetVersionNumber", false);
            AwardBudgetVersionOverviewExt postedVersion = (AwardBudgetVersionOverviewExt)postedVersions.get(0);
            try {
                AwardBudgetDocument awardBudgetDocument = (AwardBudgetDocument)this.documentService.getByDocumentHeaderId(postedVersion.getDocumentNumber());
                postedBudget = awardBudgetDocument.getAwardBudget();
            }
            catch (WorkflowException e) {
                e.printStackTrace();
            }
        }
        return postedBudget;
    }

    @Override
    public BudgetDecimal getTotalCostLimit(AwardDocument awardDocument) {
        KualiDecimal obligatedTotal = awardDocument.getAward().getObligatedDistributableTotal();
        KualiDecimal costLimit = awardDocument.getAward().getTotalCostBudgetLimit();
        BudgetDecimal postedTotalAmount = this.getPostedTotalAmount(awardDocument);
        if (costLimit == null || costLimit.isGreaterEqual((AbstractKualiDecimal)obligatedTotal)) {
            return (BudgetDecimal)new BudgetDecimal(obligatedTotal.bigDecimalValue()).subtract(postedTotalAmount);
        }
        return (BudgetDecimal)new BudgetDecimal(costLimit.bigDecimalValue()).subtract(postedTotalAmount);
    }

    protected BudgetDecimal getPostedTotalAmount(AwardDocument awardDocument) {
        List documentVersions = awardDocument.getBudgetDocumentVersions();
        String postedStatusCode = this.getAwardPostedStatusCode();
        BudgetDecimal postedTotalAmount = BudgetDecimal.ZERO;
        for (BudgetDocumentVersion budgetDocumentVersion : documentVersions) {
            AwardBudgetVersionOverviewExt budget = (AwardBudgetVersionOverviewExt)budgetDocumentVersion.getBudgetVersionOverview();
            if (!budget.getAwardBudgetStatusCode().equals(postedStatusCode)) continue;
            postedTotalAmount = (BudgetDecimal)postedTotalAmount.add(budget.getTotalCost());
        }
        return postedTotalAmount;
    }

    protected boolean isPostedBudgetExist(AwardDocument awardDocument) {
        boolean exist = false;
        List documentVersions = awardDocument.getBudgetDocumentVersions();
        String postedStatusCode = this.getAwardPostedStatusCode();
        for (BudgetDocumentVersion budgetDocumentVersion : documentVersions) {
            AwardBudgetVersionOverviewExt budget = (AwardBudgetVersionOverviewExt)budgetDocumentVersion.getBudgetVersionOverview();
            if (!budget.getAwardBudgetStatusCode().equals(postedStatusCode)) continue;
            exist = true;
            break;
        }
        return exist;
    }

    protected String getAwardPostedStatusCode() {
        return this.parameterService.getParameterValueAsString(AwardBudgetDocument.class, "awardBudgetStatusPosted");
    }

    protected BudgetVersionOverview getLastBudgetVersion(AwardDocument award) {
        List awardBudgetDocumentVersions = award.getBudgetDocumentVersions();
        BudgetVersionOverview budgetVersionOverview = null;
        int versionSize = awardBudgetDocumentVersions.size();
        if (versionSize > 0) {
            budgetVersionOverview = ((BudgetDocumentVersion)awardBudgetDocumentVersions.get(versionSize - 1)).getBudgetVersionOverview();
        }
        return budgetVersionOverview;
    }

    protected void saveBudgetDocument(BudgetDocument<Award> budgetDocument, boolean rebudget) throws WorkflowException {
        AwardBudgetDocument awardBudgetDocument = (AwardBudgetDocument)budgetDocument;
        AwardBudgetExt budgetExt = awardBudgetDocument.getAwardBudget();
        String awardBudgetTypeID = this.getParameterValue(rebudget ? "awardBudgetTypeRebudget" : "awardBudgetTypeNew");
        AwardBudgetType awardBudgetType = (AwardBudgetType)this.getBusinessObjectService().findBySinglePrimaryKey(AwardBudgetType.class, (Object)awardBudgetTypeID);
        budgetExt.setAwardBudgetTypeCode(awardBudgetType.getAwardBudgetTypeCode());
        budgetExt.setDescription(awardBudgetType.getDescription());
        budgetExt.setAwardBudgetType(awardBudgetType);
        this.processStatusChange(awardBudgetDocument, "awardBudgetStatusInProgress");
        this.saveDocument(awardBudgetDocument);
    }

    protected void copyProposalBudgetLineItemsToAwardBudget(BudgetPeriod awardBudgetPeriod, BudgetPeriod proposalBudgetPeriod) {
        List<BudgetLineItem> awardBudgetLineItems = awardBudgetPeriod.getBudgetLineItems();
        List<BudgetLineItem> lineItems = proposalBudgetPeriod.getBudgetLineItems();
        for (BudgetLineItem budgetLineItem : lineItems) {
            String[] ignoreProperties = new String[]{"budgetId", "budgetLineItemId", "budgetPeriodId", "submitCostSharingFlag", "budgetLineItemCalculatedAmounts", "budgetPersonnelDetailsList", "budgetRateAndBaseList"};
            AwardBudgetLineItemExt awardBudgetLineItem = new AwardBudgetLineItemExt();
            BeanUtils.copyProperties((Object)budgetLineItem, (Object)awardBudgetLineItem, (String[])ignoreProperties);
            awardBudgetLineItem.setLineItemNumber(awardBudgetPeriod.getBudget().getHackedDocumentNextValue("budget.budgetLineItem.lineItemNumber"));
            awardBudgetLineItem.setBudgetId(awardBudgetPeriod.getBudgetId());
            awardBudgetLineItem.setStartDate(awardBudgetPeriod.getStartDate());
            awardBudgetLineItem.setEndDate(awardBudgetPeriod.getEndDate());
            List<BudgetPersonnelDetails> awardBudgetPersonnelLineItems = awardBudgetLineItem.getBudgetPersonnelDetailsList();
            List<BudgetPersonnelDetails> budgetPersonnelLineItems = budgetLineItem.getBudgetPersonnelDetailsList();
            for (BudgetPersonnelDetails budgetPersonnelDetails : budgetPersonnelLineItems) {
                budgetPersonnelDetails.setBudgetLineItemId(budgetLineItem.getBudgetLineItemId());
                AwardBudgetPersonnelDetailsExt awardBudgetPerDetails = new AwardBudgetPersonnelDetailsExt();
                BeanUtils.copyProperties((Object)budgetPersonnelDetails, (Object)awardBudgetPerDetails, (String[])new String[]{"budgetPersonnelLineItemId", "budgetLineItemId", "budgetId", "submitCostSharingFlag", "budgetPersonnelCalculatedAmounts", "budgetPersonnelRateAndBaseList", "validToApplyInRate"});
                awardBudgetPerDetails.setPersonNumber(awardBudgetPeriod.getBudget().getHackedDocumentNextValue("budget.budgetPersonnelDetails.personNumber"));
                BudgetPerson oldBudgetPerson = budgetPersonnelDetails.getBudgetPerson();
                BudgetPerson currentBudgetPerson = this.findMatchingPersonInBudget(awardBudgetPeriod.getBudget(), oldBudgetPerson, budgetPersonnelDetails.getJobCode());
                if (currentBudgetPerson == null) {
                    currentBudgetPerson = new BudgetPerson();
                    BeanUtils.copyProperties((Object)oldBudgetPerson, (Object)currentBudgetPerson, (String[])new String[]{"budgetId", "personSequenceNumber"});
                    currentBudgetPerson.setBudgetId(awardBudgetPeriod.getBudgetId());
                    currentBudgetPerson.setPersonSequenceNumber(awardBudgetPeriod.getBudget().getBudgetDocument().getHackedDocumentNextValue("personSequenceNumber"));
                    awardBudgetPeriod.getBudget().getBudgetPersons().add(currentBudgetPerson);
                }
                awardBudgetPerDetails.setBudgetPerson(currentBudgetPerson);
                awardBudgetPerDetails.setPersonSequenceNumber(currentBudgetPerson.getPersonSequenceNumber());
                awardBudgetPerDetails.setBudgetId(awardBudgetPeriod.getBudgetId());
                awardBudgetPerDetails.setCostElement(awardBudgetLineItem.getCostElement());
                awardBudgetPerDetails.setStartDate(awardBudgetLineItem.getStartDate());
                awardBudgetPerDetails.setEndDate(awardBudgetLineItem.getEndDate());
                awardBudgetPersonnelLineItems.add(awardBudgetPerDetails);
            }
            awardBudgetLineItems.add(awardBudgetLineItem);
            this.getAwardBudgetCalculationService().populateCalculatedAmount(awardBudgetPeriod.getBudget(), awardBudgetLineItem);
        }
    }

    protected BudgetPerson findMatchingPersonInBudget(Budget budget, BudgetPerson oldBudgetPerson, String jobCode) {
        for (BudgetPerson budgetPerson : budget.getBudgetPersons()) {
            if (!budgetPerson.isSamePerson(oldBudgetPerson) || !StringUtils.equals((String)budgetPerson.getJobCode(), (String)jobCode)) continue;
            return budgetPerson;
        }
        return null;
    }

    protected DeepCopyPostProcessor getDeepCopyPostProcessor() {
        return KraServiceLocator.getService(DeepCopyPostProcessor.class);
    }

    @Override
    public BudgetDocument<Award> copyBudgetVersion(BudgetDocument<Award> budgetDocument) throws WorkflowException {
        return this.copyBudgetVersion(budgetDocument, false);
    }

    @Override
    public BudgetDocument<Award> copyBudgetVersion(BudgetDocument<Award> budgetDocument, boolean onlyOnePeriod) throws WorkflowException {
        ((AwardBudgetExt)budgetDocument.getBudget()).getAwardBudgetLimits().clear();
        BudgetDocument<Award> newBudgetDocument = this.getBudgetService().copyBudgetVersion(budgetDocument, onlyOnePeriod);
        this.setBudgetLimits((AwardBudgetDocument)newBudgetDocument, (AwardDocument)newBudgetDocument.getParentDocument());
        return newBudgetDocument;
    }

    public void setBudgetService(BudgetService<Award> budgetService) {
        this.budgetService = budgetService;
    }

    public BudgetService<Award> getBudgetService() {
        return this.budgetService;
    }

    public BudgetSummaryService getBudgetSummaryService() {
        return this.budgetSummaryService;
    }

    public void setBudgetSummaryService(BudgetSummaryService budgetSummaryService) {
        this.budgetSummaryService = budgetSummaryService;
    }

    @Override
    public void copyLineItemsFromProposalPeriods(Collection rawValues, BudgetPeriod awardBudgetPeriod) throws WorkflowException {
        awardBudgetPeriod.getBudgetLineItems().clear();
        for (BudgetPeriod proposalPeriod : rawValues) {
            this.copyProposalBudgetLineItemsToAwardBudget(awardBudgetPeriod, proposalPeriod);
        }
        this.getDocumentService().saveDocument((Document)awardBudgetPeriod.getBudget().getBudgetDocument());
        this.getBudgetSummaryService().calculateBudget(awardBudgetPeriod.getBudget());
    }

    protected List findObjectsWithSingleKey(Class clazz, String key, Object value) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(key, value);
        return (List)this.getBusinessObjectService().findMatching(clazz, fieldValues);
    }

    @Override
    public List<BudgetPeriod> findBudgetPeriodsFromLinkedProposal(String awardNumber) {
        BusinessObjectService businessObjectService = this.getBusinessObjectService();
        ArrayList<BudgetPeriod> budgetPeriods = new ArrayList<BudgetPeriod>();
        List awardVersions = this.findObjectsWithSingleKey(Award.class, "awardNumber", awardNumber);
        for (Award award : awardVersions) {
            List fundingProposals = this.findObjectsWithSingleKey(AwardFundingProposal.class, "awardId", award.getAwardId());
            for (AwardFundingProposal fundingProposal : fundingProposals) {
                if (!fundingProposal.isActive()) continue;
                List instProposals = this.findObjectsWithSingleKey(InstitutionalProposal.class, "proposalNumber", fundingProposal.getProposal().getProposalNumber());
                for (InstitutionalProposal instProp : instProposals) {
                    List proposalAdminDetails = this.findObjectsWithSingleKey(ProposalAdminDetails.class, "instProposalId", instProp.getProposalId());
                    for (ProposalAdminDetails proposalAdminDetail : proposalAdminDetails) {
                        String developmentProposalNumber = proposalAdminDetail.getDevProposalNumber();
                        DevelopmentProposal proposalDevelopmentDocument = (DevelopmentProposal)businessObjectService.findBySinglePrimaryKey(DevelopmentProposal.class, (Object)developmentProposalNumber);
                        List budgetDocumentVersions = this.findObjectsWithSingleKey(BudgetDocumentVersion.class, "parentDocumentKey", proposalDevelopmentDocument.getProposalDocument().getDocumentNumber());
                        for (BudgetDocumentVersion budgetDocumentVersion : budgetDocumentVersions) {
                            Budget budget = (Budget)this.getBusinessObjectService().findBySinglePrimaryKey(ProposalDevelopmentBudgetExt.class, (Object)budgetDocumentVersion.getBudgetVersionOverview().getBudgetId());
                            if (!budget.isFinalVersionFlag()) continue;
                            for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                                budgetPeriod.setInstitutionalProposalNumber(instProp.getProposalNumber());
                                budgetPeriod.setInstitutionalProposalVersion(instProp.getSequenceNumber());
                                budgetPeriods.add(budgetPeriod);
                            }
                        }
                    }
                }
            }
        }
        return budgetPeriods;
    }

    @Override
    public boolean checkForOutstandingBudgets(BudgetParentDocument parentDoc) {
        boolean result = false;
        for (BudgetDocumentVersion budgetVersion : parentDoc.getBudgetDocumentVersions()) {
            BudgetVersionOverview version = budgetVersion.getBudgetVersionOverview();
            AwardBudgetExt awardBudget = (AwardBudgetExt)this.getBusinessObjectService().findBySinglePrimaryKey(AwardBudgetExt.class, (Object)version.getBudgetId());
            if (StringUtils.equals((String)awardBudget.getAwardBudgetStatusCode(), (String)this.getPostedBudgetStatus()) || StringUtils.equals((String)awardBudget.getAwardBudgetStatusCode(), (String)this.getRejectedBudgetStatus()) || StringUtils.equals((String)awardBudget.getAwardBudgetStatusCode(), (String)this.getCancelledBudgetStatus())) continue;
            result = true;
            GlobalVariables.getMessageMap().putError(BUDGET_VERSION_ERROR_PREFIX, "error.budget.unfinalized.exist", new String[]{awardBudget.getDocumentDescription()});
        }
        return result;
    }

    @Override
    public List<String> getInactiveBudgetStatus() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getRejectedBudgetStatus());
        result.add(this.getCancelledBudgetStatus());
        result.add(this.getDoNotPostBudgetStatus());
        result.add(this.getDisapprovedBudgetStatus());
        return result;
    }

    @Override
    public void populateBudgetLimitSummary(BudgetLimitSummaryHelper summary, AwardDocument awardDocument) {
        AwardBudgetExt currentBudget = this.getCurrentBudget(awardDocument);
        if (summary.getCurrentBudget() == null || !ObjectUtils.equals((Object)summary.getCurrentBudget(), (Object)currentBudget)) {
            this.getAwardBudgetCalculationService().calculateBudgetSummaryTotals(currentBudget, false);
            summary.setCurrentBudget(currentBudget);
        }
        AwardBudgetExt prevBudget = this.getPreviousBudget(awardDocument);
        if (summary.getPreviousBudget() == null || !ObjectUtils.equals((Object)summary.getPreviousBudget(), (Object)prevBudget)) {
            this.getAwardBudgetCalculationService().calculateBudgetSummaryTotals(prevBudget, true);
            summary.setPreviousBudget(prevBudget);
        }
    }

    protected AwardBudgetExt getCurrentBudget(AwardDocument awardDocument) {
        return this.getNewestBudgetByStatus(awardDocument, Arrays.asList("1", "5", "10"));
    }

    protected AwardBudgetExt getPreviousBudget(AwardDocument awardDocument) {
        return this.getNewestBudgetByStatus(awardDocument, Arrays.asList(this.getPostedBudgetStatus()));
    }

    protected AwardBudgetExt getNewestBudgetByStatus(AwardDocument awardDocument, List<String> statuses) {
        BudgetVersionOverview budgetVersion = null;
        List awardBudgetDocuments = awardDocument.getBudgetDocumentVersions();
        for (BudgetDocumentVersion version : awardBudgetDocuments) {
            AwardBudgetVersionOverviewExt curVersion = (AwardBudgetVersionOverviewExt)version.getBudgetVersionOverview();
            if (!statuses.contains(curVersion.getAwardBudgetStatusCode()) || budgetVersion != null && curVersion.getBudgetVersionNumber() <= budgetVersion.getBudgetVersionNumber()) continue;
            budgetVersion = curVersion;
        }
        AwardBudgetExt result = null;
        if (budgetVersion != null) {
            result = (AwardBudgetExt)this.getBusinessObjectService().findBySinglePrimaryKey(AwardBudgetExt.class, (Object)budgetVersion.getBudgetId());
        }
        if (result == null) {
            result = new AwardBudgetExt();
        }
        return result;
    }

    @Override
    public List<BudgetDocumentVersion> getAllBudgetsForAward(AwardDocument awardDocument) {
        HashSet<BudgetDocumentVersion> result = new HashSet<BudgetDocumentVersion>();
        List<VersionHistory> versions = this.getVersionHistoryService().loadVersionHistory(Award.class, awardDocument.getAward().getAwardNumber());
        for (VersionHistory version : versions) {
            if (version.getSequenceOwnerSequenceNumber() > awardDocument.getAward().getSequenceNumber() || version.getSequenceOwner() == null || ((Award)version.getSequenceOwner()).getAwardDocument() == null) continue;
            result.addAll(((Award)version.getSequenceOwner()).getAwardDocument().getActualBudgetDocumentVersions());
        }
        ArrayList<BudgetDocumentVersion> listResult = new ArrayList<BudgetDocumentVersion>(result);
        Collections.sort(listResult);
        return listResult;
    }

    @Override
    public Award getActiveOrNewestAward(String awardNumber) {
        return this.awardService.getActiveOrNewestAward(awardNumber);
    }

    protected String getPostedBudgetStatus() {
        return this.getParameterValue("awardBudgetStatusPosted");
    }

    protected String getRejectedBudgetStatus() {
        return this.getParameterValue("awardBudgetStatusRejected");
    }

    protected String getCancelledBudgetStatus() {
        return "14";
    }

    protected String getDisapprovedBudgetStatus() {
        return "13";
    }

    protected String getDoNotPostBudgetStatus() {
        return this.getParameterValue("awardBudgetStatusDoNotPost");
    }

    protected VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    protected AwardBudgetCalculationService getAwardBudgetCalculationService() {
        return this.awardBudgetCalculationService;
    }

    public void setAwardBudgetCalculationService(AwardBudgetCalculationService awardBudgetCalculationService) {
        this.awardBudgetCalculationService = awardBudgetCalculationService;
    }

    protected BudgetCalculationService getBudgetCalculationService() {
        return this.budgetCalculationService;
    }

    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }

    @Override
    public boolean isRateOverridden(BudgetPeriod budgetPeriod) {
        return ((AwardBudgetPeriodExt)budgetPeriod).getRateOverrideFlag();
    }

    private BudgetDecimal getPeriodFringeTotal(BudgetPeriod budgetPeriod, Budget budget) {
        if (budget.getBudgetSummaryTotals() == null || budget.getBudgetSummaryTotals().get("personnelFringeTotals") == null) {
            return BudgetDecimal.ZERO;
        }
        BudgetDecimal periodFringeTotal = (BudgetDecimal)((Object)((List)budget.getBudgetSummaryTotals().get("personnelFringeTotals")).get(budgetPeriod.getBudgetPeriod() - 1));
        return periodFringeTotal;
    }

    @Override
    public void recalculateBudget(Budget budget) {
        List<BudgetPeriod> awardBudgetPeriods = budget.getBudgetPeriods();
        for (BudgetPeriod budgetPeriod : awardBudgetPeriods) {
            this.removeBudgetSummaryPeriodCalcAmounts(budgetPeriod);
        }
        this.budgetCalculationService.calculateBudget(budget);
        this.budgetCalculationService.calculateBudgetSummaryTotals(budget);
    }

    @Override
    public void recalculateBudgetPeriod(Budget budget, BudgetPeriod budgetPeriod) {
        this.removeBudgetSummaryPeriodCalcAmounts(budgetPeriod);
        this.budgetCalculationService.calculateBudgetPeriod(budget, budgetPeriod);
    }

    @Override
    public void calculateBudgetOnSave(Budget budget) {
        this.budgetCalculationService.calculateBudget(budget);
        this.budgetCalculationService.calculateBudgetSummaryTotals(budget);
        List<BudgetPeriod> awardBudgetPeriods = budget.getBudgetPeriods();
        for (BudgetPeriod awardBudgetPeriod : awardBudgetPeriods) {
            AwardBudgetPeriodExt budgetPeriod = (AwardBudgetPeriodExt)awardBudgetPeriod;
            BudgetDecimal periodFringeTotal = this.getPeriodFringeTotal(budgetPeriod, budget);
            if (periodFringeTotal.equals((Object)BudgetDecimal.ZERO) && budgetPeriod.getTotalFringeAmount().equals((Object)BudgetDecimal.ZERO)) continue;
            budgetPeriod.setTotalDirectCost((BudgetDecimal)((BudgetDecimal)budgetPeriod.getTotalDirectCost().subtract(periodFringeTotal)).add(budgetPeriod.getTotalFringeAmount()));
            budgetPeriod.setTotalCost((BudgetDecimal)budgetPeriod.getTotalDirectCost().add(budgetPeriod.getTotalIndirectCost()));
        }
        this.setBudgetCostsFromPeriods(budget);
    }

    @Override
    public void populateSummaryCalcAmounts(Budget budget, BudgetPeriod budgetPeriod) {
        AwardBudgetPeriodExt awardBudgetPeriod = (AwardBudgetPeriodExt)budgetPeriod;
        List<AwardBudgetPeriodSummaryCalculatedAmount> awardBudgetPeriodFringeAmounts = awardBudgetPeriod.getAwardBudgetPeriodFringeAmounts();
        awardBudgetPeriodFringeAmounts.clear();
        if (awardBudgetPeriodFringeAmounts.isEmpty()) {
            SortedMap<String, List<BudgetDecimal>> objectCodePersonnelFringe = budget.getObjectCodePersonnelFringeTotals();
            if (objectCodePersonnelFringe != null) {
                for (String costElement : objectCodePersonnelFringe.keySet()) {
                    String[] costElementAndPersonId = costElement.split(",");
                    List fringeTotals = (List)objectCodePersonnelFringe.get(costElement);
                    AwardBudgetPeriodSummaryCalculatedAmount oldAwardBudgetPeriodSummaryCalculatedAmount = this.getSummaryCalculatedAmountFromList(awardBudgetPeriodFringeAmounts, costElementAndPersonId[0]);
                    if (oldAwardBudgetPeriodSummaryCalculatedAmount == null) {
                        AwardBudgetPeriodSummaryCalculatedAmount awardBudgetPeriodSummaryCalculatedAmount = this.createNewAwardBudgetPeriodSummaryCalculatedAmount(awardBudgetPeriod, costElementAndPersonId[0], RateClassType.EMPLOYEE_BENEFITS.getRateClassType(), (BudgetDecimal)((Object)fringeTotals.get(budgetPeriod.getBudgetPeriod() - 1)));
                        awardBudgetPeriodFringeAmounts.add(awardBudgetPeriodSummaryCalculatedAmount);
                        continue;
                    }
                    oldAwardBudgetPeriodSummaryCalculatedAmount.setCalculatedCost((BudgetDecimal)oldAwardBudgetPeriodSummaryCalculatedAmount.getCalculatedCost().add((AbstractKualiDecimal)fringeTotals.get(budgetPeriod.getBudgetPeriod() - 1)));
                }
            }
            QueryList<AwardBudgetPeriodSummaryCalculatedAmount> ebCalculatedAmounts = this.filterEBRates(awardBudgetPeriod);
            awardBudgetPeriod.setTotalFringeAmount(ebCalculatedAmounts.sumObjects("calculatedCost"));
        }
    }

    private AwardBudgetPeriodSummaryCalculatedAmount getSummaryCalculatedAmountFromList(List<AwardBudgetPeriodSummaryCalculatedAmount> awardBudgetPeriodFringeAmounts, String costElement) {
        for (AwardBudgetPeriodSummaryCalculatedAmount awardBudgetPeriodSummaryCalculatedAmount : awardBudgetPeriodFringeAmounts) {
            if (!awardBudgetPeriodSummaryCalculatedAmount.getCostElement().equals(costElement)) continue;
            return awardBudgetPeriodSummaryCalculatedAmount;
        }
        return null;
    }

    private QueryList<AwardBudgetPeriodSummaryCalculatedAmount> filterEBRates(AwardBudgetPeriodExt budgetPeriod) {
        QueryList<AwardBudgetPeriodSummaryCalculatedAmount> qlAwardBudgetPeriodSummaryCalculatedAmounts = new QueryList<AwardBudgetPeriodSummaryCalculatedAmount>(budgetPeriod.getAwardBudgetPeriodFringeAmounts());
        Equals ebClassType = new Equals("rateClassType", (Comparable)((Object)RateClassType.EMPLOYEE_BENEFITS.getRateClassType()));
        QueryList<AwardBudgetPeriodSummaryCalculatedAmount> ebCalculatedAmounts = qlAwardBudgetPeriodSummaryCalculatedAmounts.filter(ebClassType);
        return ebCalculatedAmounts;
    }

    private AwardBudgetPeriodSummaryCalculatedAmount createNewAwardBudgetPeriodSummaryCalculatedAmount(AwardBudgetPeriodExt budgetPeriodExt, String costElement, String rateClassType, BudgetDecimal calculatedCost) {
        AwardBudgetPeriodSummaryCalculatedAmount awardBudgetPeriodSummaryCalculatedAmount = new AwardBudgetPeriodSummaryCalculatedAmount();
        awardBudgetPeriodSummaryCalculatedAmount.setBudgetPeriodId(budgetPeriodExt.getBudgetPeriodId());
        awardBudgetPeriodSummaryCalculatedAmount.setCalculatedCost(calculatedCost);
        awardBudgetPeriodSummaryCalculatedAmount.setCostElement(costElement);
        awardBudgetPeriodSummaryCalculatedAmount.setRateClassType(rateClassType);
        return awardBudgetPeriodSummaryCalculatedAmount;
    }

    protected void setBudgetCostsFromPeriods(Budget budget) {
        assert (budget != null) : "The document is null";
        budget.setTotalDirectCost(budget.getSumDirectCostAmountFromPeriods());
        budget.setTotalIndirectCost(budget.getSumIndirectCostAmountFromPeriods());
        budget.setTotalCost(budget.getSumTotalCostAmountFromPeriods());
        budget.setUnderrecoveryAmount(budget.getSumUnderreoveryAmountFromPeriods());
        budget.setCostSharingAmount(budget.getSumCostSharingAmountFromPeriods());
    }

    @Override
    public boolean isRateOverridden(Budget budget) {
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            if (!this.isRateOverridden(budgetPeriod)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeBudgetSummaryPeriodCalcAmounts(BudgetPeriod budgetPeriod) {
        AwardBudgetPeriodExt awardBudgetPeriod = (AwardBudgetPeriodExt)budgetPeriod;
        awardBudgetPeriod.setTotalFringeAmount(null);
        awardBudgetPeriod.getAwardBudgetPeriodFringeAmounts().clear();
        awardBudgetPeriod.getAwardBudgetPeriodFnAAmounts().clear();
        awardBudgetPeriod.setRateOverrideFlag(false);
    }

    @Override
    public boolean validateAddingNewBudget(BudgetParentDocument<Award> parentDocument) {
        return !this.checkForOutstandingBudgets(parentDocument);
    }

    @Override
    public boolean checkRateChange(Collection<BudgetRate> savedBudgetRates, Award award) {
        award.refreshReferenceObject("awardFandaRate");
        List<AwardFandaRate> awardFandaRates = award.getAwardFandaRate();
        boolean changeFlag = false;
        for (AwardFandaRate budgetFnARate : awardFandaRates) {
            Equals eqCampusFlag;
            Equals eqRateTypeCode;
            RateType fnaRateType = budgetFnARate.getFandaRateType();
            Equals eqRateClasCode = new Equals("rateClassCode", (Comparable)((Object)fnaRateType.getRateClassCode()));
            And rateClassAndRateType = new And(eqRateClasCode, eqRateTypeCode = new Equals("rateTypeCode", (Comparable)((Object)fnaRateType.getRateTypeCode())));
            And rateClassAndRateTypeAndCampusFlag = new And(rateClassAndRateType, eqCampusFlag = new Equals("onOffCampusFlag", budgetFnARate.getOnOffCampusFlag()));
            QueryList<BudgetRate> matchAwardFnARate = new QueryList<BudgetRate>(savedBudgetRates).filter(rateClassAndRateTypeAndCampusFlag);
            if (!matchAwardFnARate.isEmpty() && matchAwardFnARate.size() <= 1 && matchAwardFnARate.get(0).getApplicableRate().equals(budgetFnARate.getApplicableFandaRate())) continue;
            changeFlag = true;
        }
        Equals eqRateClasCode = new Equals("rateClassCode", (Comparable)((Object)this.getBudgetParameterValue("awardBudgetEbRateClassCode")));
        Equals eqRateTypeCode = new Equals("rateTypeCode", (Comparable)((Object)this.getBudgetParameterValue("awardBudgetEbRateTypeCode")));
        And rateClassAndRateType = new And(eqRateClasCode, eqRateTypeCode);
        QueryList<BudgetRate> matchAwardEBCampusRates = new QueryList<BudgetRate>(savedBudgetRates).filter(rateClassAndRateType);
        for (BudgetRate budgetEBRate : matchAwardEBCampusRates) {
            if (budgetEBRate.getOnOffCampusFlag().booleanValue()) {
                if (award.getSpecialEbRateOnCampus() == null || award.getSpecialEbRateOnCampus().equals((Object)budgetEBRate.getApplicableRate())) continue;
                changeFlag = true;
                continue;
            }
            if (award.getSpecialEbRateOffCampus() == null || award.getSpecialEbRateOffCampus().equals((Object)budgetEBRate.getApplicableRate())) continue;
            changeFlag = true;
        }
        if ((award.getSpecialEbRateOnCampus() != null || award.getSpecialEbRateOffCampus() != null) && matchAwardEBCampusRates.isEmpty()) {
            changeFlag = true;
        }
        return changeFlag;
    }

    protected AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }
}

