/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.util.HashMap;
import java.util.List;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.budget.versions.AddBudgetVersionEvent;
import org.kuali.kra.budget.versions.BudgetVersionRule;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardBudgetVersionRule
extends BudgetVersionRule {
    BusinessObjectService businessObjectService;
    DocumentService documentService;
    ParameterService parameterService;

    @Override
    public boolean processAddBudgetVersion(AddBudgetVersionEvent event) throws WorkflowException {
        TimeAndMoneyDocument timeAndMoneyDocument;
        boolean success = true;
        Award award = ((AwardDocument)event.getDocument()).getAward();
        if (!award.getObligatedDistributableTotal().isPositive()) {
            GlobalVariables.getMessageMap().putError(event.getErrorPathPrefix(), "error.award.invalidObligatedAmount", new String[]{"Name"});
            success &= false;
        }
        if (award.getRequestedStartDateInitial() == null) {
            GlobalVariables.getMessageMap().putError(event.getErrorPathPrefix(), "error.award.budgetVersion.startDate.required", new String[0]);
            success &= false;
        }
        if (award.getRequestedEndDateInitial() == null) {
            GlobalVariables.getMessageMap().putError(event.getErrorPathPrefix(), "error.award.budgetVersion.endDate.required", new String[0]);
            success &= false;
        }
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put("awardId", award.getAwardId());
        List awards = (List)this.getBusinessObjectService().findMatchingOrderBy(Award.class, fieldValues, "awardId", true);
        boolean anyAwardVersionFinal = false;
        boolean anyTimeAndMoneyDocumentsFinal = false;
        for (Award testAward : awards) {
            Award wfAward = ((AwardDocument)this.getDocumentService().getByDocumentHeaderId(award.getAwardDocument().getDocumentHeader().getDocumentNumber())).getAward();
            if (!wfAward.getAwardDocument().getDocumentHeader().hasWorkflowDocument() || !wfAward.getAwardDocument().getDocumentHeader().getWorkflowDocument().isFinal()) continue;
            anyAwardVersionFinal = true;
            break;
        }
        Award testTandMAward = (Award)awards.get(awards.size() - 1);
        String timeAndMoneyDocumentNumber = null;
        for (AwardAmountInfo awardAmountInfo : award.getAwardAmountInfos()) {
            if (awardAmountInfo.getTimeAndMoneyDocumentNumber() == null) continue;
            timeAndMoneyDocumentNumber = awardAmountInfo.getTimeAndMoneyDocumentNumber();
            break;
        }
        HashMap<String, String> fieldValues1 = new HashMap<String, String>();
        String rootAwardNumber = award.getAwardNumber();
        fieldValues1.put("rootAwardNumber", rootAwardNumber);
        List timeAndMoneyDocuments = (List)this.getBusinessObjectService().findMatchingOrderBy(TimeAndMoneyDocument.class, fieldValues1, "documentNumber", true);
        if (!timeAndMoneyDocuments.isEmpty() && (timeAndMoneyDocument = (TimeAndMoneyDocument)this.getDocumentService().getByDocumentHeaderId(((TimeAndMoneyDocument)timeAndMoneyDocuments.get(0)).getDocumentHeader().getDocumentNumber())).getDocumentHeader().hasWorkflowDocument() && timeAndMoneyDocument.getDocumentHeader().getWorkflowDocument().isFinal()) {
            anyTimeAndMoneyDocumentsFinal = true;
        }
        System.err.println("Got here! XXXXXXXXXXXXXX");
        if (!anyAwardVersionFinal && !anyTimeAndMoneyDocumentsFinal) {
            GlobalVariables.getMessageMap().putError(event.getErrorPathPrefix(), "error.budget.award.not.final", new String[0]);
            success &= false;
        }
        return success;
    }

    public BusinessObjectService getBusinessObjectService() {
        this.businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DocumentService getDocumentService() {
        this.documentService = KraServiceLocator.getService(DocumentService.class);
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

