/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.budget.rates.RateType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.KeyValuesService;

public class AwardFnARatesValuesFinder
extends KeyValuesBase {
    KeyValuesService keyValuesService = (KeyValuesService)KraServiceLocator.getService("keyValuesService");
    ParameterService parameterService = KraServiceLocator.getService(ParameterService.class);

    public List<KeyValue> getKeyValues() {
        List<KeyValue> matchingAwardFnARateTypes = this.filterRateTypes();
        matchingAwardFnARateTypes.add(0, (KeyValue)new ConcreteKeyValue("", "select"));
        return matchingAwardFnARateTypes;
    }

    private List<KeyValue> filterRateTypes() {
        Collection awardFnARateTypes = this.keyValuesService.findAll(RateType.class);
        String fnaRateClassCode = this.parameterService.getParameterValueAsString(AwardBudgetDocument.class, "awardBudgetDefaultFnARateClassCode");
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (RateType rateType : awardFnARateTypes) {
            if (!rateType.getRateClassCode().equals(fnaRateClassCode)) continue;
            keyValues.add((KeyValue)new ConcreteKeyValue(rateType.getRateTypeCode(), rateType.getDescription()));
        }
        return keyValues;
    }
}

