/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.BudgetCategoryType;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.budget.rates.RateType;

public class BudgetLimitSummaryHelper
implements Serializable {
    private static final long serialVersionUID = -3504648775976043270L;
    private AwardBudgetExt currentBudget;
    private AwardBudgetExt previousBudget;

    public Map<BudgetCategoryType, Set<CostElement>> getCombinedObjectCodeListByCategory() {
        TreeMap<BudgetCategoryType, Set<CostElement>> result = new TreeMap<BudgetCategoryType, Set<CostElement>>();
        for (Map.Entry<BudgetCategoryType, List<CostElement>> entry : this.currentBudget.getObjectCodeListByBudgetCategoryType().entrySet()) {
            result.put(entry.getKey(), new TreeSet(entry.getValue()));
        }
        for (Map.Entry<BudgetCategoryType, List<CostElement>> entry : this.previousBudget.getObjectCodeListByBudgetCategoryType().entrySet()) {
            Set<CostElement> curElements = result.get(entry.getKey());
            if (curElements == null) {
                result.put(entry.getKey(), new TreeSet(entry.getValue()));
                continue;
            }
            curElements.addAll((Collection<CostElement>)entry.getValue());
        }
        return result;
    }

    public Set<CostElement> getCombinedPersonnelObjectCodes() {
        for (Map.Entry<BudgetCategoryType, Set<CostElement>> entry : this.getCombinedObjectCodeListByCategory().entrySet()) {
            if (!StringUtils.equals((String)entry.getKey().getBudgetCategoryTypeCode(), (String)"P")) continue;
            return entry.getValue();
        }
        return new TreeSet<CostElement>();
    }

    public Map<CostElement, BudgetDecimal> getCurrentObjectCodeTotals() {
        return this.getCurrentBudget().getObjectCodeBudgetTotals();
    }

    public Map<CostElement, BudgetDecimal> getPreviousObjectCodeTotals() {
        return this.getPreviousBudget().getObjectCodeBudgetTotals();
    }

    public Map<String, BudgetDecimal> getCurrentSummaryTotals() {
        return this.getCurrentBudget().getTotalBudgetSummaryTotals();
    }

    public Map<String, BudgetDecimal> getPreviousSummaryTotals() {
        return this.getPreviousBudget().getTotalBudgetSummaryTotals();
    }

    public Map<String, BudgetDecimal> getCurrentObjectCodePersonnelFringeTotals() {
        return this.getCurrentBudget().getObjectCodePersonnelFringeBudgetTotals();
    }

    public Map<String, BudgetDecimal> getPreviousObjectCodePersonnelFringeTotals() {
        return this.getPreviousBudget().getObjectCodePersonnelFringeBudgetTotals();
    }

    public Set<RateType> getCombinedPersonnelCalculatedExpenseRates() {
        TreeSet<RateType> result = new TreeSet<RateType>();
        for (RateType type : this.getCurrentBudget().getPersonnelCalculatedExpenseTotals().keySet()) {
            if (type.getRateClass().getRateClassType() == null || StringUtils.equals((String)type.getRateClass().getRateClassType(), (String)"O")) continue;
            result.add(type);
        }
        for (RateType type : this.getPreviousBudget().getPersonnelCalculatedExpenseTotals().keySet()) {
            if (type.getRateClass().getRateClassType() == null || StringUtils.equals((String)type.getRateClass().getRateClassType(), (String)"O")) continue;
            result.add(type);
        }
        return result;
    }

    public Map<RateType, BudgetDecimal> getCurrentPersonnelCalculatedExpenseTotals() {
        return this.getCurrentBudget().getPersonnelCalculatedExpenseBudgetTotals();
    }

    public Map<RateType, BudgetDecimal> getPreviousPersonnelCalculatedExpenseTotals() {
        return this.getPreviousBudget().getPersonnelCalculatedExpenseBudgetTotals();
    }

    public Set<RateType> getCombinedNonPersonnelCalculatedExpenseRates() {
        TreeSet<RateType> result = new TreeSet<RateType>();
        for (RateType type : this.getCurrentBudget().getNonPersonnelCalculatedExpenseTotals().keySet()) {
            if (type.getRateClass().getRateClassType() == null || StringUtils.equals((String)type.getRateClass().getRateClassType(), (String)"O")) continue;
            result.add(type);
        }
        for (RateType type : this.getPreviousBudget().getNonPersonnelCalculatedExpenseTotals().keySet()) {
            if (type.getRateClass().getRateClassType() == null || StringUtils.equals((String)type.getRateClass().getRateClassType(), (String)"O")) continue;
            result.add(type);
        }
        return result;
    }

    public Map<RateType, BudgetDecimal> getCurrentNonPersonnelCalculatedExpenseTotals() {
        return this.getCurrentBudget().getNonPersonnelCalculatedExpenseBudgetTotals();
    }

    public Map<RateType, BudgetDecimal> getPreviousNonPersonnelCalculatedExpenseTotals() {
        return this.getPreviousBudget().getNonPersonnelCalculatedExpenseBudgetTotals();
    }

    public BudgetDecimal getCurrentPersonnelTotal() {
        Map<String, BudgetDecimal> summaryTotals = this.getCurrentSummaryTotals();
        BudgetDecimal total = BudgetDecimal.ZERO;
        total = (BudgetDecimal)total.add(summaryTotals.get("personnelSalaryTotals"));
        total = (BudgetDecimal)total.add(summaryTotals.get("personnelFringeTotals"));
        total = (BudgetDecimal)total.add(summaryTotals.get("personnelCalculatedExpenseSummaryTotals"));
        return total;
    }

    public BudgetDecimal getPreviousPersonnelTotal() {
        Map<String, BudgetDecimal> summaryTotals = this.getPreviousSummaryTotals();
        BudgetDecimal total = BudgetDecimal.ZERO;
        total = (BudgetDecimal)total.add(summaryTotals.get("personnelSalaryTotals"));
        total = (BudgetDecimal)total.add(summaryTotals.get("personnelFringeTotals"));
        total = (BudgetDecimal)total.add(summaryTotals.get("personnelCalculatedExpenseSummaryTotals"));
        return total;
    }

    public AwardBudgetExt getCurrentBudget() {
        return this.currentBudget;
    }

    public void setCurrentBudget(AwardBudgetExt currentBudget) {
        this.currentBudget = currentBudget;
    }

    public AwardBudgetExt getPreviousBudget() {
        return this.previousBudget;
    }

    public void setPreviousBudget(AwardBudgetExt previousBudget) {
        this.previousBudget = previousBudget;
    }
}

