/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget.calculator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.calculator.AwardBudgetCalculationService;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.BudgetCalculationServiceImpl;
import org.kuali.kra.budget.core.BudgetCategoryType;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;

public class AwardBudgetCalculationServiceImpl
extends BudgetCalculationServiceImpl
implements AwardBudgetCalculationService {
    @Override
    public void calculateBudgetSummaryTotals(AwardBudgetExt budget, boolean includePrevious) {
        this.calculateBudgetSummaryTotals(budget);
        this.aggregatePeriodSummaryTotals(budget);
        if (includePrevious) {
            AwardBudgetExt prevBudget;
            BudgetVersionOverview prevBudgetOverview = budget.getPrevBudget();
            while (prevBudgetOverview != null && prevBudgetOverview.getBudgetId() != null && (prevBudget = (AwardBudgetExt)this.getBusinessObjectService().findBySinglePrimaryKey(AwardBudgetExt.class, (Object)prevBudgetOverview.getBudgetId())) != null) {
                this.calculateBudgetSummaryTotals(prevBudget);
                this.aggregatePeriodSummaryTotals(prevBudget);
                this.mergePrevSummary(budget, prevBudget);
                prevBudgetOverview = prevBudget.getPrevBudget();
            }
        }
    }

    protected void aggregatePeriodSummaryTotals(AwardBudgetExt budget) {
        budget.setObjectCodeBudgetTotals(this.getSumOfElements(budget.getObjectCodeTotals()));
        budget.setCalculatedExpenseBudgetTotals(this.getSumOfElements(budget.getCalculatedExpenseTotals()));
        budget.setTotalBudgetSummaryTotals(this.getSumOfElements(budget.getBudgetSummaryTotals()));
        budget.setObjectCodePersonnelFringeBudgetTotals(this.getSumOfElements(budget.getObjectCodePersonnelFringeTotals()));
        budget.setPersonnelCalculatedExpenseBudgetTotals(this.getSumOfElements(budget.getPersonnelCalculatedExpenseTotals()));
        budget.setNonPersonnelCalculatedExpenseBudgetTotals(this.getSumOfElements(budget.getNonPersonnelCalculatedExpenseTotals()));
    }

    protected void mergePrevSummary(AwardBudgetExt budget, AwardBudgetExt prevBudget) {
        for (Map.Entry<BudgetCategoryType, List<CostElement>> entry : prevBudget.getObjectCodeListByBudgetCategoryType().entrySet()) {
            List curElements = (List)budget.getObjectCodeListByBudgetCategoryType().get(entry.getKey());
            if (curElements == null) {
                budget.getObjectCodeListByBudgetCategoryType().put(entry.getKey(), new ArrayList(entry.getValue()));
                continue;
            }
            HashSet uniqueSet = new HashSet(curElements);
            uniqueSet.addAll(entry.getValue());
            budget.getObjectCodeListByBudgetCategoryType().put(entry.getKey(), new ArrayList(uniqueSet));
        }
        budget.setObjectCodeBudgetTotals(this.mergeMaps(budget.getObjectCodeBudgetTotals(), prevBudget.getObjectCodeBudgetTotals()));
        budget.setCalculatedExpenseBudgetTotals(this.mergeMaps(budget.getCalculatedExpenseBudgetTotals(), prevBudget.getCalculatedExpenseBudgetTotals()));
        budget.setTotalBudgetSummaryTotals(this.mergeMaps(budget.getTotalBudgetSummaryTotals(), prevBudget.getTotalBudgetSummaryTotals()));
        budget.setObjectCodePersonnelFringeBudgetTotals(this.mergeMaps(budget.getObjectCodePersonnelFringeBudgetTotals(), prevBudget.getObjectCodePersonnelFringeBudgetTotals()));
        budget.setPersonnelCalculatedExpenseBudgetTotals(this.mergeMaps(budget.getPersonnelCalculatedExpenseBudgetTotals(), prevBudget.getPersonnelCalculatedExpenseBudgetTotals()));
        budget.setNonPersonnelCalculatedExpenseBudgetTotals(this.mergeMaps(budget.getNonPersonnelCalculatedExpenseBudgetTotals(), prevBudget.getNonPersonnelCalculatedExpenseBudgetTotals()));
        budget.setTotalDirectCost((BudgetDecimal)budget.getTotalDirectCost().add(prevBudget.getTotalDirectCost()));
        budget.setTotalIndirectCost((BudgetDecimal)budget.getTotalIndirectCost().add(prevBudget.getTotalIndirectCost()));
        budget.setTotalCost((BudgetDecimal)budget.getTotalCost().add(prevBudget.getTotalCost()));
    }

    protected SortedMap<? extends Object, BudgetDecimal> mergeMaps(Map<? extends Object, BudgetDecimal> totals, Map<? extends Object, BudgetDecimal> previous) {
        TreeMap<Object, AbstractKualiDecimal> result = new TreeMap<Object, AbstractKualiDecimal>();
        for (Map.Entry<? extends Object, BudgetDecimal> entry : totals.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<? extends Object, BudgetDecimal> entry : previous.entrySet()) {
            Object key = entry.getKey();
            BudgetDecimal total = totals.get(key);
            if (total == null) continue;
            if (total == null) {
                result.put(key, entry.getValue());
                continue;
            }
            result.put(key, total.add(entry.getValue()));
        }
        return result;
    }

    protected SortedMap<? extends Object, BudgetDecimal> getSumOfElements(Map<? extends Object, List<BudgetDecimal>> map) {
        TreeMap<Object, BudgetDecimal> result = new TreeMap<Object, BudgetDecimal>();
        for (Map.Entry<? extends Object, List<BudgetDecimal>> entry : map.entrySet()) {
            BudgetDecimal total = BudgetDecimal.ZERO;
            for (BudgetDecimal amt : entry.getValue()) {
                total = (BudgetDecimal)total.add(amt);
            }
            Object key = entry.getKey();
            if (key instanceof String) {
                String strKey = (String)entry.getKey();
                key = strKey.replaceAll(",.*", "");
            }
            result.put(key, total);
        }
        return result;
    }
}

