/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget.document.authorizer;

import org.kuali.kra.authorization.Task;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.budget.document.authorization.AwardBudgetTask;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.budget.document.authorizer.BudgetAuthorizer;
import org.kuali.kra.infrastructure.AwardPermissionConstants;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.document.Document;

public class ToggleAwardBudgetStatusAuthorizer
extends BudgetAuthorizer {
    @Override
    public boolean isAuthorized(String userId, Task task) {
        AwardBudgetTask budgetTask = (AwardBudgetTask)task;
        AwardBudgetDocument budgetDocument = budgetTask.getAwardBudgetDocument();
        AwardDocument doc = (AwardDocument)budgetDocument.getParentDocument();
        WorkflowDocument workflowDoc = this.getWorkflowDocument((Document)budgetDocument);
        return workflowDoc.isFinal() && this.isToggleAwardBudgetStatusValid(budgetDocument) && this.hasUnitPermission(userId, doc.getLeadUnitNumber(), "KC-AB", AwardPermissionConstants.MAINTAIN_AWARD_BUDGET_ROUTING.getAwardPermission());
    }

    private boolean isToggleAwardBudgetStatusValid(AwardBudgetDocument budgetDocument) {
        String toBePostedStatusCode = this.getParameterService().getParameterValueAsString(AwardBudgetDocument.class, "awardBudgetStatusToBePosted");
        String doNotPostStatusCode = this.getParameterService().getParameterValueAsString(AwardBudgetDocument.class, "awardBudgetStatusDoNotPost");
        String budgetStatusCode = budgetDocument.getAwardBudget().getAwardBudgetStatusCode();
        return budgetStatusCode.equals(toBePostedStatusCode) || budgetStatusCode.equals(doNotPostStatusCode);
    }

    public ParameterService getParameterService() {
        return CoreFrameworkServiceLocator.getParameterService();
    }
}

