/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.commitments;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.commitments.AwardFandaRateService;
import org.kuali.kra.award.home.ValidRates;
import org.kuali.kra.service.FiscalYearMonthService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class AwardFandaRateServiceImpl
implements AwardFandaRateService {
    public static final int FOUR_DIGIT_YEAR_LENGTH = 4;
    public static final long MILLIS_IN_LEAP_YEAR = new Long("31536000000");
    public static final long MILLIS_IN_NON_LEAP_YEAR = new Long("31449600000");
    protected static final String F_AND_A_RATE_CLASS_TYPE_CODE = "O";
    protected BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private FiscalYearMonthService fiscalYearMonthService;

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public List<String> getStartAndEndDatesBasedOnFiscalYear(String fiscalYear) {
        ArrayList<String> listDates = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)fiscalYear) && fiscalYear.length() == 4) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
            Integer fy = Integer.parseInt(fiscalYear);
            listDates.add(dateFormat.format(new Date(this.getFiscalYearMonthService().getFiscalYearStartDate(fy).getTimeInMillis())));
            listDates.add(dateFormat.format(new Date(this.getFiscalYearMonthService().getFiscalYearEndDate(fy).getTimeInMillis())));
        }
        return listDates;
    }

    @Override
    public List<ValidRates> getValidRates(AwardFandaRate awardFandaRate) {
        if (ObjectUtils.isNull((Object)awardFandaRate)) {
            return new ArrayList<ValidRates>();
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        if (awardFandaRate.getOnCampusFlag().equalsIgnoreCase("N")) {
            criteria.put("onCampusRate", awardFandaRate.getApplicableFandaRate());
        } else {
            criteria.put("offCampusRate", awardFandaRate.getApplicableFandaRate());
        }
        criteria.put("rateClassType", F_AND_A_RATE_CLASS_TYPE_CODE);
        ArrayList<ValidRates> rates = new ArrayList<ValidRates>(this.businessObjectService.findMatching(ValidRates.class, criteria));
        return rates;
    }

    protected List<Date> getFiscalYearStartAndDates(int fiscalYear, String[] dateParts) {
        Calendar calendar = GregorianCalendar.getInstance();
        ArrayList<Date> dates = new ArrayList<Date>();
        calendar.set(fiscalYear - 1, Integer.valueOf(dateParts[0]) - 1, Integer.valueOf(dateParts[1]));
        dates.add(new Date(calendar.getTimeInMillis()));
        calendar.add(1, 1);
        calendar.add(6, -1);
        dates.add(new Date(calendar.getTimeInMillis()));
        return dates;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public FiscalYearMonthService getFiscalYearMonthService() {
        return this.fiscalYearMonthService;
    }

    public void setFiscalYearMonthService(FiscalYearMonthService fiscalYearMonthService) {
        this.fiscalYearMonthService = fiscalYearMonthService;
    }
}

