/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import org.kuali.kra.award.contacts.AwardContact;
import org.kuali.kra.award.contacts.AwardUnitContact;
import org.kuali.kra.award.contacts.BaseAwardContactAddRule;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardCentralAdminAddRuleImpl
extends BaseAwardContactAddRule {
    public static final String AWARD_CENTRAL_ADMIN_LIST_ERROR_KEY = "centralAdminContactsBean.newAwardContact";
    public static final String ERROR_AWARD_CENTRAL_ADMIN_EXISTS = "error.awardCentralAdmin.person.exists";

    public boolean processAddAwardCentralAdminContactBusinessRules(Award award, AwardUnitContact newUnitContact) {
        return this.checkForSelectedContactAndRole(newUnitContact) && this.checkForDuplicatePerson(award, newUnitContact);
    }

    boolean checkForSelectedContactAndRole(AwardContact newContact) {
        return super.checkForSelectedContactAndRole(newContact, AWARD_CENTRAL_ADMIN_LIST_ERROR_KEY);
    }

    boolean checkForDuplicatePerson(Award award, AwardUnitContact newUnitContact) {
        boolean valid = true;
        for (AwardUnitContact unitContact : award.getAwardUnitContacts()) {
            valid = !unitContact.getPersonId().equals(newUnitContact.getPersonId());
            if (valid) continue;
            this.registerError(newUnitContact);
            break;
        }
        return valid;
    }

    private void registerError(AwardUnitContact newUnitContact) {
        GlobalVariables.getMessageMap().putError(AWARD_CENTRAL_ADMIN_LIST_ERROR_KEY, ERROR_AWARD_CENTRAL_ADMIN_EXISTS, new String[]{newUnitContact.getContact().getFullName()});
    }
}

