/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.HashMap;
import java.util.Map;
import org.kuali.kra.award.AwardAssociate;
import org.kuali.kra.award.AwardTemplateSyncScope;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncableProperty;
import org.kuali.kra.award.home.AwardSyncable;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.bo.Contactable;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class AwardContact
extends AwardAssociate {
    private static final String ROLODEX_ID_FIELD_NAME = "rolodexId";
    private static final String PERSON_ID_FIELD_NAME = "personId";
    private static final long serialVersionUID = 4386300861743037298L;
    @AwardSyncableProperty(key=true)
    protected String personId;
    @AwardSyncableProperty(key=true)
    @AwardSyncable(scopes={AwardTemplateSyncScope.CONTAINING_CLASS_INHERIT})
    protected Integer rolodexId;
    @AwardSyncableProperty(key=true)
    @AwardSyncable(scopes={AwardTemplateSyncScope.CONTAINING_CLASS_INHERIT})
    protected String roleCode;
    private Long awardContactId;
    private ContactRole contactRole;
    @AwardSyncableProperty
    private String fullName;
    private KcPerson person;
    private NonOrganizationalRolodex rolodex;
    private transient KcPersonService kcPersonService;

    public AwardContact() {
    }

    AwardContact(NonOrganizationalRolodex rolodex, ContactRole contactRole) {
        this();
        this.setRolodex(rolodex);
        this.setContactRole(contactRole);
    }

    AwardContact(KcPerson person, ContactRole role) {
        this();
        this.setPerson(person);
        this.setContactRole(role);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AwardContact)) {
            return false;
        }
        AwardContact other = (AwardContact)obj;
        if (this.getContactRole() == null ? other.getContactRole() != null : !this.getContactRole().equals(other.getContactRole())) {
            return false;
        }
        if (this.getContact() == null) {
            if (other.getContact() != null) {
                return false;
            }
        } else if (this.getContact().getFullName() == null) {
            if (other.getContact().getFullName() != null) {
                return false;
            }
        } else {
            return this.getContact().getFullName().equalsIgnoreCase(other.getContact().getFullName());
        }
        return true;
    }

    public Long getAwardContactId() {
        return this.awardContactId;
    }

    public Contactable getContact() {
        Contactable contact = this.person != null ? this.person : (this.rolodex != null ? this.rolodex : null);
        if (contact == null) {
            if (this.personId != null) {
                this.refreshPerson();
                contact = this.person;
            } else if (this.rolodexId != null) {
                this.refreshRolodex();
                contact = this.rolodex;
            }
        }
        return contact;
    }

    public String getContactOrganizationName() {
        Contactable contact = this.getContact();
        return contact != null ? contact.getContactOrganizationName() : null;
    }

    public String getGenericId() {
        return this.rolodexId != null ? this.rolodexId.toString() : this.personId;
    }

    public String getOrganizationIdentifier() {
        return this.getContact() != null ? this.getContact().getOrganizationIdentifier() : null;
    }

    public ContactRole getContactRole() {
        return this.contactRole;
    }

    public String getContactRoleCode() {
        return this.roleCode;
    }

    public String getEmailAddress() {
        return this.getContact() != null ? this.getContact().getEmailAddress() : null;
    }

    public String getFullName() {
        return this.fullName;
    }

    public KcPerson getPerson() {
        if (this.person == null && this.personId != null) {
            this.refreshPerson();
        }
        return this.person;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPhoneNumber() {
        return this.getContact() != null ? this.getContact().getPhoneNumber() : null;
    }

    public String getRoleCode() {
        return this.roleCode;
    }

    public NonOrganizationalRolodex getRolodex() {
        if (this.rolodex == null && this.rolodexId != null) {
            this.refreshRolodex();
        }
        return this.rolodex;
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.getContactRole() == null ? 0 : this.getContactRole().hashCode());
        return 31 * result + (this.getContact() != null && this.getContact().getFullName() != null ? this.getContact().getFullName().hashCode() : 0);
    }

    public boolean isEmployee() {
        return this.getContact() != null && this.getContact() instanceof KcPerson;
    }

    @Override
    public void resetPersistenceState() {
        this.awardContactId = null;
    }

    public void setAwardContactId(Long awardContactid) {
        this.awardContactId = awardContactid;
    }

    public void setContactRole(ContactRole contactRole) {
        this.contactRole = contactRole;
        this.roleCode = contactRole != null ? contactRole.getRoleCode() : null;
    }

    public void setContactRoleCode(String roleCode) {
        this.roleCode = roleCode;
        this.refreshContactRole();
    }

    public void setEmailAddress(String emailAddress) {
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setPerson(KcPerson person) {
        if (person != null && person.getPersonId() == null) {
            person = null;
        }
        this.person = person;
        if (person != null) {
            this.rolodex = null;
            this.rolodexId = null;
            this.fullName = person.getFullName();
            this.personId = person.getPersonId();
        }
    }

    public void setPersonId(String personId) {
        this.personId = personId;
        this.refreshPerson();
    }

    public void setPhoneNumber(String phoneNumber) {
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
        this.refreshContactRole();
    }

    public void setRolodex(NonOrganizationalRolodex rolodex) {
        if (rolodex != null && rolodex.getRolodexId() == null) {
            rolodex = null;
        }
        this.rolodex = rolodex;
        if (rolodex != null) {
            this.person = null;
            this.personId = null;
            this.fullName = rolodex.getFullName();
            this.rolodexId = rolodex.getRolodexId();
        }
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
        this.refreshRolodex();
    }

    public void setUnitName(String unitName) {
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }

    @Override
    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    protected abstract Class<? extends ContactRole> getContactRoleType();

    protected abstract String getContactRoleTypeIdentifier();

    protected ContactRole refreshContactRole() {
        ContactRole role = this.roleCode != null ? (ContactRole)this.getBusinessObjectService().findByPrimaryKey(this.getContactRoleType(), this.getIdentifierMap(this.getContactRoleTypeIdentifier(), this.roleCode)) : null;
        this.setContactRole(role);
        return role;
    }

    protected Map<String, Object> getIdentifierMap(String identifierField, Object identifierValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(identifierField, identifierValue);
        return map;
    }

    protected void refreshPerson() {
        if (!(this.personId == null || this.person != null && this.personId.equals(this.person.getPersonId()))) {
            this.setPerson(this.getKcPersonService().getKcPersonByPersonId(this.personId));
        }
    }

    protected void refreshRolodex() {
        NonOrganizationalRolodex rolodex = this.rolodexId != null ? (NonOrganizationalRolodex)this.getBusinessObjectService().findByPrimaryKey(NonOrganizationalRolodex.class, this.getIdentifierMap(ROLODEX_ID_FIELD_NAME, this.rolodexId)) : null;
        this.setRolodex(rolodex);
    }
}

