/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncableProperty;
import org.kuali.kra.award.contacts.AwardContact;
import org.kuali.kra.award.contacts.AwardPersonCreditSplit;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.bo.AbstractProjectPerson;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.budget.personnel.PersonRolodex;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonRole;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.kra.service.Sponsorable;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AwardPerson
extends AwardContact
implements PersonRolodex,
Comparable<AwardPerson>,
AbstractProjectPerson {
    private static final long serialVersionUID = 7980027108784055721L;
    @AwardSyncableProperty
    private KualiDecimal academicYearEffort;
    @AwardSyncableProperty
    private KualiDecimal calendarYearEffort;
    @AwardSyncableProperty
    private boolean faculty;
    @AwardSyncableProperty
    private KualiDecimal summerEffort;
    @AwardSyncableProperty
    private KualiDecimal totalEffort;
    @AwardSyncableProperty
    private String keyPersonRole;
    @AwardSyncableProperty
    private boolean optInUnitStatus;
    @AwardSyncableProperty
    private List<AwardPersonUnit> units;
    private List<AwardPersonCreditSplit> creditSplits;
    @AwardSyncableProperty
    private boolean multiplePi;

    public AwardPerson() {
        this.init();
    }

    public AwardPerson(NonOrganizationalRolodex rolodex, ContactRole contactRole) {
        super(rolodex, contactRole);
        this.init();
    }

    public AwardPerson(KcPerson person, ContactRole role) {
        super(person, role);
        this.init();
    }

    public void add(AwardPersonCreditSplit creditSplit) {
        this.creditSplits.add(creditSplit);
        creditSplit.setAwardPerson(this);
    }

    public void add(AwardPersonUnit awardPersonUnit) {
        this.units.add(awardPersonUnit);
        awardPersonUnit.setAwardPerson(this);
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getUnits());
        return managedLists;
    }

    public Unit findLeadUnit() {
        return AwardPersonUnit.findLeadUnit(this.units);
    }

    public KualiDecimal getAcademicYearEffort() {
        return this.academicYearEffort;
    }

    public KualiDecimal getCalendarYearEffort() {
        return this.calendarYearEffort;
    }

    public AwardPersonCreditSplit getCreditSplit(int index) {
        return this.creditSplits.get(index);
    }

    public List<AwardPersonCreditSplit> getCreditSplits() {
        return this.creditSplits;
    }

    public KualiDecimal getSummerEffort() {
        return this.summerEffort;
    }

    public KualiDecimal getTotalEffort() {
        return this.totalEffort;
    }

    public AwardPersonUnit getUnit(int index) {
        return this.units.get(index);
    }

    public AwardPersonUnit getUnit(String unitNumber) {
        for (AwardPersonUnit awardPersonUnit : this.getUnits()) {
            if (!awardPersonUnit.getUnitNumber().equals(unitNumber)) continue;
            return awardPersonUnit;
        }
        return null;
    }

    public List<AwardPersonUnit> getUnits() {
        return this.units;
    }

    public boolean isCoInvestigator() {
        return this.getContactRole() != null && this.getContactRole().getRoleCode().equals("COI");
    }

    public boolean isFaculty() {
        return this.faculty;
    }

    public boolean isKeyPerson() {
        return this.getContactRole() != null && this.getContactRole().getRoleCode().equals("KP");
    }

    public boolean isPrincipalInvestigator() {
        return this.getContactRole() != null && this.getContactRole().getRoleCode().equals("PI");
    }

    public void setAcademicYearEffort(KualiDecimal academicYearEffort) {
        this.academicYearEffort = academicYearEffort;
    }

    public void setCalendarYearEffort(KualiDecimal calendarYearEffort) {
        this.calendarYearEffort = calendarYearEffort;
    }

    public void setCreditSplits(List<AwardPersonCreditSplit> creditSplits) {
        this.creditSplits = creditSplits;
    }

    public void setFaculty(boolean faculty) {
        this.faculty = faculty;
    }

    public void setSummerEffort(KualiDecimal summerEffort) {
        this.summerEffort = summerEffort;
    }

    public void setTotalEffort(KualiDecimal totalEffort) {
        this.totalEffort = totalEffort;
    }

    public void setUnits(List<AwardPersonUnit> units) {
        this.units = units;
    }

    public String toString() {
        return String.format("%s:%s", this.getContact().getIdentifier().toString(), this.getContact().getFullName());
    }

    protected Class getContactRoleType() {
        return ProposalPersonRole.class;
    }

    @Override
    protected String getContactRoleTypeIdentifier() {
        return "proposalPersonRoleId";
    }

    protected void init() {
        this.units = new ArrayList<AwardPersonUnit>();
        this.creditSplits = new ArrayList<AwardPersonCreditSplit>();
        this.optInUnitStatus = false;
    }

    @Override
    public String getProjectRole() {
        return this.getContactRole().getRoleDescription();
    }

    @Override
    public boolean isOtherSignificantContributorFlag() {
        return false;
    }

    public String getKeyPersonRole() {
        return this.keyPersonRole;
    }

    public void setKeyPersonRole(String keyPersonRole) {
        this.keyPersonRole = keyPersonRole;
    }

    @Override
    public int compareTo(AwardPerson o) {
        int lastNameComp = ObjectUtils.compare((Comparable)((Object)this.getLastName()), (Comparable)((Object)o.getLastName()));
        if (lastNameComp != 0) {
            return lastNameComp;
        }
        return ObjectUtils.compare((Comparable)((Object)this.getFirstName()), (Comparable)((Object)o.getFirstName()));
    }

    @Override
    public boolean isMultiplePi() {
        return this.multiplePi;
    }

    public void setMultiplePi(boolean multiplePi) {
        this.multiplePi = multiplePi;
    }

    @Override
    public Sponsorable getParent() {
        return this.getAward();
    }

    @Override
    public String getInvestigatorRoleDescription() {
        return KraServiceLocator.getService(KeyPersonnelService.class).getPersonnelRoleDesc(this);
    }

    public boolean isOptInUnitStatus() {
        return this.optInUnitStatus;
    }

    public void setOptInUnitStatus(boolean optInUnitStatus) {
        this.optInUnitStatus = optInUnitStatus;
    }

    public String getLastName() {
        String lastName = null;
        if (this.getPerson() != null) {
            lastName = this.getPerson().getLastName();
        } else if (this.getRolodex() != null) {
            lastName = this.getRolodex().getLastName();
        }
        return lastName;
    }

    public String getFirstName() {
        String firstName = null;
        if (this.getPerson() != null) {
            firstName = this.getPerson().getFirstName();
        } else if (this.getRolodex() != null) {
            firstName = this.getRolodex().getFirstName();
        }
        return firstName;
    }

    public boolean getIsRolodexPerson() {
        return this.getRolodex() != null;
    }
}

