/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.HashMap;
import org.kuali.kra.SequenceAssociate;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.CreditSplit;
import org.kuali.kra.proposaldevelopment.bo.InvestigatorCreditType;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.service.BusinessObjectService;

public final class AwardPersonCreditSplit
extends KraPersistableBusinessObjectBase
implements CreditSplit,
SequenceAssociate<Award> {
    private static final String INV_CREDIT_TYPE_CODE_FIELD_NAME = "invCreditTypeCode";
    private static final long serialVersionUID = -6999442247404810830L;
    private Long awardPersonCreditSplitId;
    @SkipVersioning
    private AwardPerson awardPerson;
    private KualiDecimal credit;
    private InvestigatorCreditType investigatorCreditType;
    private String invCreditTypeCode;
    private Long awardContactId;

    public AwardPersonCreditSplit() {
    }

    AwardPersonCreditSplit(InvestigatorCreditType investigatorCreditType, KualiDecimal credit) {
        this.setInvestigatorCreditType(investigatorCreditType);
        this.setCredit(credit);
    }

    public Long getAwardContactId() {
        return this.awardContactId;
    }

    public AwardPerson getAwardPerson() {
        return this.awardPerson;
    }

    public Long getAwardPersonCreditSplitId() {
        return this.awardPersonCreditSplitId;
    }

    @Override
    public KualiDecimal getCredit() {
        return this.credit != null ? this.credit : new KualiDecimal(0);
    }

    @Override
    public String getInvCreditTypeCode() {
        this.refreshInvestigatorCreditTypeIfNeeded();
        return this.invCreditTypeCode;
    }

    public InvestigatorCreditType getInvestigatorCreditType() {
        this.refreshInvestigatorCreditTypeIfNeeded();
        return this.investigatorCreditType;
    }

    public void setAwardContactId(Long awardContactId) {
        this.awardContactId = awardContactId;
    }

    public void setAwardPerson(AwardPerson awardPerson) {
        this.awardPerson = awardPerson;
        this.awardContactId = awardPerson != null ? awardPerson.getAwardContactId() : null;
    }

    public void setAwardPersonCreditSplitId(Long awardPersonCreditSplitId) {
        this.awardPersonCreditSplitId = awardPersonCreditSplitId;
    }

    public void setCredit(KualiDecimal argCredit) {
        this.credit = argCredit;
    }

    @Override
    public void setInvCreditTypeCode(String argInvCreditTypeCode) {
        this.invCreditTypeCode = argInvCreditTypeCode;
    }

    public void setInvestigatorCreditType(InvestigatorCreditType investigatorCreditType) {
        this.investigatorCreditType = investigatorCreditType;
        this.invCreditTypeCode = investigatorCreditType != null ? investigatorCreditType.getInvCreditTypeCode() : null;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }

    private void refreshInvestigatorCreditTypeIfNeeded() {
        if (!(this.invCreditTypeCode == null || this.investigatorCreditType != null && this.invCreditTypeCode.equals(this.investigatorCreditType.getInvCreditTypeCode()))) {
            HashMap<String, String> keyMap = new HashMap<String, String>();
            keyMap.put(INV_CREDIT_TYPE_CODE_FIELD_NAME, this.invCreditTypeCode);
            this.investigatorCreditType = (InvestigatorCreditType)this.getBusinessObjectService().findByPrimaryKey(InvestigatorCreditType.class, keyMap);
        }
    }

    @Override
    public Award getSequenceOwner() {
        return this.awardPerson != null ? this.awardPerson.getAward() : null;
    }

    @Override
    public void setSequenceOwner(Award newlyVersionedOwner) {
        if (this.awardPerson != null) {
            this.awardPerson.setAward(newlyVersionedOwner);
        }
    }

    @Override
    public Integer getSequenceNumber() {
        return this.awardPerson != null ? this.awardPerson.getSequenceNumber() : 0;
    }

    @Override
    public void resetPersistenceState() {
        this.awardPersonCreditSplitId = null;
    }
}

