/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.Collection;
import java.util.HashMap;
import org.kuali.kra.award.contacts.AwardPersonCreditSplitRule;
import org.kuali.kra.award.contacts.AwardPersonCreditSplitRuleEvent;
import org.kuali.kra.proposaldevelopment.bo.InvestigatorCreditType;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AwardPersonCreditSplitRuleImpl
extends ResearchDocumentRuleBase
implements AwardPersonCreditSplitRule {
    private static final KualiDecimal MAX_TOTAL_VALUE = new KualiDecimal(100.0);

    @Override
    public boolean checkAwardPersonCreditSplitTotals(AwardPersonCreditSplitRuleEvent event) {
        int errorCount = 0;
        for (InvestigatorCreditType creditType : this.loadInvestigatorCreditTypes()) {
            if (!creditType.addsToHundred().booleanValue()) continue;
            KualiDecimal value = event.getTotalsByCreditSplitType().get(creditType.getInvCreditTypeCode());
            if (value == null) break;
            if (((KualiDecimal)MAX_TOTAL_VALUE.subtract((AbstractKualiDecimal)value)).isZero()) continue;
            this.reportError("document.awardList[0].projectPersons.awardPersonCreditSplits", "error.award.person.credit.split.error", creditType.getDescription());
            ++errorCount;
        }
        return errorCount == 0;
    }

    Collection<InvestigatorCreditType> loadInvestigatorCreditTypes() {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("active", "true");
        return this.getBusinessObjectService().findMatching(InvestigatorCreditType.class, valueMap);
    }
}

