/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.SequenceAssociate;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncableProperty;
import org.kuali.kra.award.contacts.AwardContact;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnitCreditSplit;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.bo.UnitAdministrator;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.ServiceHelper;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardPersonUnit
extends KraPersistableBusinessObjectBase
implements Comparable<AwardPersonUnit>,
SequenceAssociate<Award> {
    public static final boolean IS_LEAD_UNIT = Boolean.TRUE;
    public static final boolean IS_NOT_LEAD_UNIT = Boolean.FALSE;
    private static final long serialVersionUID = 3550317176047537585L;
    private Long awardPersonUnitId;
    @SkipVersioning
    @AwardSyncableProperty(parent=true, parentProperty="units")
    private AwardPerson awardPerson;
    @AwardSyncableProperty
    private boolean leadUnit;
    private Unit unit;
    private List<AwardPersonUnitCreditSplit> creditSplits = new ArrayList<AwardPersonUnitCreditSplit>();
    @AwardSyncableProperty(key=true)
    private String unitNumber;
    private Long awardContactId;

    public AwardPersonUnit() {
    }

    AwardPersonUnit(AwardPerson awardPerson) {
        this();
        this.setAwardPerson(awardPerson);
    }

    AwardPersonUnit(AwardPerson awardPerson, Unit unit, boolean isLeadUnit) {
        this();
        this.setAwardPerson(awardPerson);
        this.setUnit(unit);
        this.leadUnit = isLeadUnit;
    }

    public static Unit findLeadUnit(Collection<AwardPersonUnit> awardPersonUnits) {
        Unit foundLeadUnit = null;
        for (AwardPersonUnit apu : awardPersonUnits) {
            if (!apu.isLeadUnit()) continue;
            foundLeadUnit = apu.getUnit();
        }
        return foundLeadUnit;
    }

    public void add(AwardPersonUnitCreditSplit creditSplit) {
        this.creditSplits.add(creditSplit);
        creditSplit.setAwardPersonUnit(this);
    }

    @Override
    public int compareTo(AwardPersonUnit other) {
        return this.unit.getUnitName().compareToIgnoreCase(other.getUnit().getUnitName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwardPersonUnit)) {
            return false;
        }
        AwardPersonUnit other = (AwardPersonUnit)obj;
        if (this.awardPerson == null ? other.awardPerson != null : !this.awardPerson.equals(other.awardPerson)) {
            return false;
        }
        return !(this.unit == null ? other.unit != null : !this.unit.equals((Object)other.unit));
    }

    public Long getAwardContactId() {
        return this.awardContactId;
    }

    public List<UnitAdministrator> getOspAdministrators() {
        ArrayList<UnitAdministrator> ospAdministrators = new ArrayList<UnitAdministrator>();
        if (this.unit != null) {
            for (UnitAdministrator unitAdministrator : this.unit.getUnitAdministrators()) {
                if (!unitAdministrator.getUnitAdministratorType().getDescription().equals("OSP_ADMINISTRATOR")) continue;
                ospAdministrators.add(unitAdministrator);
            }
        }
        return ospAdministrators;
    }

    public AwardContact getAwardPerson() {
        return this.awardPerson;
    }

    public Long getAwardPersonUnitId() {
        return this.awardPersonUnitId;
    }

    public AwardPersonUnitCreditSplit getCreditSplit(int index) {
        return this.creditSplits.get(index);
    }

    public List<AwardPersonUnitCreditSplit> getCreditSplits() {
        return this.creditSplits;
    }

    public String getFullName() {
        return this.awardPerson != null ? (this.awardPerson.getContact() != null ? this.awardPerson.getContact().getFullName() : null) : null;
    }

    public Unit getUnit() {
        this.lazilyLoadUnit();
        return this.unit;
    }

    public String getUnitName() {
        return this.unit != null ? this.unit.getUnitName() : null;
    }

    public String getUnitNumber() {
        return this.unitNumber;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.awardPerson == null ? 0 : this.awardPerson.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public boolean isLeadUnit() {
        return this.leadUnit;
    }

    public void setAwardContactId(Long awardPersonId) {
        this.awardContactId = awardPersonId;
    }

    public void setAwardPerson(AwardPerson awardPerson) {
        this.awardPerson = awardPerson;
        this.awardContactId = awardPerson != null ? awardPerson.getAwardContactId() : null;
    }

    public void setAwardPersonUnitId(Long awardPersonUnitId) {
        this.awardPersonUnitId = awardPersonUnitId;
    }

    public void setCreditSplits(List<AwardPersonUnitCreditSplit> creditSplits) {
        this.creditSplits = creditSplits;
    }

    public void setLeadUnit(boolean leadUnit) {
        this.leadUnit = leadUnit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
        this.unitNumber = unit != null ? unit.getUnitNumber() : null;
    }

    public void setUnitNumber(String unitNumber) {
        this.unitNumber = unitNumber;
        HashMap<String, String> pk = new HashMap<String, String>();
        pk.put("unitNumber", unitNumber);
        Unit unit = (Unit)KraServiceLocator.getService(BusinessObjectService.class).findByPrimaryKey(Unit.class, pk);
        if (unit != null) {
            this.unit = unit;
        } else {
            this.unit = null;
            this.unitNumber = null;
        }
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }

    private void lazilyLoadUnit() {
        Collection c;
        if (StringUtils.isNotEmpty((String)this.unitNumber) && this.unit == null && (c = this.getBusinessObjectService().findMatching(Unit.class, ServiceHelper.getInstance().buildCriteriaMap("unitNumber", this.unitNumber))).size() > 0) {
            this.unit = (Unit)((Object)c.iterator().next());
        }
    }

    @Override
    public Award getSequenceOwner() {
        return this.awardPerson != null ? this.awardPerson.getAward() : null;
    }

    @Override
    public void setSequenceOwner(Award newlyVersionedOwner) {
        if (this.awardPerson != null) {
            this.awardPerson.setAward(newlyVersionedOwner);
        }
    }

    @Override
    public Integer getSequenceNumber() {
        return this.awardPerson != null ? this.awardPerson.getSequenceNumber() : 0;
    }

    @Override
    public void resetPersistenceState() {
        this.awardPersonUnitId = null;
    }
}

