/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.Collection;
import java.util.HashMap;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnitCreditSplitRule;
import org.kuali.kra.award.contacts.AwardPersonUnitCreditSplitRuleEvent;
import org.kuali.kra.proposaldevelopment.bo.InvestigatorCreditType;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AwardPersonUnitCreditSplitRuleImpl
extends ResearchDocumentRuleBase
implements AwardPersonUnitCreditSplitRule {
    private static final KualiDecimal MAX_TOTAL_VALUE = new KualiDecimal(100.0);

    @Override
    public boolean checkAwardPersonUnitCreditSplitTotals(AwardPersonUnitCreditSplitRuleEvent event) {
        int errorCount = 0;
        AwardPerson person = event.getProjectPerson();
        for (InvestigatorCreditType creditType : this.loadInvestigatorCreditTypes()) {
            if (!creditType.addsToHundred().booleanValue()) continue;
            KualiDecimal value = event.getTotalsByCreditSplitType().get(creditType.getInvCreditTypeCode());
            if (value == null) break;
            if (((KualiDecimal)MAX_TOTAL_VALUE.subtract((AbstractKualiDecimal)value)).isZero()) continue;
            this.reportError("document.awardList[0].projectPersons.awardPersonUnitCreditSplits", "error.award.person.unit.credit.split.error", creditType.getDescription(), person.getFullName());
            ++errorCount;
        }
        return errorCount == 0;
    }

    Collection<InvestigatorCreditType> loadInvestigatorCreditTypes() {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("active", "true");
        return this.getBusinessObjectService().findMatching(InvestigatorCreditType.class, valueMap);
    }
}

