/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class AwardProjectPersonsAuditRule
implements DocumentAuditRule {
    private static final String CONTACTS_AUDIT_ERRORS = "contactsAuditErrors";
    private static final String CONTACTS_AUDIT_WARNINGS = "contactsAuditWarnings";
    private static final String AWARD_UNCERTIFIED_PARAM = "awardUncertifiedKeyPersonnel";
    private List<AuditError> auditErrors = new ArrayList<AuditError>();
    private List<AuditError> auditWarnings = new ArrayList<AuditError>();
    public static final String AWARD_PROJECT_PERSON_LIST_ERROR_KEY = "document.awardList[0].projectPerson.auditErrors";
    public static final String ERROR_AWARD_PROJECT_PERSON_NO_PI = "error.awardProjectPerson.no.pi.exists";
    public static final String ERROR_AWARD_PROJECT_PERSON_MULTIPLE_PI_EXISTS = "error.awardProjectPerson.pi.exists";
    public static final String ERROR_AWARD_PROJECT_PERSON_UNIT_DETAILS_REQUIRED = "error.awardProjectPerson.unit.details.required";
    public static final String ERROR_AWARD_PROJECT_PERSON_LEAD_UNIT_REQUIRED = "error.awardProjectPerson.lead.unit.required";
    public static final String ERROR_AWARD_PROJECT_PERSON_UNCERTIFIED = "error.awardProjectPerson.uncertified";
    private ParameterService parameterService;
    private AwardService awardService;
    private InstitutionalProposalService institutionalProposalService;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        AwardDocument awardDocument = (AwardDocument)document;
        this.auditErrors = new ArrayList<AuditError>();
        this.auditWarnings = new ArrayList<AuditError>();
        valid &= this.checkPrincipalInvestigators(awardDocument.getAward().getProjectPersons());
        valid &= this.checkUnits(awardDocument.getAward().getProjectPersons());
        valid &= this.checkLeadUnits(awardDocument.getAward().getProjectPersons());
        this.reportAndCreateAuditCluster();
        return valid &= this.checkCertifiedInvestigators(awardDocument.getAward());
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put(CONTACTS_AUDIT_ERRORS, new AuditCluster("Contacts", this.auditErrors, "Validation Errors"));
        }
        if (this.auditWarnings.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put(CONTACTS_AUDIT_WARNINGS, new AuditCluster("Contacts", this.auditWarnings, "Warnings"));
        }
    }

    protected boolean checkPrincipalInvestigators(List<AwardPerson> awardPersons) {
        boolean valid = true;
        List<AwardPerson> principalInvestigators = this.getPrincipalInvestigators(awardPersons);
        int piCount = principalInvestigators.size();
        if (piCount == 0) {
            valid = false;
            this.auditErrors.add(new AuditError(AWARD_PROJECT_PERSON_LIST_ERROR_KEY, ERROR_AWARD_PROJECT_PERSON_NO_PI, "contacts.Contacts"));
        } else if (piCount > 1) {
            valid = false;
            this.auditErrors.add(new AuditError(AWARD_PROJECT_PERSON_LIST_ERROR_KEY, ERROR_AWARD_PROJECT_PERSON_MULTIPLE_PI_EXISTS, "contacts.Contacts"));
        }
        return valid;
    }

    protected boolean checkUnits(List<AwardPerson> awardPersons) {
        boolean valid = true;
        for (AwardPerson person : awardPersons) {
            if (!person.isPrincipalInvestigator() && !person.isCoInvestigator() || person.getUnits() == null || person.getUnits().size() != 0) continue;
            valid = false;
            this.auditErrors.add(new AuditError(AWARD_PROJECT_PERSON_LIST_ERROR_KEY, ERROR_AWARD_PROJECT_PERSON_UNIT_DETAILS_REQUIRED, "contacts.Contacts", new String[]{person.getFullName()}));
        }
        return valid;
    }

    protected boolean checkLeadUnits(List<AwardPerson> awardPersons) {
        boolean valid = true;
        List<AwardPerson> principalInvestigators = this.getPrincipalInvestigators(awardPersons);
        if (principalInvestigators != null && principalInvestigators.size() == 1) {
            List<AwardPersonUnit> piUnits = principalInvestigators.get(0).getUnits();
            int leadUnits = 0;
            for (AwardPersonUnit unit : piUnits) {
                if (!unit.isLeadUnit()) continue;
                ++leadUnits;
            }
            if (leadUnits != 1) {
                valid = false;
                this.auditErrors.add(new AuditError(AWARD_PROJECT_PERSON_LIST_ERROR_KEY, ERROR_AWARD_PROJECT_PERSON_LEAD_UNIT_REQUIRED, "contacts.Contacts"));
            }
        }
        return valid;
    }

    protected List<AwardPerson> getPrincipalInvestigators(List<AwardPerson> projectPersons) {
        ArrayList<AwardPerson> principalInvestigators = new ArrayList<AwardPerson>();
        for (AwardPerson p : projectPersons) {
            if (!p.isPrincipalInvestigator()) continue;
            principalInvestigators.add(p);
        }
        return principalInvestigators;
    }

    protected List<AwardPersonUnit> getPIUnits(List<AwardPerson> projectPersons) {
        ArrayList<AwardPersonUnit> units = new ArrayList<AwardPersonUnit>();
        for (AwardPerson p : projectPersons) {
            if (!p.isPrincipalInvestigator()) continue;
            for (AwardPersonUnit apu : p.getUnits()) {
                units.add(apu);
            }
        }
        return units;
    }

    protected boolean checkCertifiedInvestigators(Award award) {
        boolean retval = true;
        String parmVal = this.getParameterService().getParameterValueAsString(AwardDocument.class, AWARD_UNCERTIFIED_PARAM);
        if (StringUtils.equals((String)parmVal, (String)"0")) {
            return retval;
        }
        boolean error = StringUtils.equals((String)parmVal, (String)"2");
        ArrayList<DevelopmentProposal> devProposals = new ArrayList<DevelopmentProposal>();
        List<Award> awards = this.getAwardService().findAwardsForAwardNumber(award.getAwardNumber());
        for (Award curAward : awards) {
            List<AwardFundingProposal> fundingProposals = curAward.getFundingProposals();
            for (AwardFundingProposal fundingProposal : fundingProposals) {
                devProposals.addAll(this.getInstitutionalProposalService().getAllLinkedDevelopmentProposals(fundingProposal.getProposal().getProposalNumber()));
            }
        }
        for (AwardPerson person : award.getProjectPersons()) {
            boolean personFoundCheck = false;
            block3: for (DevelopmentProposal proposal : devProposals) {
                for (ProposalPerson propPerson : proposal.getProposalPersons()) {
                    if ((person == null || !StringUtils.equals((String)person.getPersonId(), (String)propPerson.getPersonId())) && (person.getRolodexId() == null || !ObjectUtils.equals((Object)person.getRolodexId(), (Object)propPerson.getRolodexId())) || !StringUtils.equals((String)propPerson.getProposalPersonRoleId(), (String)"COI") && !StringUtils.equals((String)propPerson.getProposalPersonRoleId(), (String)"PI") && !StringUtils.equals((String)propPerson.getOptInCertificationStatus(), (String)"Y")) continue;
                    personFoundCheck = true;
                    continue block3;
                }
            }
            if (personFoundCheck) continue;
            retval = false;
            if (error && !person.isKeyPerson()) {
                this.auditErrors.add(new AuditError(AWARD_PROJECT_PERSON_LIST_ERROR_KEY, ERROR_AWARD_PROJECT_PERSON_UNCERTIFIED, "contacts.Contacts", new String[]{person.getFullName()}));
                continue;
            }
            this.auditWarnings.add(new AuditError(AWARD_PROJECT_PERSON_LIST_ERROR_KEY, ERROR_AWARD_PROJECT_PERSON_UNCERTIFIED, "contacts.Contacts", new String[]{person.getFullName()}));
        }
        return retval;
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = KraServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        if (this.institutionalProposalService == null) {
            this.institutionalProposalService = KraServiceLocator.getService(InstitutionalProposalService.class);
        }
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }
}

