/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.contacts.AwardProjectPersonsSaveRule;
import org.kuali.kra.award.contacts.SaveAwardProjectPersonsRuleEvent;
import org.kuali.kra.bo.Unit;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardProjectPersonsSaveRuleImpl
implements AwardProjectPersonsSaveRule {
    public static final String ERROR_UNIT_REQUIRED = "error.select.unit";

    @Override
    public boolean processSaveAwardProjectPersonsBusinessRules(SaveAwardProjectPersonsRuleEvent event) {
        return this.processSaveAwardProjectPersonsBusinessRules(event.getProjectPersons());
    }

    boolean processSaveAwardProjectPersonsBusinessRules(List<AwardPerson> projectPersons) {
        if (projectPersons.size() == 0) {
            return true;
        }
        boolean valid = this.checkForDuplicateUnits(projectPersons);
        valid &= this.checkForKeyPersonProjectRoles(projectPersons);
        valid &= this.checkForOnePrincipalInvestigator(projectPersons);
        valid &= this.checkForRequiredUnitDetails(projectPersons);
        return valid &= this.checkForLeadUnitForPI(projectPersons);
    }

    boolean checkForKeyPersonProjectRoles(List<AwardPerson> projectPersons) {
        boolean valid = true;
        for (AwardPerson person : projectPersons) {
            if (!StringUtils.equalsIgnoreCase((String)person.getContactRole().getRoleCode(), (String)"KP") || !StringUtils.isBlank((String)person.getKeyPersonRole())) continue;
            valid = false;
            GlobalVariables.getMessageMap().putError("projectPersons", "error.awardProjectPerson.keyperson.role.required", new String[]{person.getFullName()});
        }
        return valid;
    }

    boolean checkForRequiredUnitDetails(List<AwardPerson> projectPersons) {
        boolean valid = true;
        int personCount = 0;
        for (AwardPerson p : projectPersons) {
            if (!p.isPrincipalInvestigator() && !p.isCoInvestigator() && (!p.isKeyPerson() || !p.isOptInUnitStatus())) continue;
            ++personCount;
            if (p.getUnits().size() != 0) continue;
            --personCount;
            valid = false;
            if (p.getFullName() != null) {
                GlobalVariables.getMessageMap().putError("projectPersons", "error.awardProjectPerson.unit.details.required", new String[]{p.getFullName()});
            } else if (p.isEmployee()) {
                GlobalVariables.getMessageMap().putError("projectPersons", "error.awardProjectPerson.unit.details.required", new String[]{p.getPerson().getUnit().getUnitName()});
            } else {
                GlobalVariables.getMessageMap().putError("projectPersons", "error.awardProjectPerson.unit.details.required", new String[]{p.getRolodex().getOrganization()});
            }
            GlobalVariables.getMessageMap().putError("projectPersons[" + personCount + "].personUnitNumber", ERROR_UNIT_REQUIRED, new String[0]);
        }
        return valid;
    }

    boolean checkForDuplicateUnits(List<AwardPerson> projectPersons) {
        boolean valid = true;
        for (AwardPerson p : projectPersons) {
            HashSet<Unit> uniqueUnits = new HashSet<Unit>();
            ArrayList<Unit> tempUnits = new ArrayList<Unit>();
            for (AwardPersonUnit apu : p.getUnits()) {
                uniqueUnits.add(apu.getUnit());
                tempUnits.add(apu.getUnit());
            }
            if (valid &= tempUnits.size() == uniqueUnits.size()) continue;
            for (Unit u : uniqueUnits) {
                tempUnits.remove((Object)u);
            }
            HashSet duplicateUnits = new HashSet(tempUnits);
            for (Unit dupeUnit : duplicateUnits) {
                GlobalVariables.getMessageMap().putError("projectPersons", "error.awardProjectPerson.duplicate.units", new String[]{dupeUnit.getUnitName(), dupeUnit.getUnitNumber(), p.getFullName()});
            }
        }
        return valid;
    }

    boolean checkForOnePrincipalInvestigator(List<AwardPerson> projectPersons) {
        boolean result;
        int count = 0;
        for (AwardPerson p : projectPersons) {
            if (!p.isPrincipalInvestigator()) continue;
            ++count;
        }
        boolean bl = result = count == 1;
        if (!result) {
            if (count == 0) {
                GlobalVariables.getMessageMap().putError("projectPersons", "error.awardProjectPerson.no.pi.exists", new String[0]);
            } else {
                GlobalVariables.getMessageMap().putError("projectPersons", "error.awardProjectPerson.pi.exists", new String[0]);
            }
        }
        return result;
    }

    boolean checkForLeadUnitForPI(List<AwardPerson> projectPersons) {
        boolean valid = true;
        for (AwardPerson p : projectPersons) {
            AwardPersonUnit apu;
            if (!p.isPrincipalInvestigator()) continue;
            boolean found = false;
            Iterator<AwardPersonUnit> i$ = p.getUnits().iterator();
            while (i$.hasNext() && !(found = (apu = i$.next()).isLeadUnit())) {
            }
            valid = found;
            if (valid) continue;
            GlobalVariables.getMessageMap().putError("projectPersons", "error.awardProjectPerson.lead.unit.required", new String[0]);
        }
        return valid;
    }
}

