/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.award.home.ContactType;
import org.kuali.kra.bo.UnitAdministratorType;
import org.kuali.kra.bo.UnitContactType;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonRole;

public final class ContactRoleFixtureFactory {
    public static final ContactRole MOCK_PI = ContactRoleFixtureFactory.getProposalPersonRole("PI", "Principal Investigator");
    public static final ContactRole MOCK_COI = ContactRoleFixtureFactory.getProposalPersonRole("COI", "Co-Investigator");
    public static final ContactRole MOCK_KEY_PERSON = ContactRoleFixtureFactory.getProposalPersonRole("KP", "Key Person");
    static final ContactRole MOCK_ACCOUNTANT = ContactRoleFixtureFactory.getUnitAdministratorType("11", "Accountant", UnitContactType.CONTACT);
    static final ContactRole MOCK_ADMIN_ASSISTANT = ContactRoleFixtureFactory.getUnitAdministratorType("12", "Admin Assistant", UnitContactType.CONTACT);
    static final ContactRole MOCK_BUSINESS_MANAGER = ContactRoleFixtureFactory.getUnitAdministratorType("13", "Business Manager", UnitContactType.CONTACT);
    static final ContactRole MOCK_SENIOR_ACCOUNTANT = ContactRoleFixtureFactory.getContactType("16", "Senior Accountant");
    static final ContactRole MOCK_ADMINISTRATIVE_CONTACT1 = ContactRoleFixtureFactory.getContactType("17", "Administrative Contact - 1");
    static final ContactRole MOCK_ADMINISTRATIVE_CONTACT2 = ContactRoleFixtureFactory.getContactType("18", "Administrative Contact - 2");
    static final ContactRole MOCK_AWARD_OFFICE_CONTACT1 = ContactRoleFixtureFactory.getContactType("19", "Award Office Contact - 1");
    static final ContactRole MOCK_AWARD_OFFICE_CONTACT2 = ContactRoleFixtureFactory.getContactType("20", "Award Office Contact - 2");
    static final ContactRole MOCK_CLOSEOUT_CONTACT = ContactRoleFixtureFactory.getContactType("21", "Closeout Contact");
    static final ContactRole MOCK_AUDITOR = ContactRoleFixtureFactory.getUnitAdministratorType("14", "Auditor", UnitContactType.ADMINISTRATOR);
    static final ContactRole MOCK_FUND_ACCOUNTANT = ContactRoleFixtureFactory.getUnitAdministratorType("15", "Fund Accountant", UnitContactType.ADMINISTRATOR);

    private ContactRoleFixtureFactory() {
    }

    private static ContactRole getProposalPersonRole(String code, String description) {
        ProposalPersonRole role = new ProposalPersonRole();
        role.setProposalPersonRoleId(code);
        role.setDescription(description);
        return role;
    }

    private static ContactRole getUnitAdministratorType(String code, String description, UnitContactType unitContactType) {
        UnitAdministratorType type = new UnitAdministratorType();
        type.setUnitAdministratorTypeCode(code);
        type.setDescription(description);
        type.setUnitContactType(unitContactType);
        return type;
    }

    private static ContactRole getContactType(String code, String description) {
        ContactType role = new ContactType();
        role.setContactTypeCode(code);
        role.setDescription(description);
        return role;
    }
}

