/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.detailsdates;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.detailsdates.AddAwardTransferringSponsorEvent;
import org.kuali.kra.award.detailsdates.AwardDetailsAndDatesRule;
import org.kuali.kra.award.detailsdates.AwardDetailsAndDatesSaveEvent;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardTransferringSponsor;
import org.kuali.kra.award.home.CFDA;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.external.award.AccountCreationClient;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.ObjectUtils;

public class AwardDetailsAndDatesRuleImpl
extends ResearchDocumentRuleBase
implements AwardDetailsAndDatesRule {
    private static final String SPONSOR_CODE_PROPERTY_NAME = "detailsAndDatesFormHelper.newAwardTransferringSponsor.sponsorCode";
    private static final String ANTICIPATED_AMOUNT_PROPERTY_NAME = "awardAmountInfos[0].anticipatedTotalAmount";
    private static final String OBLIGATED_AMOUNT_PROPERTY_NAME = "awardAmountInfos[0].amountObligatedToDate";
    private static final String AWARD_EFFECTIVE_DATE_PROPERTY_NAME = "awardAmountInfos[0].currentFundEffectiveDate";
    private static final String OBLIGATION_EXPIRATION_DATE_PROPERTY_NAME = "awardAmountInfos[0].obligationExpirationDate";
    private static final String AWARD_ACCOUNT_NUMBER_PROPERTY_NAME = "accountNumber";
    private static final String AWARD_FIN_CHART_OF_ACCOUNTS_CODE_PROPERTY_NAME = "financialChartOfAccountsCode";
    private ParameterService parameterService;
    AccountCreationClient accountCreationClient;

    @Override
    public boolean processAddAwardTransferringSponsorEvent(AddAwardTransferringSponsorEvent addAwardTransferringSponsorEvent) {
        boolean valid = true;
        Sponsor sponsor = addAwardTransferringSponsorEvent.getSponsorToBecomeAwardTransferringSponsor();
        if (this.isUnknownSponsor(sponsor)) {
            valid = false;
            this.reportError(SPONSOR_CODE_PROPERTY_NAME, "error.sponsor.invalid", new String[0]);
        }
        if (this.isDuplicateSponsor(sponsor, addAwardTransferringSponsorEvent.getAward().getAwardTransferringSponsors())) {
            valid = false;
            this.reportError(SPONSOR_CODE_PROPERTY_NAME, "error.sponsor.duplicate", new String[0]);
        }
        return valid;
    }

    private boolean isUnknownSponsor(Sponsor sponsor) {
        Sponsor dbSponsor = null;
        if (sponsor != null && sponsor.getSponsorCode() != null) {
            dbSponsor = (Sponsor)this.getBusinessObjectService().retrieve((PersistableBusinessObject)sponsor);
        }
        return dbSponsor == null;
    }

    private boolean isDuplicateSponsor(Sponsor sponsor, List<AwardTransferringSponsor> awardTransferringSponsors) {
        for (AwardTransferringSponsor awardTransferringSponsor : awardTransferringSponsors) {
            if (!awardTransferringSponsor.getSponsorCode().equals(sponsor.getSponsorCode())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean processSaveAwardDetailsAndDates(AwardDetailsAndDatesSaveEvent awardDetailsAndDatesSaveEvent) {
        boolean valid = true;
        Award award = awardDetailsAndDatesSaveEvent.getAward();
        if (award.getAnticipatedTotal().isLessThan((AbstractKualiDecimal)award.getObligatedTotal())) {
            valid = false;
            this.reportError(ANTICIPATED_AMOUNT_PROPERTY_NAME, "error.anticipated.amount", new String[0]);
        }
        if (award.getObligatedTotal().isLessThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            valid = false;
            this.reportError(OBLIGATED_AMOUNT_PROPERTY_NAME, "error.award.obligated.negative", new String[0]);
        }
        if (award.getAnticipatedTotal().isLessThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            valid = false;
            this.reportError(ANTICIPATED_AMOUNT_PROPERTY_NAME, "error.award.anticipated.negative", new String[0]);
        }
        if (award.getObligatedTotal().isGreaterThan((AbstractKualiDecimal)new KualiDecimal(0)) && award.getAwardAmountInfos().get(award.getAwardAmountInfos().size() - 1).getCurrentFundEffectiveDate() == null) {
            valid = false;
            if ("1".equals(this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST"))) {
                this.reportError(AWARD_EFFECTIVE_DATE_PROPERTY_NAME, "error.award.effective.date.total", new String[0]);
            } else {
                this.reportError(AWARD_EFFECTIVE_DATE_PROPERTY_NAME, "error.award.effective.date", new String[0]);
            }
        }
        if (award.getObligatedTotal().isGreaterThan((AbstractKualiDecimal)new KualiDecimal(0)) && award.getAwardAmountInfos().get(award.getAwardAmountInfos().size() - 1).getObligationExpirationDate() == null) {
            valid = false;
            if ("1".equals(this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST"))) {
                this.reportError(OBLIGATION_EXPIRATION_DATE_PROPERTY_NAME, "error.obligation.expiration.date.total", new String[0]);
            } else {
                this.reportError(OBLIGATION_EXPIRATION_DATE_PROPERTY_NAME, "error.obligation.expiration.date", new String[0]);
            }
        }
        if (!this.isValidAccountNumber((AwardDocument)awardDetailsAndDatesSaveEvent.getDocument())) {
            valid &= false;
        }
        if (!this.isValidCfdaNumber(award)) {
            valid &= false;
            this.reportError("cfdaNumber", "error.award.cfda.invalid", award.getCfdaNumber());
        }
        return valid;
    }

    protected boolean isValidCfdaNumber(Award award) {
        if (this.isIntegrationParameterOn() && StringUtils.isNotEmpty((String)award.getCfdaNumber())) {
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("cfdaNumber", award.getCfdaNumber());
            CFDA cfdaNumber = (CFDA)this.getBusinessObjectService().findByPrimaryKey(CFDA.class, criteria);
            return ObjectUtils.isNotNull((Object)((Object)cfdaNumber));
        }
        return true;
    }

    protected boolean isValidAccountNumber(AwardDocument awardDocument) {
        boolean isValid = true;
        Award award = awardDocument.getAward();
        String accountNumber = award.getAccountNumber();
        String financialDocNbr = award.getFinancialAccountDocumentNumber();
        String chartOfAccountsCode = award.getFinancialChartOfAccountsCode();
        if (this.isIntegrationParameterOn() && StringUtils.isEmpty((String)financialDocNbr) && this.validationRequired(award) && (ObjectUtils.isNotNull((Object)accountNumber) || ObjectUtils.isNotNull((Object)chartOfAccountsCode))) {
            AccountCreationClient client = this.getAccountCreationClientService();
            if (ObjectUtils.isNull((Object)chartOfAccountsCode) || ObjectUtils.isNull((Object)accountNumber)) {
                isValid &= false;
                this.reportError(AWARD_ACCOUNT_NUMBER_PROPERTY_NAME, "error.award.account.number.and.chart.required", new String[0]);
            } else {
                String isValidChartAccount = client.isValidChartAccount(chartOfAccountsCode, accountNumber);
                if (ObjectUtils.isNull((Object)isValidChartAccount)) {
                    this.reportError(AWARD_FIN_CHART_OF_ACCOUNTS_CODE_PROPERTY_NAME, "error.award.account.number.not.validated", new String[0]);
                    isValid &= false;
                }
                if (StringUtils.equalsIgnoreCase((String)isValidChartAccount, (String)"false")) {
                    this.reportError(AWARD_ACCOUNT_NUMBER_PROPERTY_NAME, "error.award.chart.of.accounts.code.invalid", award.getAccountNumber(), award.getFinancialChartOfAccountsCode());
                    isValid &= false;
                }
            }
        }
        return isValid;
    }

    protected boolean validationRequired(Award award) {
        boolean isRequired = true;
        if (ObjectUtils.isNotNull((Object)award.getAwardId())) {
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("awardId", award.getAwardId() + "");
            Award awardStored = (Award)this.getBusinessObjectService().findByPrimaryKey(Award.class, criteria);
            if (ObjectUtils.isNotNull((Object)awardStored)) {
                String accountNumberStored = awardStored.getAccountNumber();
                String chartStored = awardStored.getFinancialChartOfAccountsCode();
                if (ObjectUtils.isNull((Object)award.getAccountNumber()) || ObjectUtils.isNull((Object)award.getFinancialChartOfAccountsCode())) {
                    return true;
                }
                if (award.getAccountNumber().equalsIgnoreCase(accountNumberStored) && chartStored.equalsIgnoreCase(award.getFinancialChartOfAccountsCode())) {
                    isRequired &= false;
                }
            }
        }
        return isRequired;
    }

    protected AccountCreationClient getAccountCreationClientService() {
        if (this.accountCreationClient == null) {
            this.accountCreationClient = (AccountCreationClient)KraServiceLocator.getService("accountCreationClient");
        }
        return this.accountCreationClient;
    }

    protected boolean isIntegrationParameterOn() {
        boolean integrationOn = this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "Document", "FIN_SYSTEM_INTEGRATION_ON");
        return integrationOn;
    }

    @Override
    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService("parameterService");
        }
        return this.parameterService;
    }
}

