/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.document;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncService;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.budget.AwardBudgetVersionOverviewExt;
import org.kuali.kra.award.budget.document.AwardBudgetDocumentVersion;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.document.authorization.AwardTask;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipient;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.bo.DocumentCustomData;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.ProposalStatus;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalBoLite;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.krms.KrmsRulesContext;
import org.kuali.kra.krms.service.KcKrmsFactBuilderService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.KraWorkflowService;
import org.kuali.kra.service.ResearchDocumentService;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kns.datadictionary.HeaderNavigation;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krms.api.engine.Facts;

@ParameterConstants.NAMESPACE(namespace="KC-AWARD")
@ParameterConstants.COMPONENT(component="Document")
public class AwardDocument
extends BudgetParentDocument<Award>
implements Copyable,
SessionDocument,
KrmsRulesContext {
    private static final Log LOG = LogFactory.getLog(AwardDocument.class);
    public static final String PLACEHOLDER_DOC_DESCRIPTION = "*****PLACEHOLDER*****";
    private static final long serialVersionUID = 1668673531338660064L;
    public static final String DOCUMENT_TYPE_CODE = "AWRD";
    private static final String DEFAULT_TAB = "Versions";
    private static final String ALTERNATE_OPEN_TAB = "Parameters";
    private boolean canEdit;
    private List<Award> awardList;
    private List<BudgetDocumentVersion> actualBudgetDocumentVersions;
    private List<BudgetDocumentVersion> budgetDocumentVersions;
    private static final String RETURN_TO_AWARD_ALT_TEXT = "return to award";
    private static final String RETURN_TO_AWARD_METHOD_TO_CALL = "methodToCall.returnToAward";
    private static final String KRA_EXTERNALIZABLE_IMAGES_URI_KEY = "kra.externalizable.images.url";
    private static final String HAS_SYNC_SPLITNODE = "hasSync";
    private static final String IS_SYNC_CHILD_SPLITNODE = "isSyncChild";
    private transient boolean documentSaveAfterVersioning;
    private transient AwardService awardService;

    public AwardDocument() {
        this.init();
    }

    public Award getAward() {
        return this.awardList.size() > 0 ? this.awardList.get(0) : new Award();
    }

    public void setAward(Award award) {
        this.awardList.set(0, award);
    }

    public List<Award> getAwardList() {
        return this.awardList;
    }

    public void setAwardList(List<Award> awardList) {
        this.awardList = awardList;
    }

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public boolean isDocumentSaveAfterVersioning() {
        return this.documentSaveAfterVersioning;
    }

    public void setDocumentSaveAfterAwardLookupEditOrVersion(boolean documentSaveAfterVersioning) {
        this.documentSaveAfterVersioning = documentSaveAfterVersioning;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        Award award = this.getAward();
        this.addAwardPersonUnitsCollection(managedLists, award);
        managedLists.add(award.getProjectPersons());
        managedLists.add(award.getAwardUnitContacts());
        managedLists.add(award.getSponsorContacts());
        managedLists.add(award.getAwardCostShares());
        managedLists.add(award.getApprovedEquipmentItems());
        managedLists.add(award.getApprovedForeignTravelTrips());
        managedLists.add(award.getAwardFandaRate());
        managedLists.add(this.getAward().getAwardSponsorTerms());
        managedLists.add(award.getPaymentScheduleItems());
        managedLists.add(award.getAwardTransferringSponsors());
        managedLists.add(award.getAwardDirectFandADistributions());
        managedLists.add(award.getAwardApprovedSubawards());
        managedLists.add(award.getAwardCloseoutItems());
        managedLists.add(award.getAwardAttachments());
        ArrayList specialReviewExemptions = new ArrayList();
        for (AwardSpecialReview specialReview : this.getAward().getSpecialReviews()) {
            specialReviewExemptions.addAll(specialReview.getSpecialReviewExemptions());
        }
        managedLists.add(specialReviewExemptions);
        managedLists.add(award.getSpecialReviews());
        List<AwardReportTerm> reportTerms = award.getAwardReportTermItems();
        ArrayList<AwardReportTermRecipient> recipients = new ArrayList<AwardReportTermRecipient>();
        for (AwardReportTerm reportTerm : reportTerms) {
            recipients.addAll(reportTerm.getAwardReportTermRecipients());
        }
        managedLists.add(recipients);
        managedLists.add(reportTerms);
        managedLists.add(award.getFundingProposals());
        managedLists.add(this.awardList);
        return managedLists;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        String newStatus = statusChangeEvent.getNewRouteStatus();
        String oldStatus = statusChangeEvent.getOldRouteStatus();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("********************* Status Change: from %s to %s", statusChangeEvent.getOldRouteStatus(), newStatus));
        }
        if ("F".equalsIgnoreCase(newStatus)) {
            this.getAwardService().updateAwardSequenceStatus(this.getAward(), VersionStatus.ACTIVE);
            this.getVersionHistoryService().updateVersionHistory(this.getAward(), VersionStatus.ACTIVE, GlobalVariables.getUserSession().getPrincipalName());
        }
        if (newStatus.equalsIgnoreCase("X") || newStatus.equalsIgnoreCase("D")) {
            this.revertFundedProposals();
            this.disableAwardComments();
            this.getAwardService().updateAwardSequenceStatus(this.getAward(), VersionStatus.CANCELED);
            this.getVersionHistoryService().updateVersionHistory(this.getAward(), VersionStatus.CANCELED, GlobalVariables.getUserSession().getPrincipalName());
        }
        for (Award award : this.awardList) {
            award.setAwardDocument(this);
        }
    }

    public void doRouteLevelChange(DocumentRouteLevelChange levelChangeEvent) {
        if (StringUtils.equalsIgnoreCase((String)levelChangeEvent.getNewNodeName(), (String)"SyncValidationApproval") && !this.getAward().getSyncChanges().isEmpty()) {
            this.getAwardSyncService().validateHierarchyChanges(this.getAward());
        } else if (StringUtils.equalsIgnoreCase((String)levelChangeEvent.getNewNodeName(), (String)"ApplySync") && !this.getAward().getSyncChanges().isEmpty()) {
            this.getAwardSyncService().applyAwardSyncChangesToHierarchy(this.getAward());
        }
    }

    @Override
    public boolean answerSplitNodeQuestion(String routeNodeName) throws Exception {
        LOG.debug((Object)("Processing answerSplitNodeQuestion:" + routeNodeName));
        if (StringUtils.equals((String)HAS_SYNC_SPLITNODE, (String)routeNodeName)) {
            return !this.getAward().getSyncChanges().isEmpty();
        }
        if (StringUtils.equals((String)IS_SYNC_CHILD_SPLITNODE, (String)routeNodeName)) {
            return this.getAward().isSyncChild();
        }
        return super.answerSplitNodeQuestion(routeNodeName);
    }

    protected void init() {
        this.awardList = new ArrayList<Award>();
        this.awardList.add(new Award());
        this.budgetDocumentVersions = new ArrayList<BudgetDocumentVersion>();
        this.actualBudgetDocumentVersions = new ArrayList<BudgetDocumentVersion>();
    }

    @Override
    public void prepareForSave() {
        Award award;
        super.prepareForSave();
        if (ObjectUtils.isNull((Object)this.getVersionNumber())) {
            this.setVersionNumber(new Long(0L));
        }
        if (this.getBudgetDocumentVersions() != null) {
            this.updateDocumentDescriptions(this.getBudgetDocumentVersions());
        }
        if (!(award = this.getAward()).getProjectPersons().isEmpty()) {
            List<AwardPerson> aList = award.getProjectPersonsSorted();
            award.getProjectPersons().clear();
            award.getProjectPersons().addAll(aList);
            this.removeKeyPersonRoleForNoneKeyPerson();
        }
    }

    void removeKeyPersonRoleForNoneKeyPerson() {
        for (AwardPerson person : this.getAward().getProjectPersons()) {
            if (StringUtils.equalsIgnoreCase((String)person.getContactRole().getRoleCode(), (String)"KP") || !StringUtils.isNotEmpty((String)person.getKeyPersonRole())) continue;
            person.setKeyPersonRole(null);
        }
    }

    public void postProcessSave(KualiDocumentEvent event) {
        if (event instanceof SaveDocumentEvent) {
            this.updateFundedProposals();
        }
    }

    private void updateFundedProposals() {
        HashSet<String> modifiedProposals = new HashSet<String>();
        ArrayList<AwardFundingProposal> pendingVersions = new ArrayList<AwardFundingProposal>();
        for (AwardFundingProposal afp : this.getAward().getFundingProposals()) {
            InstitutionalProposalBoLite proposal = afp.getProposal();
            if (ProposalStatus.FUNDED.equals(proposal.getStatusCode())) continue;
            modifiedProposals.add(proposal.getProposalNumber());
            pendingVersions.add(afp);
        }
        if (modifiedProposals.size() > 0) {
            this.getInstitutionalProposalService().fundInstitutionalProposals(modifiedProposals);
            this.getAward().refreshReferenceObject("fundingProposals");
        }
    }

    private void addAwardPersonUnitsCollection(List managedLists, Award award) {
        ArrayList<AwardPersonUnit> personUnits = new ArrayList<AwardPersonUnit>();
        for (AwardPerson p : award.getProjectPersons()) {
            personUnits.addAll(p.getUnits());
        }
        managedLists.add(personUnits);
    }

    protected KraAuthorizationService getKraAuthorizationService() {
        return KraServiceLocator.getService(KraAuthorizationService.class);
    }

    protected VersionHistoryService getVersionHistoryService() {
        return KraServiceLocator.getService(VersionHistoryService.class);
    }

    protected AwardSyncService getAwardSyncService() {
        return KraServiceLocator.getService(AwardSyncService.class);
    }

    public List getBudgetDocumentVersions() {
        if (this.budgetDocumentVersions == null || this.budgetDocumentVersions.isEmpty()) {
            this.budgetDocumentVersions = KraServiceLocator.getService(AwardBudgetService.class).getAllBudgetsForAward(this);
        }
        return this.budgetDocumentVersions;
    }

    @Override
    public void setBudgetDocumentVersions(List<BudgetDocumentVersion> budgetDocumentVersions) {
        this.budgetDocumentVersions = budgetDocumentVersions;
    }

    @Override
    public void saveBudgetFinalVersionStatus(BudgetDocument budgetDocument) {
    }

    @Override
    public void processAfterRetrieveForBudget(BudgetDocument budgetDocument) {
    }

    @Override
    public String getDocumentKey() {
        return "award";
    }

    @Override
    public String getDocumentNumberForPermission() {
        return this.getAward().getAwardId().toString();
    }

    @Override
    public List<String> getRoleNames() {
        ArrayList<String> roleNames = new ArrayList<String>();
        return roleNames;
    }

    @Override
    public Permissionable getBudgetPermissionable() {
        return new Permissionable(){

            @Override
            public String getDocumentKey() {
                return "awardbudget";
            }

            @Override
            public String getDocumentNumberForPermission() {
                return AwardDocument.this.getAward().getAwardId().toString();
            }

            @Override
            public List<String> getRoleNames() {
                ArrayList<String> roleNames = new ArrayList<String>();
                return roleNames;
            }

            @Override
            public String getNamespace() {
                return "KC-AWARD";
            }

            @Override
            public String getLeadUnitNumber() {
                return AwardDocument.this.getAward().getLeadUnitNumber();
            }

            @Override
            public String getDocumentRoleTypeCode() {
                return "KC-AWARD";
            }

            @Override
            public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
            }
        };
    }

    @Override
    public String getTaskGroupName() {
        return "awardBudget";
    }

    @Override
    public ExtraButton configureReturnToParentTopButton() {
        ExtraButton returnToProposalButton = new ExtraButton();
        returnToProposalButton.setExtraButtonProperty(RETURN_TO_AWARD_METHOD_TO_CALL);
        returnToProposalButton.setExtraButtonSource(this.buildExtraButtonSourceURI("tinybutton-returntoaward.gif"));
        returnToProposalButton.setExtraButtonAltText(RETURN_TO_AWARD_ALT_TEXT);
        return returnToProposalButton;
    }

    private String buildExtraButtonSourceURI(String buttonFileName) {
        return this.lookupKualiConfigurationService().getPropertyValueAsString(KRA_EXTERNALIZABLE_IMAGES_URI_KEY) + buttonFileName;
    }

    private ConfigurationService lookupKualiConfigurationService() {
        return KRADServiceLocator.getKualiConfigurationService();
    }

    @Override
    public List<HeaderNavigation> getBudgetHeaderNavigatorList() {
        List<HeaderNavigation> budgetHeaderList = super.getBudgetHeaderNavigatorList();
        ArrayList<HeaderNavigation> awardBudgetHeaderList = new ArrayList<HeaderNavigation>();
        for (HeaderNavigation headerNavigation : budgetHeaderList) {
            if (headerNavigation.getHeaderTabNavigateTo().equals("modularBudget")) continue;
            awardBudgetHeaderList.add(headerNavigation);
        }
        return awardBudgetHeaderList;
    }

    @Override
    public Award getBudgetParent() {
        return this.getAward();
    }

    @Override
    public Task getParentAuthZTask(String taskName) {
        return new AwardTask(taskName, this.getAward());
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    public boolean isEditable() {
        WorkflowDocument workflowDoc = this.getDocumentHeader().getWorkflowDocument();
        return workflowDoc.isInitiated() || workflowDoc.isSaved();
    }

    public boolean isSaved() {
        return this.getDocumentHeader().getWorkflowDocument().isSaved();
    }

    public boolean useCustomLockDescriptors() {
        return true;
    }

    public String getCustomLockDescriptor(Person user) {
        String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
        String updatedTimestamp = "";
        if (this.getUpdateTimestamp() != null) {
            updatedTimestamp = new SimpleDateFormat("MM/dd/yyyy KK:mm a").format(this.getUpdateTimestamp());
        }
        if (StringUtils.isNotEmpty((String)activeLockRegion)) {
            return this.getAward().getAwardNumber() + "-" + activeLockRegion + "-" + GlobalVariables.getUserSession().getPrincipalName() + "-" + updatedTimestamp;
        }
        return null;
    }

    @Override
    public String getNamespace() {
        return "KC-AWARD";
    }

    @Override
    public String getLeadUnitNumber() {
        return this.getAward().getLeadUnitNumber();
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return "KC-AWARD";
    }

    @Override
    public String getProposalBudgetFlag() {
        return "false";
    }

    public boolean getCanModify() {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("sectionName", "award");
        permissionDetails.put("documentTypeName", "AwardDocument");
        HashMap<String, String> qualifications = new HashMap<String, String>();
        qualifications.put("unitNumber", this.getLeadUnitNumber());
        return this.getPermissionService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), "KC-AWARD", "Modify Award", qualifications);
    }

    protected PermissionService getPermissionService() {
        return KraServiceLocator.getService(PermissionService.class);
    }

    protected IdentityService getIdentityService() {
        return KraServiceLocator.getService(IdentityService.class);
    }

    protected InstitutionalProposalService getInstitutionalProposalService() {
        return KraServiceLocator.getService(InstitutionalProposalService.class);
    }

    public AwardBudgetVersionOverviewExt getBudgetVersionOverview() {
        AwardBudgetVersionOverviewExt budget = new AwardBudgetVersionOverviewExt();
        List awardBudgetDocuments = this.getBudgetDocumentVersions();
        for (AwardBudgetDocumentVersion budgetDocumentVersion : awardBudgetDocuments) {
            List<BudgetVersionOverview> budgetVersionOverviews = budgetDocumentVersion.getBudgetVersionOverviews();
            for (int i = 0; i < budgetVersionOverviews.size(); ++i) {
                AwardBudgetVersionOverviewExt budgetVersionOverview = (AwardBudgetVersionOverviewExt)budgetVersionOverviews.get(i);
                if (budgetVersionOverview == null || budget.getBudgetVersionNumber() != null && (budget.getBudgetVersionNumber() == null || budgetVersionOverview.getBudgetVersionNumber() <= budget.getBudgetVersionNumber())) continue;
                budget = budgetVersionOverview;
            }
        }
        return budget;
    }

    public boolean isPlaceHolderDocument() {
        if (this.getDocumentHeader() != null) {
            return PLACEHOLDER_DOC_DESCRIPTION.equals(this.getDocumentHeader().getDocumentDescription());
        }
        return false;
    }

    private void revertFundedProposals() {
        HashSet<String> proposalsToUpdate = new HashSet<String>();
        for (AwardFundingProposal awardFundingProposal : this.getAward().getFundingProposals()) {
            proposalsToUpdate.add(awardFundingProposal.getProposal().getProposalNumber());
        }
        KraServiceLocator.getService(BusinessObjectService.class).delete(this.getAward().getFundingProposals());
        this.getAward().getFundingProposals().clear();
        this.getInstitutionalProposalService().defundInstitutionalProposals(proposalsToUpdate, this.getAward().getAwardNumber(), this.getAward().getSequenceNumber());
    }

    private void disableAwardComments() {
        for (AwardComment awardComment : this.getAward().getAwardComments()) {
            awardComment.disableComment();
        }
    }

    @Override
    public boolean isProcessComplete() {
        boolean isComplete = false;
        if (this.getDocumentHeader().hasWorkflowDocument()) {
            if (this.getDocumentHeader().getWorkflowDocument().isFinal() || this.getDocumentHeader().getWorkflowDocument().isProcessed() || KraServiceLocator.getService(KraWorkflowService.class).hasPendingApprovalRequests(this.getDocumentHeader().getWorkflowDocument())) {
                isComplete = true;
            } else if (!this.getAward().getSyncChanges().isEmpty() && this.getAward().getSyncStatuses().size() > 1) {
                isComplete = true;
            }
        }
        return isComplete;
    }

    public List<BudgetDocumentVersion> getActualBudgetDocumentVersions() {
        return this.actualBudgetDocumentVersions;
    }

    public void setActualBudgetDocumentVersions(List<BudgetDocumentVersion> actualBudgetDocumentVersions) {
        this.actualBudgetDocumentVersions = actualBudgetDocumentVersions;
    }

    @Override
    public void refreshBudgetDocumentVersions() {
        this.refreshReferenceObject("actualBudgetDocumentVersions");
        this.budgetDocumentVersions.clear();
    }

    public AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = KraServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    @Override
    public void populateContextQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("namespaceCode", this.getNamespace());
        qualifiers.put("name", this.getRuleContextName());
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder) {
        KcKrmsFactBuilderService fbService = (KcKrmsFactBuilderService)KraServiceLocator.getService("awardFactBuilderService");
        fbService.addFacts(factsBuilder, this);
    }

    public String getRuleContextName() {
        return "KC Award Context";
    }

    @Override
    public void populateAgendaQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("Unit Number", this.getLeadUnitNumber());
    }

    public String buildForwardUrl() {
        ResearchDocumentService researchDocumentService = KraServiceLocator.getService(ResearchDocumentService.class);
        String forward = researchDocumentService.getDocHandlerUrl(this.getDocumentNumber());
        forward = (forward = forward.replaceFirst(DEFAULT_TAB, ALTERNATE_OPEN_TAB)).indexOf("?") == -1 ? forward + "?" : forward + "&";
        forward = forward + "docId=" + this.documentNumber;
        forward = forward + "&command=displayDocSearchView";
        if (GlobalVariables.getUserSession().isBackdoorInUse()) {
            forward = forward + "&backdoorId=" + GlobalVariables.getUserSession().getPrincipalName();
        }
        String returnVal = "<a href=\"" + forward + "\"target=\"_blank\">" + this.documentNumber + "</a>";
        return returnVal;
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return this.getAward().getAwardCustomDataList();
    }

    public boolean isCanceled() {
        WorkflowDocument workflow = this.getDocumentHeader().getWorkflowDocument();
        return workflow.isCanceled();
    }
}

