/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.AwardTemplateSyncScope;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyTempObject;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncStatus;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncableProperty;
import org.kuali.kra.award.budget.AwardBudgetLimit;
import org.kuali.kra.award.commitments.AwardCostShare;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardSponsorContact;
import org.kuali.kra.award.contacts.AwardUnitContact;
import org.kuali.kra.award.customdata.AwardCustomData;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.AwardBasisOfPayment;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.AwardCommentFactory;
import org.kuali.kra.award.home.AwardMethodOfPayment;
import org.kuali.kra.award.home.AwardSponsorTerm;
import org.kuali.kra.award.home.AwardStatus;
import org.kuali.kra.award.home.AwardSyncable;
import org.kuali.kra.award.home.AwardSyncableList;
import org.kuali.kra.award.home.AwardTemplate;
import org.kuali.kra.award.home.AwardTemplateComment;
import org.kuali.kra.award.home.AwardTemplateContact;
import org.kuali.kra.award.home.AwardTemplateReportTerm;
import org.kuali.kra.award.home.AwardTemplateTerm;
import org.kuali.kra.award.home.AwardTransferringSponsor;
import org.kuali.kra.award.home.AwardType;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.award.home.ValuableItem;
import org.kuali.kra.award.home.approvedsubawards.AwardApprovedSubaward;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.award.home.keywords.AwardScienceKeyword;
import org.kuali.kra.award.notesandattachments.attachments.AwardAttachment;
import org.kuali.kra.award.notesandattachments.notes.AwardNotepad;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseout;
import org.kuali.kra.award.paymentreports.paymentschedule.AwardPaymentSchedule;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipment;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravel;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistribution;
import org.kuali.kra.bo.AccountType;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.ScienceKeyword;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.bo.UnitAdministrator;
import org.kuali.kra.bo.versioning.VersionHistorySearchBo;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.personnel.PersonRolodex;
import org.kuali.kra.coi.Disclosurable;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.document.KeywordsManager;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.negotiations.bo.Negotiable;
import org.kuali.kra.negotiations.bo.NegotiationPersonDTO;
import org.kuali.kra.proposaldevelopment.bo.ActivityType;
import org.kuali.kra.proposaldevelopment.bo.ProposalType;
import org.kuali.kra.service.Sponsorable;
import org.kuali.kra.service.SystemAuthorizationService;
import org.kuali.kra.service.UnitService;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.timeandmoney.TimeAndMoneyDocumentHistory;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyHistoryService;
import org.kuali.kra.timeandmoney.transactions.AwardTransactionType;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.util.AutoPopulatingList;

public class Award
extends KraPersistableBusinessObjectBase
implements KeywordsManager<AwardScienceKeyword>,
Permissionable,
SequenceOwner<Award>,
BudgetParent,
Sponsorable,
Negotiable,
Disclosurable {
    public static final String DEFAULT_AWARD_NUMBER = "000000-00000";
    public static final String BLANK_COMMENT = "";
    public static final String ICR_RATE_CODE_NONE = "ICRNONE";
    private static final String NO_FLAG = "N";
    private static final int TOTAL_STATIC_REPORTS = 5;
    public static final String CLOSE_OUT_REPORT_TYPE_FINANCIAL_REPORT = "1";
    public static final String CLOSE_OUT_REPORT_TYPE_TECHNICAL = "4";
    public static final String CLOSE_OUT_REPORT_TYPE_PATENT = "3";
    public static final String CLOSE_OUT_REPORT_TYPE_PROPERTY = "2";
    public static final String CLOSE_OUT_REPORT_TYPE_INVOICE = "6";
    private static final int MAX_NBR_AWD_HIERARCHY_TEMP_OBJECTS = 100;
    private static final String DEFAULT_GROUP_CODE_FOR_CENTRAL_ADMIN_CONTACTS = "C";
    public static final String NOTIFICATION_IRB_SPECIAL_REVIEW_LINK_ADDED = "552";
    public static final String NOTIFICATION_IRB_SPECIAL_REVIEW_LINK_DELETED = "553";
    public static final String NOTIFICATION_IACUC_SPECIAL_REVIEW_LINK_ADDED = "554";
    public static final String NOTIFICATION_IACUC_SPECIAL_REVIEW_LINK_DELETED = "555";
    private static final long serialVersionUID = 3797220122448310165L;
    private Long awardId;
    private AwardDocument awardDocument;
    private String awardNumber;
    private Integer sequenceNumber;
    @AwardSyncableProperty
    private String sponsorCode;
    @AwardSyncableProperty
    private Integer statusCode;
    private AwardStatus awardStatus;
    private String accountNumber;
    private String approvedEquipmentIndicator;
    private String approvedForeignTripIndicator;
    private String subContractIndicator;
    private java.sql.Date awardEffectiveDate;
    private java.sql.Date awardExecutionDate;
    private java.sql.Date beginDate;
    private String costSharingIndicator;
    private String indirectCostIndicator;
    private String modificationNumber;
    private String nsfCode;
    private String paymentScheduleIndicator;
    private String scienceCodeIndicator;
    private String specialReviewIndicator;
    private String sponsorAwardNumber;
    private String transferSponsorIndicator;
    private Integer accountTypeCode;
    private String activityTypeCode;
    private Integer awardTypeCode;
    private AwardType awardType;
    private String cfdaNumber;
    private String documentFundingId;
    private KualiDecimal preAwardAuthorizedAmount;
    private java.sql.Date preAwardEffectiveDate;
    private KualiDecimal preAwardInstitutionalAuthorizedAmount;
    private java.sql.Date preAwardInstitutionalEffectiveDate;
    private String procurementPriorityCode;
    private String proposalNumber;
    private KualiDecimal specialEbRateOffCampus;
    private KualiDecimal specialEbRateOnCampus;
    private String subPlanFlag;
    private String title;
    private String archiveLocation;
    private java.sql.Date closeoutDate;
    private Integer awardTransactionTypeCode;
    private java.sql.Date noticeDate;
    private String currentActionComments;
    private String financialAccountDocumentNumber;
    private java.sql.Date financialAccountCreationDate;
    private String financialChartOfAccountsCode;
    private String awardSequenceStatus;
    private static boolean newVersion;
    private Integer templateCode;
    @AwardSyncable(scopes={AwardTemplateSyncScope.AWARD_PAGE})
    private String primeSponsorCode;
    @AwardSyncable(impactSourceScopeEmpty=false, scopes={AwardTemplateSyncScope.PAYMENTS_AND_INVOICES_TAB})
    private String basisOfPaymentCode;
    @AwardSyncable(impactSourceScopeEmpty=false, scopes={AwardTemplateSyncScope.PAYMENTS_AND_INVOICES_TAB})
    private String methodOfPaymentCode;
    private AwardTemplate awardTemplate;
    private AwardBasisOfPayment awardBasisOfPayment;
    private AwardMethodOfPayment awardMethodOfPayment;
    private AwardTransactionType awardTransactionType;
    private ActivityType activityType;
    private Sponsor sponsor;
    private Sponsor primeSponsor;
    @AwardSyncableList(syncClass=AwardComment.class, syncSourceClass=AwardTemplateComment.class, scopes={AwardTemplateSyncScope.COST_SHARE, AwardTemplateSyncScope.PAYMENTS_AND_INVOICES_TAB, AwardTemplateSyncScope.COMMENTS_TAB}, removeMissingListElementsFromTarget=false)
    private List<AwardComment> awardComments;
    @AwardSyncableList(syncClass=AwardReportTerm.class, syncSourceClass=AwardTemplateReportTerm.class, scopes={AwardTemplateSyncScope.PAYMENTS_AND_INVOICES_TAB, AwardTemplateSyncScope.REPORTS_TAB})
    private List<AwardReportTerm> awardReportTermItems;
    @AwardSyncableList(syncClass=AwardSponsorTerm.class, syncSourceClass=AwardTemplateTerm.class, scopes={AwardTemplateSyncScope.TERMS_TAB})
    private List<AwardSponsorTerm> awardSponsorTerms;
    @AwardSyncableList(syncClass=AwardSponsorContact.class, syncSourceClass=AwardTemplateContact.class, scopes={AwardTemplateSyncScope.SPONSOR_CONTACTS_TAB})
    private List<AwardSponsorContact> sponsorContacts;
    private List<AwardCustomData> awardCustomDataList;
    private List<Boolean> awardCommentHistoryFlags;
    private Map<String, AwardComment> commentMap;
    private List<AwardCostShare> awardCostShares;
    private List<AwardFandaRate> awardFandaRate;
    private List<AwardDirectFandADistribution> awardDirectFandADistributions;
    private List<AwardApprovedSubaward> awardApprovedSubawards;
    private List<AwardScienceKeyword> keywords;
    private List<AwardPerson> projectPersons;
    private List<AwardUnitContact> awardUnitContacts;
    private List<AwardSpecialReview> specialReviews;
    private List<AwardApprovedEquipment> approvedEquipmentItems;
    private List<AwardApprovedForeignTravel> approvedForeignTravelTrips;
    private List<AwardPaymentSchedule> paymentScheduleItems;
    private List<AwardTransferringSponsor> awardTransferringSponsors;
    private List<AwardAmountInfo> awardAmountInfos;
    private List<AwardCloseout> awardCloseoutItems;
    private List<AwardCloseout> awardCloseoutNewItems;
    private List<AwardNotepad> awardNotepads;
    private List<AwardAttachment> awardAttachments;
    private List<AwardSyncChange> syncChanges;
    private List<AwardSyncStatus> syncStatuses;
    private boolean syncChild;
    private List<AwardFundingProposal> fundingProposals;
    private List<AwardBudgetLimit> awardBudgetLimits;
    private Unit leadUnit;
    private String unitNumber;
    private KcPerson ospAdministrator;
    private String ospAdministratorName;
    private String principalInvestigatorName;
    private String statusDescription;
    private String sponsorName;
    private String icrRateCode;
    private transient boolean awardInMultipleNodeHierarchy;
    private transient boolean awardHasAssociatedTandMOrIsVersioned;
    private transient boolean sponsorNihMultiplePi;
    private transient List<AwardHierarchyTempObject> awardHierarchyTempObjects;
    private transient String docIdStatus;
    private transient String awardIdAccount;
    private transient String lookupOspAdministratorName;
    transient AwardAmountInfoService awardAmountInfoService;
    transient TimeAndMoneyHistoryService timeAndMoneyHistoryService;
    private transient AwardHierarchyService awardHierarchyService;
    private transient List<AwardUnitContact> centralAdminContacts;
    private List<SubAward> subAwardList;
    private transient boolean allowUpdateTimestampToBeReset = true;
    private VersionHistorySearchBo versionHistory;
    private static String reportedStatus;

    public Award() {
        this.initializeAwardWithDefaultValues();
        this.initializeCollections();
    }

    private void initializeAwardWithDefaultValues() {
        this.setAwardNumber(DEFAULT_AWARD_NUMBER);
        this.setSequenceNumber(1);
        this.setApprovedEquipmentIndicator(NO_FLAG);
        this.setApprovedForeignTripIndicator(NO_FLAG);
        this.setSubContractIndicator(NO_FLAG);
        this.setCostSharingIndicator(NO_FLAG);
        this.setIdcIndicator(NO_FLAG);
        this.setPaymentScheduleIndicator(NO_FLAG);
        this.setScienceCodeIndicator(NO_FLAG);
        this.setSpecialReviewIndicator(NO_FLAG);
        this.setTransferSponsorIndicator(NO_FLAG);
        this.awardComments = new AutoPopulatingList(AwardComment.class);
        this.setCurrentActionComments(BLANK_COMMENT);
        this.setNewVersion(false);
        this.awardSequenceStatus = VersionStatus.PENDING.name();
    }

    private Map<String, AwardComment> getCommentMap() {
        if (this.commentMap == null || this.getNewVersion()) {
            this.commentMap = new HashMap<String, AwardComment>();
            for (AwardComment ac : this.awardComments) {
                if (this.getNewVersion() && ac.getCommentType().getCommentTypeCode().equals("21")) {
                    ac.setComments(BLANK_COMMENT);
                }
                this.commentMap.put(ac.getCommentType().getCommentTypeCode(), ac);
            }
        }
        return this.commentMap;
    }

    public Integer getTemplateCode() {
        return this.templateCode;
    }

    public String getFinancialChartOfAccountsCode() {
        return this.financialChartOfAccountsCode;
    }

    public void setFinancialChartOfAccountsCode(String financialChartOfAccountsCode) {
        this.financialChartOfAccountsCode = financialChartOfAccountsCode;
    }

    public Long getAwardId() {
        return this.awardId;
    }

    public void setAwardId(Long awardId) {
        this.awardId = awardId;
    }

    public String getAwardNumber() {
        return this.awardNumber;
    }

    public void setAwardNumber(String awardNumber) {
        this.awardNumber = awardNumber;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public int getIndexOfLastAwardAmountInfo() {
        return this.awardAmountInfos.size() - 1;
    }

    public AwardAmountInfo getLastAwardAmountInfo() {
        return this.awardAmountInfos.get(this.getIndexOfLastAwardAmountInfo());
    }

    public int getIndexOfAwardAmountInfoForDisplay() throws WorkflowException {
        AwardAmountInfo aai = this.getAwardAmountInfoService().fetchLastAwardAmountInfoForAwardVersionAndFinalizedTandMDocumentNumber(this);
        int returnVal = 0;
        int index = 0;
        if (aai.getAwardAmountInfoId() != null && this.isAwardInMultipleNodeHierarchy()) {
            this.refreshReferenceObject("awardAmountInfos");
        }
        if (this.isAwardInitialCopy()) {
            returnVal = this.getAwardAmountInfos().size() - 1;
        } else {
            for (AwardAmountInfo awardAmountInfo : this.getAwardAmountInfos()) {
                if (awardAmountInfo.getAwardAmountInfoId() == null && aai.getAwardAmountInfoId() == null) {
                    returnVal = index;
                    continue;
                }
                if (awardAmountInfo.getAwardAmountInfoId().equals(aai.getAwardAmountInfoId())) {
                    returnVal = index;
                    continue;
                }
                ++index;
            }
        }
        return returnVal;
    }

    public int getIndexOfAwardAmountInfoForDisplayFromTimeAndMoneyDocNumber(String docNum) throws WorkflowException {
        AwardAmountInfo aai = this.getAwardAmountInfoService().fetchLastAwardAmountInfoForDocNum(this, docNum);
        int returnVal = 0;
        int index = 0;
        if (aai.getAwardAmountInfoId() != null && this.isAwardInMultipleNodeHierarchy()) {
            this.refreshReferenceObject("awardAmountInfos");
        }
        if (this.isAwardInitialCopy()) {
            returnVal = this.getAwardAmountInfos().size() - 1;
        } else {
            for (AwardAmountInfo awardAmountInfo : this.getAwardAmountInfos()) {
                if (awardAmountInfo.getAwardAmountInfoId() == null && aai.getAwardAmountInfoId() == null) {
                    returnVal = index;
                    continue;
                }
                if (awardAmountInfo.getAwardAmountInfoId().equals(aai.getAwardAmountInfoId())) {
                    returnVal = index;
                    continue;
                }
                ++index;
            }
        }
        return returnVal;
    }

    public boolean isAwardInitialCopy() {
        boolean returnValue = true;
        if (this.getAwardAmountInfos().size() > 1) {
            for (AwardAmountInfo aai : this.getAwardAmountInfos()) {
                if (aai.getAwardAmountInfoId() == null) continue;
                returnValue = false;
                break;
            }
        }
        return returnValue;
    }

    public AwardAmountInfoService getAwardAmountInfoService() {
        this.awardAmountInfoService = KraServiceLocator.getService(AwardAmountInfoService.class);
        return this.awardAmountInfoService;
    }

    public AwardHierarchyService getAwardHierarchyService() {
        if (this.awardHierarchyService == null) {
            this.awardHierarchyService = KraServiceLocator.getService(AwardHierarchyService.class);
        }
        return this.awardHierarchyService;
    }

    public TimeAndMoneyHistoryService getTimeAndMoneyHistoryService() {
        if (this.timeAndMoneyHistoryService == null) {
            this.timeAndMoneyHistoryService = KraServiceLocator.getService(TimeAndMoneyHistoryService.class);
        }
        return this.timeAndMoneyHistoryService;
    }

    public void setAwardAmountInfoService(AwardAmountInfoService awardAmountInfoService) {
        this.awardAmountInfoService = awardAmountInfoService;
    }

    @Override
    public String getSponsorCode() {
        return this.sponsorCode;
    }

    @Override
    public void setSponsorCode(String sponsorCode) {
        this.sponsorCode = sponsorCode;
    }

    public String getAccountTypeDescription() {
        AccountType accountType = (AccountType)this.getBusinessObjectService().findByPrimaryKey(AccountType.class, Collections.singletonMap("accountTypeCode", this.getAccountTypeCode()));
        if (accountType == null) {
            return "None Selected";
        }
        return accountType.getDescription();
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public List<AwardApprovedEquipment> getApprovedEquipmentItems() {
        return this.approvedEquipmentItems;
    }

    public List<AwardUnitContact> getAwardUnitContacts() {
        return this.awardUnitContacts;
    }

    public AwardPerson getProjectPerson(int index) {
        return this.projectPersons.get(index);
    }

    public AwardPerson getProjectPerson(String personId) {
        if (!StringUtils.isBlank((String)personId)) {
            for (AwardPerson awardPerson : this.getProjectPersons()) {
                if (!personId.equals(awardPerson.getPersonId())) continue;
                return awardPerson;
            }
        }
        return null;
    }

    public AwardPerson getProjectPerson(Integer rolodexId) {
        if (rolodexId != null) {
            for (AwardPerson awardPerson : this.getProjectPersons()) {
                if (!rolodexId.equals(awardPerson.getRolodexId())) continue;
                return awardPerson;
            }
        }
        return null;
    }

    public List<AwardPerson> getProjectPersons() {
        return this.projectPersons;
    }

    public List<AwardPerson> getProjectPersonsSorted() {
        ArrayList<AwardPerson> aList = new ArrayList<AwardPerson>();
        if (this.getPrincipalInvestigator() != null) {
            aList.add(this.getPrincipalInvestigator());
        }
        aList.addAll(this.getMultiplePis());
        aList.addAll(this.getCoInvestigators());
        aList.addAll(this.getKeyPersons());
        return aList;
    }

    public List<AwardPerson> getInvestigators() {
        ArrayList<AwardPerson> investigators = new ArrayList<AwardPerson>();
        for (AwardPerson person : this.projectPersons) {
            if (!person.isPrincipalInvestigator() && !person.isCoInvestigator()) continue;
            investigators.add(person);
        }
        Collections.sort(investigators);
        return investigators;
    }

    public List<AwardPerson> getCoInvestigators() {
        ArrayList<AwardPerson> coInvestigators = new ArrayList<AwardPerson>();
        for (AwardPerson person : this.projectPersons) {
            if (!person.isCoInvestigator() || this.isSponsorNihMultiplePi() && person.isMultiplePi()) continue;
            coInvestigators.add(person);
        }
        Collections.sort(coInvestigators);
        return coInvestigators;
    }

    public List<AwardPerson> getMultiplePis() {
        ArrayList<AwardPerson> multiplePis = new ArrayList<AwardPerson>();
        if (this.isSponsorNihMultiplePi()) {
            for (AwardPerson person : this.projectPersons) {
                if (!person.isCoInvestigator() || !person.isMultiplePi()) continue;
                multiplePis.add(person);
            }
            Collections.sort(multiplePis);
        }
        return multiplePis;
    }

    public List<AwardPerson> getKeyPersons() {
        ArrayList<AwardPerson> keyPersons = new ArrayList<AwardPerson>();
        for (AwardPerson person : this.projectPersons) {
            if (!person.isKeyPerson()) continue;
            keyPersons.add(person);
        }
        Collections.sort(keyPersons);
        return keyPersons;
    }

    public int getTotalUnitCount() {
        int count = 0;
        for (AwardPerson person : this.projectPersons) {
            count += person.getUnits().size();
        }
        return count;
    }

    public int getAwardContactsCount() {
        return this.awardUnitContacts.size();
    }

    public int getApprovedEquipmentItemCount() {
        return this.approvedEquipmentItems.size();
    }

    public int getApprovedForeignTravelTripCount() {
        return this.approvedForeignTravelTrips.size();
    }

    public List<AwardApprovedForeignTravel> getApprovedForeignTravelTrips() {
        return this.approvedForeignTravelTrips;
    }

    public void setAwardUnitContacts(List<AwardUnitContact> awardUnitContacts) {
        this.awardUnitContacts = awardUnitContacts;
    }

    public void setApprovedEquipmentItems(List<AwardApprovedEquipment> awardApprovedEquipmentItems) {
        this.approvedEquipmentItems = awardApprovedEquipmentItems;
    }

    public void setApprovedForeignTravelTrips(List<AwardApprovedForeignTravel> approvedForeignTravelTrips) {
        this.approvedForeignTravelTrips = approvedForeignTravelTrips;
    }

    public String getApprovedEquipmentIndicator() {
        return this.approvedEquipmentIndicator;
    }

    public void setApprovedEquipmentIndicator(String approvedEquipmentIndicator) {
        this.approvedEquipmentIndicator = approvedEquipmentIndicator;
    }

    public String getApprovedForeignTripIndicator() {
        return this.approvedForeignTripIndicator;
    }

    public void setApprovedForeignTripIndicator(String approvedForeignTripIndicator) {
        this.approvedForeignTripIndicator = approvedForeignTripIndicator;
    }

    public String getSubContractIndicator() {
        return this.subContractIndicator;
    }

    public void setSubContractIndicator(String subContractIndicator) {
        this.subContractIndicator = subContractIndicator;
    }

    public java.sql.Date getAwardEffectiveDate() {
        return this.awardEffectiveDate;
    }

    public void setAwardEffectiveDate(java.sql.Date awardEffectiveDate) {
        this.awardEffectiveDate = awardEffectiveDate;
    }

    public java.sql.Date getAwardExecutionDate() {
        return this.awardExecutionDate;
    }

    public void setAwardExecutionDate(java.sql.Date awardExecutionDate) {
        this.awardExecutionDate = awardExecutionDate;
    }

    public java.sql.Date getBeginDate() {
        return this.beginDate;
    }

    public java.sql.Date getProjectEndDate() {
        return this.awardAmountInfos.get(0).getFinalExpirationDate();
    }

    public void setProjectEndDate(java.sql.Date date) {
        this.awardAmountInfos.get(0).setFinalExpirationDate(date);
    }

    public java.sql.Date getObligationExpirationDate() {
        return this.getLastAwardAmountInfo().getObligationExpirationDate();
    }

    public void setObligationExpirationDate(java.sql.Date date) {
        this.awardAmountInfos.get(0).setObligationExpirationDate(date);
    }

    public void setBeginDate(java.sql.Date beginDate) {
        this.beginDate = beginDate;
    }

    public String getCostSharingIndicator() {
        return this.costSharingIndicator;
    }

    public void setCostSharingIndicator(String costSharingIndicator) {
        this.costSharingIndicator = costSharingIndicator;
    }

    public List<AwardFundingProposal> getFundingProposals() {
        return this.fundingProposals;
    }

    public String getIdcIndicator() {
        return this.indirectCostIndicator;
    }

    public void setIdcIndicator(String indirectCostIndicator) {
        this.indirectCostIndicator = indirectCostIndicator;
    }

    public String getModificationNumber() {
        return this.modificationNumber;
    }

    public void setModificationNumber(String modificationNumber) {
        this.modificationNumber = modificationNumber;
    }

    public String getNsfCode() {
        return this.nsfCode;
    }

    public void setNsfCode(String nsfCode) {
        this.nsfCode = nsfCode;
    }

    public String getPaymentScheduleIndicator() {
        return this.paymentScheduleIndicator;
    }

    public void setPaymentScheduleIndicator(String paymentScheduleIndicator) {
        this.paymentScheduleIndicator = paymentScheduleIndicator;
    }

    public String getScienceCodeIndicator() {
        return this.scienceCodeIndicator;
    }

    public void setScienceCodeIndicator(String scienceCodeIndicator) {
        this.scienceCodeIndicator = scienceCodeIndicator;
    }

    public String getSpecialReviewIndicator() {
        return this.specialReviewIndicator;
    }

    public void setSpecialReviewIndicator(String specialReviewIndicator) {
        this.specialReviewIndicator = specialReviewIndicator;
    }

    @Override
    public String getSponsorAwardNumber() {
        return this.sponsorAwardNumber;
    }

    public void setSponsorAwardNumber(String sponsorAwardNumber) {
        this.sponsorAwardNumber = sponsorAwardNumber;
    }

    public String getTransferSponsorIndicator() {
        return this.transferSponsorIndicator;
    }

    public String getUnitName() {
        Unit leadUnit = this.getLeadUnit();
        return leadUnit != null ? leadUnit.getUnitName() : null;
    }

    @Override
    public String getUnitNumber() {
        return this.unitNumber;
    }

    @Override
    public String getLeadUnitNumber() {
        return this.getUnitNumber();
    }

    public void setTransferSponsorIndicator(String transferSponsorIndicator) {
        this.transferSponsorIndicator = transferSponsorIndicator;
    }

    public Integer getAccountTypeCode() {
        return this.accountTypeCode;
    }

    public void setAccountTypeCode(Integer accountTypeCode) {
        this.accountTypeCode = accountTypeCode;
    }

    @Override
    public String getActivityTypeCode() {
        return this.activityTypeCode;
    }

    public void setActivityTypeCode(String activityTypeCode) {
        this.activityTypeCode = activityTypeCode;
    }

    public Integer getAwardTypeCode() {
        return this.awardTypeCode;
    }

    public void setAwardTypeCode(Integer awardTypeCode) {
        this.awardTypeCode = awardTypeCode;
    }

    public String getCfdaNumber() {
        return this.cfdaNumber;
    }

    public void setCfdaNumber(String cfdaNumber) {
        this.cfdaNumber = cfdaNumber;
    }

    public String getDocumentFundingId() {
        return this.documentFundingId;
    }

    public void setDocumentFundingId(String documentFundingId) {
        this.documentFundingId = documentFundingId;
    }

    public KcPerson getOspAdministrator() {
        for (AwardUnitContact contact : this.getCentralAdminContacts()) {
            if (!contact.isOspAdministrator()) continue;
            this.ospAdministrator = contact.getPerson();
            break;
        }
        return this.ospAdministrator;
    }

    public String getOspAdministratorName() {
        KcPerson ospAdministrator = this.getOspAdministrator();
        this.ospAdministratorName = ospAdministrator != null ? ospAdministrator.getFullName() : null;
        return this.ospAdministratorName;
    }

    public KualiDecimal getPreAwardAuthorizedAmount() {
        return this.preAwardAuthorizedAmount;
    }

    public void setPreAwardAuthorizedAmount(KualiDecimal preAwardAuthorizedAmount) {
        this.preAwardAuthorizedAmount = preAwardAuthorizedAmount != null && preAwardAuthorizedAmount.isNegative() ? (KualiDecimal)KualiDecimal.ZERO.subtract((AbstractKualiDecimal)preAwardAuthorizedAmount) : preAwardAuthorizedAmount;
    }

    public java.sql.Date getPreAwardEffectiveDate() {
        return this.preAwardEffectiveDate;
    }

    public void setPreAwardEffectiveDate(java.sql.Date preAwardEffectiveDate) {
        this.preAwardEffectiveDate = preAwardEffectiveDate;
    }

    public String getProcurementPriorityCode() {
        return this.procurementPriorityCode;
    }

    public void setProcurementPriorityCode(String procurementPriorityCode) {
        this.procurementPriorityCode = procurementPriorityCode;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public KualiDecimal getSpecialEbRateOffCampus() {
        return this.specialEbRateOffCampus;
    }

    public void setSpecialEbRateOffCampus(KualiDecimal specialEbRateOffCampus) {
        this.specialEbRateOffCampus = specialEbRateOffCampus;
    }

    public KualiDecimal getSpecialEbRateOnCampus() {
        return this.specialEbRateOnCampus;
    }

    public void setSpecialEbRateOnCampus(KualiDecimal specialEbRateOnCampus) {
        this.specialEbRateOnCampus = specialEbRateOnCampus;
    }

    public String getSubPlanFlag() {
        return this.subPlanFlag;
    }

    public void setSubPlanFlag(String subPlanFlag) {
        this.subPlanFlag = subPlanFlag;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getArchiveLocation() {
        return this.archiveLocation;
    }

    public void setArchiveLocation(String archiveLocation) {
        this.archiveLocation = archiveLocation;
    }

    public java.sql.Date getCloseoutDate() {
        return this.closeoutDate;
    }

    public void setCloseoutDate(java.sql.Date closeoutDate) {
        this.closeoutDate = closeoutDate;
    }

    public Integer getAwardTransactionTypeCode() {
        return this.awardTransactionTypeCode;
    }

    public void setAwardTransactionTypeCode(Integer awardTransactionTypeCode) {
        this.awardTransactionTypeCode = awardTransactionTypeCode;
    }

    public java.sql.Date getNoticeDate() {
        return this.noticeDate;
    }

    public void setNoticeDate(java.sql.Date noticeDate) {
        this.noticeDate = this.getNewVersion() ? null : noticeDate;
    }

    public String getCurrentActionComments() {
        return this.currentActionComments;
    }

    public void setCurrentActionComments(String currentActionComments) {
        this.currentActionComments = this.getNewVersion() ? BLANK_COMMENT : currentActionComments;
    }

    public void setNewVersion(boolean newVersion) {
        Award.newVersion = newVersion;
        if (Award.newVersion) {
            this.commentMap = this.getCommentMap();
            this.setCurrentActionComments(BLANK_COMMENT);
            this.setNoticeDate(null);
        }
    }

    public boolean getNewVersion() {
        return newVersion;
    }

    public AwardTransactionType getAwardTransactionType() {
        return this.awardTransactionType;
    }

    public void setAwardTransactionType(AwardTransactionType awardTransactionType) {
        this.awardTransactionType = awardTransactionType;
    }

    public String getFinancialAccountDocumentNumber() {
        return this.financialAccountDocumentNumber;
    }

    public void setFinancialAccountDocumentNumber(String financialAccountDocumentNumber) {
        this.financialAccountDocumentNumber = financialAccountDocumentNumber;
    }

    public java.sql.Date getFinancialAccountCreationDate() {
        return this.financialAccountCreationDate;
    }

    public void setFinancialAccountCreationDate(java.sql.Date financialAccountCreationDate) {
        this.financialAccountCreationDate = financialAccountCreationDate;
    }

    public AwardDocument getAwardDocument() {
        if (this.awardDocument == null) {
            this.refreshReferenceObject("awardDocument");
        }
        return this.awardDocument;
    }

    public String getAwardDocumentUrl() {
        return this.getAwardDocument().buildForwardUrl();
    }

    public void setAwardDocument(AwardDocument awardDocument) {
        this.awardDocument = awardDocument;
    }

    public List<AwardComment> getAwardComments() {
        return this.awardComments;
    }

    public void setAwardComments(List<AwardComment> awardComments) {
        this.awardComments = awardComments;
    }

    public List<AwardCostShare> getAwardCostShares() {
        return this.awardCostShares;
    }

    public void setAwardCostShares(List<AwardCostShare> awardCostShares) {
        this.awardCostShares = awardCostShares;
    }

    public List<AwardApprovedSubaward> getAwardApprovedSubawards() {
        return this.awardApprovedSubawards;
    }

    public void setAwardApprovedSubawards(List<AwardApprovedSubaward> awardApprovedSubawards) {
        this.awardApprovedSubawards = awardApprovedSubawards;
    }

    public AwardComment getAwardCostShareComment() {
        return this.getAwardCommentByType("9", true, true);
    }

    public AwardComment getawardPreAwardSponsorAuthorizationComment() {
        return this.getAwardCommentByType("18", false, true);
    }

    public AwardComment getawardPreAwardInstitutionalAuthorizationComment() {
        return this.getAwardCommentByType("19", false, true);
    }

    public AwardComment getAwardFandaRateComment() {
        return this.getAwardCommentByType("8", true, true);
    }

    public AwardComment getAwardPaymentAndInvoiceRequirementsComments() {
        return this.getAwardCommentByType(CLOSE_OUT_REPORT_TYPE_FINANCIAL_REPORT, true, true);
    }

    public AwardComment getAwardBenefitsRateComment() {
        return this.getAwardCommentByType("20", true, true);
    }

    public AwardComment getAwardGeneralComments() {
        return this.getAwardCommentByType(CLOSE_OUT_REPORT_TYPE_PROPERTY, true, true);
    }

    public AwardComment getAwardFiscalReportComments() {
        return this.getAwardCommentByType(CLOSE_OUT_REPORT_TYPE_PATENT, true, true);
    }

    public AwardComment getAwardCurrentActionComments() {
        return this.getAwardCommentByType("21", false, true);
    }

    public AwardComment getAwardIntellectualPropertyComments() {
        return this.getAwardCommentByType(CLOSE_OUT_REPORT_TYPE_TECHNICAL, false, true);
    }

    public AwardComment getAwardProcurementComments() {
        return this.getAwardCommentByType("5", true, true);
    }

    public AwardComment getAwardPropertyComments() {
        return this.getAwardCommentByType(CLOSE_OUT_REPORT_TYPE_INVOICE, true, true);
    }

    public AwardComment getAwardSpecialRate() {
        return this.getAwardCommentByType("7", false, true);
    }

    public AwardComment getAwardSpecialReviewComments() {
        return this.getAwardCommentByType("10", false, true);
    }

    public AwardComment getawardProposalSummary() {
        return this.getAwardCommentByType("12", false, true);
    }

    public AwardComment getawardProposalComments() {
        return this.getAwardCommentByType("13", false, true);
    }

    public AwardComment getAwardProposalIPReviewComment() {
        return this.getAwardCommentByType("16", false, true);
    }

    public AwardComment getAwardCommentByType(String awardTypeCode, boolean checklistPrintFlag, boolean createNew) {
        AwardCommentFactory awardCommentFactory = new AwardCommentFactory();
        AwardComment awardComment = this.getCommentMap().get(awardTypeCode);
        if (awardComment == null && createNew) {
            awardComment = awardCommentFactory.createAwardComment(awardTypeCode, checklistPrintFlag);
            this.add(awardComment);
            this.commentMap.put(awardComment.getCommentType().getCommentTypeCode(), awardComment);
        }
        return awardComment;
    }

    public AwardSponsorTerm getAwardSponsorTermByTemplateTerm(AwardTemplateTerm templateTerm, boolean createNew) {
        AwardSponsorTerm result = null;
        for (AwardSponsorTerm term : this.getAwardSponsorTerms()) {
            if (!term.getSponsorTermId().equals(templateTerm.getSponsorTermId())) continue;
            result = term;
            break;
        }
        if (result == null && createNew) {
            result = new AwardSponsorTerm();
            result.setSponsorTermId(templateTerm.getSponsorTermId());
            result.setSponsorTerm(templateTerm.getSponsorTerm());
        }
        return result;
    }

    public KualiDecimal getTotalCostShareCommitmentAmount() {
        return this.getTotalAmount(this.awardCostShares);
    }

    public KualiDecimal getTotalCostShareMetAmount() {
        KualiDecimal returnVal = new KualiDecimal(0.0);
        for (AwardCostShare awardCostShare : this.awardCostShares) {
            KualiDecimal amount = awardCostShare.getCostShareMet() != null ? awardCostShare.getCostShareMet() : new KualiDecimal(0.0);
            returnVal = (KualiDecimal)returnVal.add((AbstractKualiDecimal)amount);
        }
        return returnVal;
    }

    public KualiDecimal getTotalDirectFandADistributionDirectCostAmount() {
        KualiDecimal returnVal = new KualiDecimal(0.0);
        for (AwardDirectFandADistribution awardDirectFandADistribution : this.awardDirectFandADistributions) {
            KualiDecimal amount = awardDirectFandADistribution.getDirectCost() != null ? awardDirectFandADistribution.getDirectCost() : new KualiDecimal(0.0);
            returnVal = (KualiDecimal)returnVal.add((AbstractKualiDecimal)amount);
        }
        return returnVal;
    }

    public KualiDecimal getTotalDirectFandADistributionIndirectCostAmount() {
        KualiDecimal returnVal = new KualiDecimal(0.0);
        for (AwardDirectFandADistribution awardDirectFandADistribution : this.awardDirectFandADistributions) {
            KualiDecimal amount = awardDirectFandADistribution.getIndirectCost() != null ? awardDirectFandADistribution.getIndirectCost() : new KualiDecimal(0.0);
            returnVal = (KualiDecimal)returnVal.add((AbstractKualiDecimal)amount);
        }
        return returnVal;
    }

    public KualiDecimal getTotalDirectFandADistributionAnticipatedCostAmount() {
        KualiDecimal returnVal = new KualiDecimal(0.0);
        returnVal = (KualiDecimal)returnVal.add((AbstractKualiDecimal)this.getTotalDirectFandADistributionDirectCostAmount());
        returnVal = (KualiDecimal)returnVal.add((AbstractKualiDecimal)this.getTotalDirectFandADistributionIndirectCostAmount());
        return returnVal;
    }

    public KualiDecimal getTotalApprovedSubawardAmount() {
        return this.getTotalAmount(this.awardApprovedSubawards);
    }

    public KualiDecimal getTotalApprovedEquipmentAmount() {
        return this.getTotalAmount(this.approvedEquipmentItems);
    }

    public KualiDecimal getTotalApprovedApprovedForeignTravelAmount() {
        return this.getTotalAmount(this.approvedForeignTravelTrips);
    }

    public List<AwardFandaRate> getAwardFandaRate() {
        return this.awardFandaRate;
    }

    public void setAwardFandaRate(List<AwardFandaRate> awardFandaRate) {
        this.awardFandaRate = awardFandaRate;
    }

    @Override
    public List<AwardScienceKeyword> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<AwardScienceKeyword> keywords) {
        this.keywords = keywords;
    }

    public void setLeadUnit(Unit leadUnit) {
        this.leadUnit = leadUnit;
        this.unitNumber = leadUnit != null ? leadUnit.getUnitNumber() : null;
    }

    public void setUnitNumber(String unitNumber) {
        this.unitNumber = unitNumber;
    }

    @Override
    public void addKeyword(ScienceKeyword scienceKeyword) {
        AwardScienceKeyword awardScienceKeyword = new AwardScienceKeyword(this.getAwardId(), scienceKeyword);
        this.getKeywords().add(awardScienceKeyword);
    }

    @Override
    public AwardScienceKeyword getKeyword(int index) {
        return this.getKeywords().get(index);
    }

    public void setSpecialReviews(List<AwardSpecialReview> awardSpecialReviews) {
        this.specialReviews = awardSpecialReviews;
    }

    public void addSpecialReview(AwardSpecialReview specialReview) {
        specialReview.setSequenceOwner(this);
        this.getSpecialReviews().add(specialReview);
    }

    public AwardSpecialReview getSpecialReview(int index) {
        return this.getSpecialReviews().get(index);
    }

    public List<AwardSpecialReview> getSpecialReviews() {
        return this.specialReviews;
    }

    public void add(AwardApprovedEquipment approvedEquipmentItem) {
        this.approvedEquipmentItems.add(0, approvedEquipmentItem);
        approvedEquipmentItem.setAward(this);
    }

    public void add(AwardFandaRate fandaRate) {
        this.awardFandaRate.add(fandaRate);
        fandaRate.setAward(this);
    }

    public void add(AwardSpecialReview awardSpecialReview) {
        this.specialReviews.add(awardSpecialReview);
        awardSpecialReview.setSequenceOwner(this);
    }

    public void add(AwardSponsorContact awardSponsorContact) {
        this.sponsorContacts.add(awardSponsorContact);
        awardSponsorContact.setAward(this);
    }

    public void add(AwardReportTerm awardReportTerm) {
        this.awardReportTermItems.add(awardReportTerm);
        awardReportTerm.setAward(this);
    }

    public void add(AwardCloseout awardCloseoutItem) {
        this.awardCloseoutNewItems.clear();
        if (this.awardCloseoutItems != null && this.awardCloseoutItems.size() > 5) {
            for (int i = 5; i < this.awardCloseoutItems.size(); ++i) {
                this.awardCloseoutNewItems.add(this.awardCloseoutItems.get(i));
            }
        }
        this.awardCloseoutItems.removeAll(this.awardCloseoutNewItems);
        this.awardCloseoutNewItems.add(awardCloseoutItem);
        Collections.sort(this.awardCloseoutNewItems, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof AwardCloseout && o2 instanceof AwardCloseout) {
                    AwardCloseout awardCloseout1 = (AwardCloseout)o1;
                    AwardCloseout awardCloseout2 = (AwardCloseout)o2;
                    return awardCloseout1.getCloseoutReportName().compareTo(awardCloseout2.getCloseoutReportName());
                }
                return 0;
            }
        });
        this.awardCloseoutItems.addAll(5, this.awardCloseoutNewItems);
        awardCloseoutItem.setAward(this);
    }

    public void addStaticCloseout(AwardCloseout awardCloseoutItem) {
        this.awardCloseoutItems.add(awardCloseoutItem);
        awardCloseoutItem.setAward(this);
    }

    public void add(AwardUnitContact awardUnitContact) {
        this.awardUnitContacts.add(awardUnitContact);
        awardUnitContact.setAward(this);
    }

    public void add(InstitutionalProposal institutionalProposal) {
        if (institutionalProposal != null) {
            AwardFundingProposal afp = new AwardFundingProposal(this, institutionalProposal);
            this.fundingProposals.add(afp);
            institutionalProposal.add(afp);
        }
    }

    public void addSponsorContact(AwardSponsorContact awardSponsorContact) {
        this.sponsorContacts.add(awardSponsorContact);
        awardSponsorContact.setAward(this);
    }

    public void add(AwardPerson projectPerson) {
        this.projectPersons.add(projectPerson);
        projectPerson.setAward(this);
    }

    public void add(AwardPaymentSchedule paymentScheduleItem) {
        this.paymentScheduleItems.add(paymentScheduleItem);
        paymentScheduleItem.setAward(this);
    }

    public void addAwardTransferringSponsor(Sponsor sponsor) {
        AwardTransferringSponsor awardTransferringSponsor = new AwardTransferringSponsor(this, sponsor);
        this.awardTransferringSponsors.add(0, awardTransferringSponsor);
    }

    protected void initializeCollections() {
        this.setAwardCostShares(new ArrayList<AwardCostShare>());
        this.setAwardComments(new ArrayList<AwardComment>());
        this.awardApprovedSubawards = new ArrayList<AwardApprovedSubaward>();
        this.setAwardFandaRate(new ArrayList<AwardFandaRate>());
        this.setAwardReportTermItems(new ArrayList<AwardReportTerm>());
        this.keywords = new ArrayList<AwardScienceKeyword>();
        this.specialReviews = new ArrayList<AwardSpecialReview>();
        this.approvedEquipmentItems = new ArrayList<AwardApprovedEquipment>();
        this.approvedForeignTravelTrips = new ArrayList<AwardApprovedForeignTravel>();
        this.setAwardSponsorTerms(new ArrayList<AwardSponsorTerm>());
        this.paymentScheduleItems = new ArrayList<AwardPaymentSchedule>();
        this.awardTransferringSponsors = new ArrayList<AwardTransferringSponsor>();
        this.awardDirectFandADistributions = new ArrayList<AwardDirectFandADistribution>();
        this.awardCustomDataList = new ArrayList<AwardCustomData>();
        this.awardCloseoutItems = new ArrayList<AwardCloseout>();
        this.awardCloseoutNewItems = new ArrayList<AwardCloseout>();
        this.awardNotepads = new ArrayList<AwardNotepad>();
        this.initializeAwardAmountInfoObjects();
        this.projectPersons = new ArrayList<AwardPerson>();
        this.awardUnitContacts = new ArrayList<AwardUnitContact>();
        this.sponsorContacts = new ArrayList<AwardSponsorContact>();
        this.awardBudgetLimits = new ArrayList<AwardBudgetLimit>();
        this.fundingProposals = new ArrayList<AwardFundingProposal>();
        this.initializeAwardHierarchyTempObjects();
        this.syncChanges = new ArrayList<AwardSyncChange>();
        this.syncStatuses = new ArrayList<AwardSyncStatus>();
        this.subAwardList = new ArrayList<SubAward>();
    }

    public void initializeAwardAmountInfoObjects() {
        this.awardAmountInfos = new ArrayList<AwardAmountInfo>();
        AwardAmountInfo awardAmountInfo = new AwardAmountInfo();
        awardAmountInfo.setAward(this);
        awardAmountInfo.setOriginatingAwardVersion(1);
        this.awardAmountInfos.add(awardAmountInfo);
    }

    public void initializeAwardHierarchyTempObjects() {
        this.awardHierarchyTempObjects = new AutoPopulatingList(AwardHierarchyTempObject.class);
    }

    public KualiDecimal getPreAwardInstitutionalAuthorizedAmount() {
        return this.preAwardInstitutionalAuthorizedAmount;
    }

    public void setPreAwardInstitutionalAuthorizedAmount(KualiDecimal preAwardInstitutionalAuthorizedAmount) {
        this.preAwardInstitutionalAuthorizedAmount = preAwardInstitutionalAuthorizedAmount != null && preAwardInstitutionalAuthorizedAmount.isNegative() ? (KualiDecimal)KualiDecimal.ZERO.subtract((AbstractKualiDecimal)preAwardInstitutionalAuthorizedAmount) : preAwardInstitutionalAuthorizedAmount;
    }

    public java.sql.Date getPreAwardInstitutionalEffectiveDate() {
        return this.preAwardInstitutionalEffectiveDate;
    }

    public void setPreAwardInstitutionalEffectiveDate(java.sql.Date preAwardInstitutionalEffectiveDate) {
        this.preAwardInstitutionalEffectiveDate = preAwardInstitutionalEffectiveDate;
    }

    public void add(AwardCostShare awardCostShare) {
        this.awardCostShares.add(awardCostShare);
        awardCostShare.setAward(this);
    }

    public void add(AwardApprovedSubaward awardApprovedSubaward) {
        this.awardApprovedSubawards.add(awardApprovedSubaward);
        awardApprovedSubaward.setAward(this);
    }

    public void add(AwardComment awardComment) {
        this.awardComments.add(awardComment);
        awardComment.setAward(this);
    }

    public void addTemplateComments(List<AwardTemplateComment> awardTemplateComments) {
        AwardCommentFactory awardCommentFactory = new AwardCommentFactory();
        for (AwardTemplateComment awardTemplateComment : awardTemplateComments) {
            AwardComment testAwardComment = this.getCommentMap().get(awardTemplateComment.getCommentTypeCode());
            if (testAwardComment == null) {
                AwardComment awardComment = awardCommentFactory.createAwardComment(awardTemplateComment.getCommentTypeCode(), awardTemplateComment.getChecklistPrintFlag());
                awardComment.setComments(awardTemplateComment.getComments());
                this.add(awardComment);
                this.commentMap.put(awardComment.getCommentType().getCommentTypeCode(), awardComment);
                continue;
            }
            testAwardComment.setComments(awardTemplateComment.getComments());
        }
    }

    public void add(AwardSponsorTerm awardSponsorTerm) {
        this.awardSponsorTerms.add(awardSponsorTerm);
        awardSponsorTerm.setAward(this);
    }

    public void addTemplateTerms(List<AwardTemplateTerm> awardTemplateTerms) {
        ArrayList<AwardSponsorTerm> tempAwardSponsorTerms = new ArrayList<AwardSponsorTerm>();
        for (AwardTemplateTerm awardTemplateTerm : awardTemplateTerms) {
            tempAwardSponsorTerms.add(new AwardSponsorTerm(awardTemplateTerm.getSponsorTermId(), awardTemplateTerm.getSponsorTerm()));
        }
        this.setAwardSponsorTerms(tempAwardSponsorTerms);
    }

    public void add(AwardDirectFandADistribution awardDirectFandADistribution) {
        this.awardDirectFandADistributions.add(awardDirectFandADistribution);
        awardDirectFandADistribution.setAward(this);
        awardDirectFandADistribution.setBudgetPeriod(this.awardDirectFandADistributions.size());
    }

    public void add(int index, AwardDirectFandADistribution awardDirectFandADistribution) {
        this.awardDirectFandADistributions.add(index, awardDirectFandADistribution);
        awardDirectFandADistribution.setAward(this);
        awardDirectFandADistribution.setBudgetPeriod(index + 1);
        this.updateDirectFandADistributionBudgetPeriods(index + 1);
    }

    public void add(AwardNotepad awardNotepad) {
        awardNotepad.setEntryNumber(this.awardNotepads.size() + 1);
        awardNotepad.setAwardNumber(this.getAwardNumber());
        this.awardNotepads.add(awardNotepad);
        awardNotepad.setAward(this);
    }

    public void updateDirectFandADistributionBudgetPeriods(int index) {
        for (int newIndex = index; newIndex < this.awardDirectFandADistributions.size(); ++newIndex) {
            this.awardDirectFandADistributions.get(newIndex).setBudgetPeriod(newIndex + 1);
        }
    }

    KualiDecimal getTotalAmount(List<? extends ValuableItem> valuableItems) {
        KualiDecimal returnVal = new KualiDecimal(0.0);
        for (ValuableItem valuableItem : valuableItems) {
            KualiDecimal amount = valuableItem.getAmount() != null ? valuableItem.getAmount() : new KualiDecimal(0.0);
            returnVal = (KualiDecimal)returnVal.add((AbstractKualiDecimal)amount);
        }
        return returnVal;
    }

    public List<AwardSponsorTerm> getAwardSponsorTerms() {
        return this.awardSponsorTerms;
    }

    public AwardStatus getAwardStatus() {
        if (this.awardStatus == null && this.statusCode != null) {
            this.refreshReferenceObject("awardStatus");
        }
        return this.awardStatus;
    }

    public void setAwardSponsorTerms(List<AwardSponsorTerm> awardSponsorTerms) {
        this.awardSponsorTerms = awardSponsorTerms;
    }

    public Sponsor getSponsor() {
        if (!StringUtils.isEmpty((String)this.sponsorCode)) {
            this.refreshReferenceObject("sponsor");
        }
        return this.sponsor;
    }

    public List<AwardSponsorContact> getSponsorContacts() {
        return this.sponsorContacts;
    }

    public void setSponsorContacts(List<AwardSponsorContact> awardSponsorContacts) {
        this.sponsorContacts = awardSponsorContacts;
    }

    public void setSponsor(Sponsor sponsor) {
        this.sponsor = sponsor;
        this.sponsorCode = sponsor != null ? sponsor.getSponsorCode() : null;
    }

    @Override
    public String getSponsorName() {
        Sponsor sponsor = this.getSponsor();
        this.sponsorName = sponsor != null ? sponsor.getSponsorName() : null;
        return this.sponsorName;
    }

    public String getIcrRateCode() {
        return this.icrRateCode;
    }

    public void setIcrRateCode(String icrRateCode) {
        this.icrRateCode = icrRateCode;
    }

    public void add(AwardApprovedForeignTravel approvedForeignTravelTrip) {
        this.approvedForeignTravelTrips.add(approvedForeignTravelTrip);
        approvedForeignTravelTrip.setAward(this);
    }

    public List<AwardPaymentSchedule> getPaymentScheduleItems() {
        return this.paymentScheduleItems;
    }

    public void setPaymentScheduleItems(List<AwardPaymentSchedule> paymentScheduleItems) {
        this.paymentScheduleItems = paymentScheduleItems;
    }

    public KualiDecimal getTotalPaymentScheduleAmount() {
        KualiDecimal amount = KualiDecimal.ZERO;
        for (AwardPaymentSchedule schedule : this.paymentScheduleItems) {
            if (schedule.getAmount() == null) continue;
            amount = (KualiDecimal)amount.add((AbstractKualiDecimal)schedule.getAmount());
        }
        return amount;
    }

    public Sponsor getPrimeSponsor() {
        if (!StringUtils.isEmpty((String)this.getPrimeSponsorCode())) {
            this.refreshReferenceObject("primeSponsor");
        }
        return this.primeSponsor;
    }

    public void setPrimeSponsor(Sponsor primeSponsor) {
        this.primeSponsor = primeSponsor;
    }

    public List<AwardTransferringSponsor> getAwardTransferringSponsors() {
        return this.awardTransferringSponsors;
    }

    public void setAwardStatus(AwardStatus awardStatus) {
        this.awardStatus = awardStatus;
    }

    public void setAwardTransferringSponsors(List<AwardTransferringSponsor> awardTransferringSponsors) {
        this.awardTransferringSponsors = awardTransferringSponsors;
    }

    public List<AwardDirectFandADistribution> getAwardDirectFandADistributions() {
        return this.awardDirectFandADistributions;
    }

    public void setAwardDirectFandADistributions(List<AwardDirectFandADistribution> awardDirectFandADistributions) {
        for (AwardDirectFandADistribution awardDirectFandADistribution : awardDirectFandADistributions) {
            awardDirectFandADistribution.setAward(this);
        }
        this.awardDirectFandADistributions = awardDirectFandADistributions;
    }

    public List<AwardNotepad> getAwardNotepads() {
        return this.awardNotepads;
    }

    public void setAwardNotepads(List<AwardNotepad> awardNotepads) {
        this.awardNotepads = awardNotepads;
    }

    public String getIndirectCostIndicator() {
        return this.indirectCostIndicator;
    }

    public void setIndirectCostIndicator(String indirectCostIndicator) {
        this.indirectCostIndicator = indirectCostIndicator;
    }

    public KualiDecimal getObligatedTotal() {
        KualiDecimal returnValue = new KualiDecimal(0.0);
        if (this.getLastAwardAmountInfo().getAmountObligatedToDate() != null) {
            returnValue = (KualiDecimal)returnValue.add((AbstractKualiDecimal)this.getLastAwardAmountInfo().getAmountObligatedToDate());
        }
        return returnValue;
    }

    public KualiDecimal getObligatedDistributableTotal() {
        KualiDecimal returnValue = KualiDecimal.ZERO;
        if (this.getLastAwardAmountInfo().getObliDistributableAmount() != null) {
            returnValue = this.getLastAwardAmountInfo().getObliDistributableAmount();
        }
        return returnValue;
    }

    public KualiDecimal getBudgetTotalCostLimit() {
        KualiDecimal limit = this.getTotalCostBudgetLimit();
        KualiDecimal obliTotal = this.getObligatedDistributableTotal();
        if (limit != null && limit.isLessEqual((AbstractKualiDecimal)obliTotal)) {
            return limit;
        }
        return obliTotal;
    }

    public KualiDecimal getObligatedTotalDirect() {
        KualiDecimal returnValue = new KualiDecimal(0.0);
        if (this.getLastAwardAmountInfo().getObligatedTotalDirect() != null) {
            returnValue = (KualiDecimal)returnValue.add((AbstractKualiDecimal)this.getLastAwardAmountInfo().getObligatedTotalDirect());
        }
        return returnValue;
    }

    public KualiDecimal getObligatedTotalIndirect() {
        KualiDecimal returnValue = new KualiDecimal(0.0);
        if (this.getLastAwardAmountInfo().getObligatedTotalIndirect() != null) {
            returnValue = (KualiDecimal)returnValue.add((AbstractKualiDecimal)this.getLastAwardAmountInfo().getObligatedTotalIndirect());
        }
        return returnValue;
    }

    public KualiDecimal getAnticipatedTotal() {
        KualiDecimal returnValue = new KualiDecimal(0.0);
        if (this.getLastAwardAmountInfo().getAnticipatedTotalAmount() != null) {
            returnValue = (KualiDecimal)returnValue.add((AbstractKualiDecimal)this.getLastAwardAmountInfo().getAnticipatedTotalAmount());
        }
        return returnValue;
    }

    public KualiDecimal getAnticipatedTotalDirect() {
        KualiDecimal returnValue = new KualiDecimal(0.0);
        if (this.getLastAwardAmountInfo().getAnticipatedTotalDirect() != null) {
            returnValue = (KualiDecimal)returnValue.add((AbstractKualiDecimal)this.getLastAwardAmountInfo().getAnticipatedTotalDirect());
        }
        return returnValue;
    }

    public KualiDecimal getAnticipatedTotalIndirect() {
        KualiDecimal returnValue = new KualiDecimal(0.0);
        if (this.getLastAwardAmountInfo().getAnticipatedTotalIndirect() != null) {
            returnValue = (KualiDecimal)returnValue.add((AbstractKualiDecimal)this.getLastAwardAmountInfo().getAnticipatedTotalIndirect());
        }
        return returnValue;
    }

    @Override
    public String getDocumentNumberForPermission() {
        return this.awardId != null ? this.awardId.toString() : BLANK_COMMENT;
    }

    @Override
    public String getDocumentKey() {
        return "award";
    }

    @Override
    public List<String> getRoleNames() {
        ArrayList<String> roles = new ArrayList<String>();
        SystemAuthorizationService systemAuthorizationService = (SystemAuthorizationService)KraServiceLocator.getService("systemAuthorizationService");
        List<Role> roleBOs = systemAuthorizationService.getRoles("KC-AWARD");
        for (Role role : roleBOs) {
            roles.add(role.getName());
        }
        return roles;
    }

    public List<AwardAmountInfo> getAwardAmountInfos() {
        return this.awardAmountInfos;
    }

    public void setAwardAmountInfos(List<AwardAmountInfo> awardAmountInfos) {
        this.awardAmountInfos = awardAmountInfos;
    }

    public Unit getLeadUnit() {
        if (this.leadUnit == null && this.unitNumber != null) {
            this.loadLeadUnit();
        }
        return this.leadUnit;
    }

    public boolean isNew() {
        return this.awardId == null;
    }

    public List<AwardReportTerm> getAwardReportTermItems() {
        Collections.sort(this.awardReportTermItems, new ARTComparator());
        return this.awardReportTermItems;
    }

    public void setAwardReportTermItems(List<AwardReportTerm> awardReportTermItems) {
        this.awardReportTermItems = awardReportTermItems;
    }

    public AwardPerson getPrincipalInvestigator() {
        AwardPerson principleInvestigator = null;
        for (AwardPerson person : this.projectPersons) {
            if (!person.isPrincipalInvestigator()) continue;
            principleInvestigator = person;
            break;
        }
        return principleInvestigator;
    }

    public String getPrincipalInvestigatorName() {
        AwardPerson pi = this.getPrincipalInvestigator();
        if (pi != null) {
            this.principalInvestigatorName = pi.getIsRolodexPerson() ? pi.getRolodex().getOrganization() : pi.getFullName();
        }
        return this.principalInvestigatorName;
    }

    public void setPrincipalInvestigatorName(String principalInvestigatorName) {
        this.principalInvestigatorName = principalInvestigatorName;
    }

    public String getStatusDescription() {
        AwardStatus status = this.getAwardStatus();
        this.statusDescription = status != null ? status.getDescription() : null;
        return this.statusDescription;
    }

    public List<AwardCustomData> getAwardCustomDataList() {
        return this.awardCustomDataList;
    }

    public void setAwardCustomDataList(List<AwardCustomData> awardCustomDataList) {
        this.awardCustomDataList = awardCustomDataList;
    }

    public List<AwardCloseout> getAwardCloseoutItems() {
        return this.awardCloseoutItems;
    }

    public void setAwardCloseoutItems(List<AwardCloseout> awardCloseoutItems) {
        if (awardCloseoutItems != null && awardCloseoutItems.size() > 5) {
            int i;
            this.awardCloseoutNewItems.clear();
            for (i = 5; i < awardCloseoutItems.size(); ++i) {
                this.awardCloseoutNewItems.add(awardCloseoutItems.get(i));
            }
            for (i = awardCloseoutItems.size(); i > 5; --i) {
                awardCloseoutItems.remove(i - 1);
            }
            Collections.sort(this.awardCloseoutNewItems, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof AwardCloseout && o2 instanceof AwardCloseout) {
                        AwardCloseout awardCloseout1 = (AwardCloseout)o1;
                        AwardCloseout awardCloseout2 = (AwardCloseout)o2;
                        return awardCloseout1.getCloseoutReportName().compareTo(awardCloseout2.getCloseoutReportName());
                    }
                    return 0;
                }
            });
            awardCloseoutItems.addAll(5, this.awardCloseoutNewItems);
        }
        this.awardCloseoutItems = awardCloseoutItems;
    }

    public List<AwardCloseout> getAwardCloseoutNewItems() {
        return this.awardCloseoutNewItems;
    }

    public void setAwardCloseoutNewItems(List<AwardCloseout> awardCloseoutNewItems) {
        this.awardCloseoutNewItems = awardCloseoutNewItems;
    }

    public void setTemplateCode(Integer templateCode) {
        this.templateCode = templateCode;
    }

    @Override
    public String getPrimeSponsorCode() {
        return this.primeSponsorCode;
    }

    public void setPrimeSponsorCode(String primeSponsorCode) {
        this.primeSponsorCode = primeSponsorCode;
    }

    public String getBasisOfPaymentCode() {
        return this.basisOfPaymentCode;
    }

    public void setBasisOfPaymentCode(String basisOfPaymentCode) {
        this.basisOfPaymentCode = basisOfPaymentCode;
    }

    public String getMethodOfPaymentCode() {
        return this.methodOfPaymentCode;
    }

    public void setMethodOfPaymentCode(String methodOfPaymentCode) {
        this.methodOfPaymentCode = methodOfPaymentCode;
    }

    public AwardTemplate getAwardTemplate() {
        return this.awardTemplate;
    }

    public void setAwardTemplate(AwardTemplate awardTemplate) {
        this.awardTemplate = awardTemplate;
    }

    public AwardBasisOfPayment getAwardBasisOfPayment() {
        return this.awardBasisOfPayment;
    }

    public void setAwardBasisOfPayment(AwardBasisOfPayment awardBasisOfPayment) {
        this.awardBasisOfPayment = awardBasisOfPayment;
    }

    public AwardMethodOfPayment getAwardMethodOfPayment() {
        return this.awardMethodOfPayment;
    }

    public void setAwardMethodOfPayment(AwardMethodOfPayment awardMethodOfPayment) {
        this.awardMethodOfPayment = awardMethodOfPayment;
    }

    @Override
    public Integer getOwnerSequenceNumber() {
        return null;
    }

    @Override
    public void incrementSequenceNumber() {
        Award award = this;
        Integer n = award.sequenceNumber;
        Integer n2 = award.sequenceNumber = Integer.valueOf(award.sequenceNumber + 1);
    }

    @Override
    public Award getSequenceOwner() {
        return this;
    }

    @Override
    public void setSequenceOwner(Award newOwner) {
    }

    @Override
    public void resetPersistenceState() {
        this.awardId = null;
    }

    @Override
    public String getVersionNameField() {
        return "awardNumber";
    }

    @Override
    public ActivityType getActivityType() {
        return this.activityType;
    }

    public void setActivityType(ActivityType activityType) {
        this.activityType = activityType;
    }

    public AwardFundingProposal removeFundingProposal(int index) {
        AwardFundingProposal afp = index >= 0 ? this.fundingProposals.remove(index) : null;
        afp.getProposalId();
        InstitutionalProposal proposal = this.getInstitutionalProposalService().getInstitutionalProposal(afp.getProposalId().toString());
        if (proposal != null) {
            proposal.remove(afp);
        }
        return afp;
    }

    private InstitutionalProposalService getInstitutionalProposalService() {
        return KraServiceLocator.getService(InstitutionalProposalService.class);
    }

    public AwardComment findCommentOfSpecifiedType(AwardComment template) {
        return this.findCommentOfSpecifiedType(template.getCommentTypeCode());
    }

    public AwardComment findCommentOfSpecifiedType(String commentTypeCode) {
        AwardComment comment = null;
        for (AwardComment ac : this.getAwardComments()) {
            if (!ac.getCommentTypeCode().equals(commentTypeCode)) continue;
            comment = ac;
            break;
        }
        return comment;
    }

    @Override
    public String getBudgetStatus() {
        return CLOSE_OUT_REPORT_TYPE_PROPERTY;
    }

    public List getPersonRolodexList() {
        return this.getProjectPersons();
    }

    @Override
    public PersonRolodex getProposalEmployee(String personId) {
        return this.getPerson(personId, true);
    }

    private PersonRolodex getPerson(String personId, boolean personFindFlag) {
        List<AwardPerson> awardPersons = this.getProjectPersons();
        for (AwardPerson awardPerson : awardPersons) {
            if (personId == null || !personId.equals(awardPerson.getPersonId())) continue;
            if (personFindFlag && awardPerson.isEmployee()) {
                return awardPerson;
            }
            return awardPerson;
        }
        return null;
    }

    @Override
    public ContactRole getProposalEmployeeRole(String personId) {
        if (this.getProposalEmployee(personId) != null) {
            return ((AwardPerson)this.getProposalEmployee(personId)).getContactRole();
        }
        return null;
    }

    @Override
    public PersonRolodex getProposalNonEmployee(Integer rolodexId) {
        List<AwardPerson> awardPersons = this.getProjectPersons();
        for (AwardPerson awardPerson : awardPersons) {
            if (!rolodexId.equals(awardPerson.getRolodexId())) continue;
            return awardPerson;
        }
        return null;
    }

    @Override
    public ContactRole getProposalNonEmployeeRole(Integer rolodexId) {
        if (this.getProposalNonEmployee(rolodexId) != null) {
            return ((AwardPerson)this.getProposalNonEmployee(rolodexId)).getContactRole();
        }
        return null;
    }

    @Override
    public java.sql.Date getRequestedEndDateInitial() {
        return this.getObligationExpirationDate();
    }

    @Override
    public java.sql.Date getRequestedStartDateInitial() {
        AwardAmountInfo awardAmountInfo = this.getLastAwardAmountInfo();
        return awardAmountInfo == null ? null : awardAmountInfo.getCurrentFundEffectiveDate();
    }

    @Override
    public Unit getUnit() {
        return this.getLeadUnit();
    }

    @Override
    public boolean isSponsorNihMultiplePi() {
        return this.sponsorNihMultiplePi;
    }

    @Override
    public void setBudgetStatus(String budgetStatus) {
    }

    public List<AwardAttachment> getAwardAttachments() {
        if (this.awardAttachments == null) {
            this.awardAttachments = new ArrayList<AwardAttachment>();
        }
        return this.awardAttachments;
    }

    public void setAttachments(List<AwardAttachment> attachments) {
        this.awardAttachments = attachments;
    }

    public AwardAttachment getAwardAttachment(int index) {
        return this.awardAttachments.get(index);
    }

    public void addAttachment(AwardAttachment attachment) {
        this.getAwardAttachments().add(attachment);
        attachment.setAward(this);
    }

    public boolean isPersisted() {
        return this.awardId != null;
    }

    public AwardApprovedSubaward getAwardApprovedSubawards(int index) {
        return this.getAwardApprovedSubawards().get(index);
    }

    @Override
    public String getNamespace() {
        return "KC-AWARD";
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return "KC-AWARD";
    }

    protected void loadLeadUnit() {
        this.leadUnit = (Unit)this.getBusinessObjectService().findByPrimaryKey(Unit.class, Collections.singletonMap("unitNumber", this.getUnitNumber()));
    }

    @Override
    public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
        String documentNumber = this.getAwardDocument() != null ? this.getAwardDocument().getDocumentNumber() : BLANK_COMMENT;
        qualifiedRoleAttributes.put("documentNumber", documentNumber);
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }

    @Override
    public String getHierarchyStatus() {
        return NO_FLAG;
    }

    public KualiDecimal calculateObligatedDistributedAmountTotal() {
        KualiDecimal sum = KualiDecimal.ZERO;
        for (AwardAmountInfo amountInfo : this.getAwardAmountInfos()) {
            KualiDecimal obligatedDistributableAmount = amountInfo.getObliDistributableAmount();
            sum = (KualiDecimal)sum.add((AbstractKualiDecimal)(obligatedDistributableAmount != null ? obligatedDistributableAmount : KualiDecimal.ZERO));
        }
        return sum;
    }

    public java.sql.Date findLatestFinalExpirationDate() {
        java.sql.Date latestExpDate = new java.sql.Date(new GregorianCalendar(1900, 0, 1).getTimeInMillis());
        for (AwardAmountInfo amountInfo : this.getAwardAmountInfos()) {
            java.sql.Date expDate = amountInfo.getFinalExpirationDate();
            if (expDate == null || !expDate.after(latestExpDate)) continue;
            latestExpDate = expDate;
        }
        return latestExpDate;
    }

    @Override
    public boolean isParentInHierarchyComplete() {
        return true;
    }

    @Override
    public String getDefaultBudgetStatusParameter() {
        return "awardBudgetStatusInProgress";
    }

    public List<AwardHierarchyTempObject> getAwardHierarchyTempObjects() {
        return this.awardHierarchyTempObjects;
    }

    public AwardHierarchyTempObject getAwardHierarchyTempObject(int index) {
        if (this.awardHierarchyTempObjects == null) {
            this.initializeAwardHierarchyTempObjects();
        }
        return this.awardHierarchyTempObjects.get(index);
    }

    public AwardType getAwardType() {
        return this.awardType;
    }

    public void setAwardType(AwardType awardType) {
        this.awardType = awardType;
    }

    public AwardComment getAwardComment(int index) {
        while (this.getAwardComments().size() <= index) {
            this.getAwardComments().add(new AwardComment());
        }
        return this.getAwardComments().get(index);
    }

    public String getDocIdStatus() {
        return this.docIdStatus;
    }

    public String getAwardIdAccount() {
        if (this.awardIdAccount == null) {
            this.awardIdAccount = StringUtils.isNotBlank((String)this.getAccountNumber()) ? this.getAwardNumber() + ":" + this.getAccountNumber() : this.getAwardNumber() + ":";
        }
        return this.awardIdAccount;
    }

    public void setLookupOspAdministratorName(String lookupOspAdministratorName) {
        this.lookupOspAdministratorName = lookupOspAdministratorName;
    }

    public String getLookupOspAdministratorName() {
        return this.lookupOspAdministratorName;
    }

    public List<AwardUnitContact> getCentralAdminContacts() {
        if (this.centralAdminContacts == null) {
            this.initCentralAdminContacts();
        }
        return this.centralAdminContacts;
    }

    public void initCentralAdminContacts() {
        this.centralAdminContacts = new ArrayList<AwardUnitContact>();
        List<UnitAdministrator> unitAdministrators = KraServiceLocator.getService(UnitService.class).retrieveUnitAdministratorsByUnitNumber(this.getUnitNumber());
        for (UnitAdministrator unitAdministrator : unitAdministrators) {
            if (!unitAdministrator.getUnitAdministratorType().getDefaultGroupFlag().equals(DEFAULT_GROUP_CODE_FOR_CENTRAL_ADMIN_CONTACTS)) continue;
            KcPerson person = this.getKcPersonService().getKcPersonByPersonId(unitAdministrator.getPersonId());
            AwardUnitContact newAwardUnitContact = new AwardUnitContact();
            newAwardUnitContact.setAward(this);
            newAwardUnitContact.setPerson(person);
            newAwardUnitContact.setUnitAdministratorType(unitAdministrator.getUnitAdministratorType());
            newAwardUnitContact.setFullName(person.getFullName());
            this.centralAdminContacts.add(newAwardUnitContact);
        }
    }

    public boolean isAwardInMultipleNodeHierarchy() {
        return this.awardInMultipleNodeHierarchy;
    }

    public void setAwardInMultipleNodeHierarchy(boolean awardInMultipleNodeHierarchy) {
        this.awardInMultipleNodeHierarchy = awardInMultipleNodeHierarchy;
    }

    public boolean isAwardHasAssociatedTandMOrIsVersioned() {
        return this.awardHasAssociatedTandMOrIsVersioned;
    }

    public void setAwardHasAssociatedTandMOrIsVersioned(boolean awardHasAssociatedTandMOrIsVersioned) {
        this.awardHasAssociatedTandMOrIsVersioned = awardHasAssociatedTandMOrIsVersioned;
    }

    public boolean isSyncChild() {
        return this.syncChild;
    }

    public void setSyncChild(boolean syncChild) {
        this.syncChild = syncChild;
    }

    public List<AwardSyncChange> getSyncChanges() {
        return this.syncChanges;
    }

    public void setSyncChanges(List<AwardSyncChange> syncChanges) {
        this.syncChanges = syncChanges;
    }

    public List<AwardSyncStatus> getSyncStatuses() {
        return this.syncStatuses;
    }

    public void setSyncStatuses(List<AwardSyncStatus> syncStatuses) {
        this.syncStatuses = syncStatuses;
    }

    public void setSponsorNihMultiplePi(boolean sponsorNihMultiplePi) {
        this.sponsorNihMultiplePi = sponsorNihMultiplePi;
    }

    public boolean isActiveVersion() {
        return reportedStatus.indexOf(this.getAwardStatus().getStatusCode()) != -1;
    }

    public List<AwardBudgetLimit> getAwardBudgetLimits() {
        return this.awardBudgetLimits;
    }

    public void setAwardBudgetLimits(List<AwardBudgetLimit> awardBudgetLimits) {
        this.awardBudgetLimits = awardBudgetLimits;
    }

    public KualiDecimal getTotalCostBudgetLimit() {
        return this.getSpecificBudgetLimit(AwardBudgetLimit.LIMIT_TYPE.TOTAL_COST).getLimit();
    }

    public KualiDecimal getDirectCostBudgetLimit() {
        return this.getSpecificBudgetLimit(AwardBudgetLimit.LIMIT_TYPE.DIRECT_COST).getLimit();
    }

    public KualiDecimal getIndirectCostBudgetLimit() {
        return this.getSpecificBudgetLimit(AwardBudgetLimit.LIMIT_TYPE.INDIRECT_COST).getLimit();
    }

    protected AwardBudgetLimit getSpecificBudgetLimit(AwardBudgetLimit.LIMIT_TYPE type) {
        for (AwardBudgetLimit limit : this.getAwardBudgetLimits()) {
            if (limit.getLimitType() != type) continue;
            return limit;
        }
        return new AwardBudgetLimit(type);
    }

    public List<Boolean> getAwardCommentHistoryFlags() {
        return this.awardCommentHistoryFlags;
    }

    public void setAwardCommentHistoryFlags(List<Boolean> awardCommentHistoryFlags) {
        this.awardCommentHistoryFlags = awardCommentHistoryFlags;
    }

    public void orderStaticCloseOutReportItems(List<AwardCloseout> awardCloseoutItems) {
        if (awardCloseoutItems != null && awardCloseoutItems.size() == 5) {
            this.awardCloseoutNewItems.clear();
            ArrayList<AwardCloseout> staticCloseoutItems = new ArrayList<AwardCloseout>();
            for (int i = 0; i < 5; ++i) {
                staticCloseoutItems.add(awardCloseoutItems.get(i));
                this.awardCloseoutNewItems.add(awardCloseoutItems.get(i));
            }
            awardCloseoutItems.removeAll(staticCloseoutItems);
            for (AwardCloseout awardCloseout : staticCloseoutItems) {
                if (awardCloseout.getCloseoutReportCode() != null && awardCloseout.getCloseoutReportCode().equalsIgnoreCase(CLOSE_OUT_REPORT_TYPE_FINANCIAL_REPORT)) {
                    this.awardCloseoutNewItems.remove(awardCloseout);
                    this.awardCloseoutNewItems.add(0, awardCloseout);
                    continue;
                }
                if (awardCloseout.getCloseoutReportCode() != null && awardCloseout.getCloseoutReportCode().equalsIgnoreCase(CLOSE_OUT_REPORT_TYPE_TECHNICAL)) {
                    this.awardCloseoutNewItems.remove(awardCloseout);
                    this.awardCloseoutNewItems.add(1, awardCloseout);
                    continue;
                }
                if (awardCloseout.getCloseoutReportCode() != null && awardCloseout.getCloseoutReportCode().equalsIgnoreCase(CLOSE_OUT_REPORT_TYPE_PATENT)) {
                    this.awardCloseoutNewItems.remove(awardCloseout);
                    this.awardCloseoutNewItems.add(2, awardCloseout);
                    continue;
                }
                if (awardCloseout.getCloseoutReportCode() != null && awardCloseout.getCloseoutReportCode().equalsIgnoreCase(CLOSE_OUT_REPORT_TYPE_PROPERTY)) {
                    this.awardCloseoutNewItems.remove(awardCloseout);
                    this.awardCloseoutNewItems.add(3, awardCloseout);
                    continue;
                }
                if (awardCloseout.getCloseoutReportCode() == null || !awardCloseout.getCloseoutReportCode().equalsIgnoreCase(CLOSE_OUT_REPORT_TYPE_INVOICE)) continue;
                this.awardCloseoutNewItems.remove(awardCloseout);
                this.awardCloseoutNewItems.add(4, awardCloseout);
            }
            awardCloseoutItems.addAll(0, this.awardCloseoutNewItems);
        }
    }

    @Override
    public String getLeadUnitName() {
        String name = this.getLeadUnit() == null ? BLANK_COMMENT : this.getLeadUnit().getUnitName();
        return name;
    }

    @Override
    public String getPiName() {
        return this.getPiEmployeeName();
    }

    @Override
    public String getPiEmployeeName() {
        return this.getPrincipalInvestigatorName();
    }

    @Override
    public String getPiNonEmployeeName() {
        return BLANK_COMMENT;
    }

    @Override
    public String getAdminPersonName() {
        return BLANK_COMMENT;
    }

    @Override
    public String getPrimeSponsorName() {
        String name = this.getPrimeSponsor() == null ? BLANK_COMMENT : this.getPrimeSponsor().getSponsorName();
        return name;
    }

    @Override
    public String getSubAwardOrganizationName() {
        return BLANK_COMMENT;
    }

    @Override
    public List<NegotiationPersonDTO> getProjectPeople() {
        ArrayList<NegotiationPersonDTO> kcPeople = new ArrayList<NegotiationPersonDTO>();
        for (AwardPerson person : this.getProjectPersons()) {
            kcPeople.add(new NegotiationPersonDTO(person.getPerson(), person.getContactRoleCode()));
        }
        return kcPeople;
    }

    @Override
    public String getNegotiableProposalTypeCode() {
        return BLANK_COMMENT;
    }

    @Override
    public String getParentNumber() {
        return this.getAwardNumber();
    }

    @Override
    public String getParentPIName() {
        String investigatorName = null;
        for (AwardPerson aPerson : this.getProjectPersons()) {
            if (aPerson == null || !aPerson.isPrincipalInvestigator()) continue;
            investigatorName = aPerson.getFullName();
            break;
        }
        return investigatorName;
    }

    @Override
    public String getParentTitle() {
        return this.getTitle();
    }

    @Override
    public String getIsOwnedByUnit() {
        return this.getLeadUnitName();
    }

    @Override
    public Integer getParentInvestigatorFlag(String personId, Integer flag) {
        for (AwardPerson aPerson : this.getProjectPersons()) {
            if ((aPerson.getPersonId() == null || !aPerson.getPersonId().equals(personId)) && (aPerson.getRolodexId() == null || !aPerson.getRolodexId().equals(personId))) continue;
            flag = 2;
            if (!aPerson.isPrincipalInvestigator()) continue;
            flag = 1;
            break;
        }
        return flag;
    }

    public AwardFandaRate getCurrentFandaRate() {
        List<AwardFandaRate> rates = this.getAwardFandaRate();
        Calendar calendar = Calendar.getInstance();
        int currentYear = calendar.get(1);
        KualiDecimal currentRateValue = new KualiDecimal(0.0);
        AwardFandaRate currentFandaRate = rates.get(0);
        for (AwardFandaRate rate : rates) {
            if (Integer.parseInt(rate.getFiscalYear()) != currentYear || !rate.getApplicableFandaRate().isGreaterThan((AbstractKualiDecimal)currentRateValue)) continue;
            currentFandaRate = rate;
            currentRateValue = rate.getApplicableFandaRate();
        }
        return currentFandaRate;
    }

    @Override
    public String getParentTypeName() {
        return "Award";
    }

    @Override
    public String getAssociatedDocumentId() {
        return this.getAwardNumber();
    }

    public String getAwardSequenceStatus() {
        return this.awardSequenceStatus;
    }

    public void setAwardSequenceStatus(String awardSequenceStatus) {
        this.awardSequenceStatus = awardSequenceStatus;
    }

    @Override
    public ProposalType getNegotiableProposalType() {
        return null;
    }

    @Override
    public String getSubAwardRequisitionerName() {
        return BLANK_COMMENT;
    }

    @Override
    public String getSubAwardRequisitionerUnitNumber() {
        return BLANK_COMMENT;
    }

    @Override
    public String getSubAwardRequisitionerUnitName() {
        return BLANK_COMMENT;
    }

    @Override
    public String getSubAwardRequisitionerId() {
        return BLANK_COMMENT;
    }

    public List<SubAward> getSubAwardList() {
        return this.subAwardList;
    }

    public void setSubAwardList(List<SubAward> subAwardList) {
        this.subAwardList = subAwardList;
    }

    @Override
    public String getProjectName() {
        return this.getTitle();
    }

    @Override
    public String getProjectId() {
        return this.getAwardNumber();
    }

    public boolean isAllowUpdateTimestampToBeReset() {
        return this.allowUpdateTimestampToBeReset;
    }

    public void setAllowUpdateTimestampToBeReset(boolean allowUpdateTimestampToBeReset) {
        this.allowUpdateTimestampToBeReset = allowUpdateTimestampToBeReset;
    }

    @Override
    public void setUpdateTimestamp(Timestamp updateTimestamp) {
        if (this.isAllowUpdateTimestampToBeReset()) {
            super.setUpdateTimestamp(updateTimestamp);
        } else {
            this.setAllowUpdateTimestampToBeReset(true);
        }
    }

    public List<Award> getAwardVersions() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("awardNumber", this.getAwardNumber());
        BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        List awards = (List)businessObjectService.findMatchingOrderBy(Award.class, fieldValues, "sequenceNumber", true);
        return awards;
    }

    public String getAwardDescriptionLine() {
        AwardAmountInfo aai = this.getLastAwardAmountInfo();
        String versionNumber = aai == null || aai.getOriginatingAwardVersion() == null ? this.getSequenceNumber().toString() : aai.getOriginatingAwardVersion().toString();
        String transactionTypeDescription = this.getAwardTransactionType() != null ? this.getAwardTransactionType().getDescription() : "None";
        return "Award Version " + versionNumber + ", " + transactionTypeDescription + ", updated " + this.getUpdateTimeAndUser();
    }

    public String getUpdateTimeAndUser() {
        String createDateStr = null;
        String updateUser = null;
        if (this.getUpdateTimestamp() != null) {
            createDateStr = CoreApiServiceLocator.getDateTimeService().toString((Date)this.getUpdateTimestamp(), "hh:mm a MM/dd/yyyy");
            updateUser = this.getUpdateUser().length() > 30 ? this.getUpdateUser().substring(0, 30) : this.getUpdateUser();
        }
        return createDateStr + ", by " + updateUser;
    }

    public List<TimeAndMoneyDocumentHistory> getTimeAndMoneyDocumentHistoryList() throws WorkflowException {
        List<TimeAndMoneyDocument> tnmDocs = this.getTimeAndMoneyHistoryService().buildTimeAndMoneyListForAwardDisplay(this);
        List<TimeAndMoneyDocumentHistory> timeAndMoneyHistoryList = this.getTimeAndMoneyHistoryService().getDocHistoryAndValidInfosAssociatedWithAwardVersion(tnmDocs, this.getAwardAmountInfos(), this);
        return timeAndMoneyHistoryList;
    }

    public VersionHistorySearchBo getVersionHistory() {
        return this.versionHistory;
    }

    public void setVersionHistory(VersionHistorySearchBo versionHistory) {
        this.versionHistory = versionHistory;
    }

    public void setProjectPersons(List<AwardPerson> projectPersons) {
        this.projectPersons = projectPersons;
    }

    static {
        reportedStatus = "1 3 6";
    }

    class ARTComparator
    implements Comparator {
        ARTComparator() {
        }

        public int compare(Object art1, Object art2) {
            try {
                String art1Desc = ((AwardReportTerm)art1).getReport().getDescription();
                String art2Desc = ((AwardReportTerm)art2).getReport().getDescription();
                if (art1Desc == null) {
                    art1Desc = Award.BLANK_COMMENT;
                }
                if (art2Desc == null) {
                    art2Desc = Award.BLANK_COMMENT;
                }
                return art1Desc.compareTo(art2Desc);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

