/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home;

import java.util.Calendar;
import org.kuali.kra.award.AwardAssociate;
import org.kuali.kra.award.AwardTemplateSyncScope;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncableProperty;
import org.kuali.kra.award.home.AwardSyncable;
import org.kuali.kra.bo.CommentType;

public class AwardComment
extends AwardAssociate
implements Comparable<AwardComment> {
    private static final long serialVersionUID = 3611932717292205490L;
    private Long awardCommentId;
    @AwardSyncableProperty(key=true)
    @AwardSyncable(scopes={AwardTemplateSyncScope.CONTAINING_CLASS_INHERIT})
    private String commentTypeCode;
    @AwardSyncable(scopes={AwardTemplateSyncScope.CONTAINING_CLASS_INHERIT})
    private Boolean checklistPrintFlag;
    @AwardSyncable(scopes={AwardTemplateSyncScope.CONTAINING_CLASS_INHERIT})
    @AwardSyncableProperty
    private String comments;
    private Long awardId;
    private CommentType commentType;
    private String updateTimestampDateString;

    public AwardComment() {
    }

    public AwardComment(CommentType commentType, String comments) {
        this();
        this.setCommentType(commentType);
        this.setComments(comments);
        this.setChecklistPrintFlag(Boolean.FALSE);
    }

    public Long getAwardCommentId() {
        return this.awardCommentId;
    }

    public void setAwardCommentId(Long awardCommentId) {
        this.awardCommentId = awardCommentId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.awardCommentId == null ? 0 : this.awardCommentId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AwardComment other = (AwardComment)obj;
        return this.awardCommentId.equals(other.awardCommentId);
    }

    public boolean sameText(AwardComment compare) {
        if (this.getComments() == compare.getComments()) {
            return true;
        }
        if (!this.isEntered() && !compare.isEntered()) {
            return true;
        }
        if (!this.isEntered() || !compare.isEntered()) {
            return false;
        }
        return this.comments.equals(compare.getComments());
    }

    public String getCommentTypeCode() {
        return this.commentTypeCode;
    }

    public void setCommentTypeCode(String commentTypeCode) {
        this.commentTypeCode = commentTypeCode;
    }

    public Boolean getChecklistPrintFlag() {
        return this.checklistPrintFlag;
    }

    public void setChecklistPrintFlag(Boolean checklistPrintFlag) {
        this.checklistPrintFlag = checklistPrintFlag;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public CommentType getCommentType() {
        return this.commentType;
    }

    public void setCommentType(CommentType commentType) {
        this.commentType = commentType;
        this.commentTypeCode = commentType != null ? commentType.getCommentTypeCode() : null;
    }

    public Long getAwardId() {
        return this.awardId;
    }

    public void setAwardId(Long awardId) {
        this.awardId = awardId;
    }

    public String getUpdateTimestampDateString() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getUpdateTimestamp());
        return Integer.toString(cal.get(2)) + "/" + Integer.toString(cal.get(5)) + "/" + Integer.toString(cal.get(1));
    }

    @Override
    public void resetPersistenceState() {
        this.awardCommentId = null;
        this.versionNumber = null;
    }

    @Override
    public int compareTo(AwardComment awardCommentArg) {
        return awardCommentArg.getUpdateTimestamp().compareTo(this.getUpdateTimestamp());
    }

    public void disableComment() {
        this.setVersionNumber(new Long(-1L));
    }

    public boolean isDisabled() {
        return new Long(-1L).equals(this.getVersionNumber());
    }

    public boolean isEntered() {
        return this.comments != null && this.comments.length() > 0;
    }
}

