/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home.approvedsubawards;

import java.util.HashMap;
import java.util.List;
import org.kuali.kra.award.home.approvedsubawards.AwardApprovedSubaward;
import org.kuali.kra.award.home.approvedsubawards.AwardApprovedSubawardRule;
import org.kuali.kra.award.home.approvedsubawards.AwardApprovedSubawardRuleEvent;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardApprovedSubawardRuleImpl
extends ResearchDocumentRuleBase
implements AwardApprovedSubawardRule {
    private static final String NEW_AWARD_APPROVED_SUBAWARD = "approvedSubawardFormHelper.newAwardApprovedSubaward";
    private static final String ORGANIZATION_NAME = ".organizationName";
    private static final String AMOUNT = ".amount";
    List<AwardApprovedSubaward> awardApprovedSubawards;
    AwardApprovedSubaward awardApprovedSubaward;
    String errorPath;

    @Override
    public boolean processApprovedSubawardBusinessRules(AwardApprovedSubawardRuleEvent awardApprovedSubawardRuleEvent) {
        this.awardApprovedSubawards = awardApprovedSubawardRuleEvent.getAwardApprovedSubawards();
        this.awardApprovedSubaward = awardApprovedSubawardRuleEvent.getApprovedSubaward();
        this.errorPath = awardApprovedSubawardRuleEvent.getErrorPathPrefix();
        return true;
    }

    public List<AwardApprovedSubaward> getAwardApprovedSubawards() {
        return this.awardApprovedSubawards;
    }

    public void setAwardApprovedSubawards(List<AwardApprovedSubaward> awardApprovedSubawards) {
        this.awardApprovedSubawards = awardApprovedSubawards;
    }

    public AwardApprovedSubaward getAwardApprovedSubaward() {
        return this.awardApprovedSubaward;
    }

    public void setAwardApprovedSubaward(AwardApprovedSubaward awardApprovedSubaward) {
        this.awardApprovedSubaward = awardApprovedSubaward;
    }

    public String getErrorPath() {
        return this.errorPath;
    }

    public void setErrorPath(String errorPath) {
        this.errorPath = errorPath;
    }

    public boolean processAddApprovedSubawardBusinessRules(AwardApprovedSubawardRuleEvent awardApprovedSubawardRuleEvent) {
        this.awardApprovedSubawards = awardApprovedSubawardRuleEvent.getAwardApprovedSubawards();
        this.awardApprovedSubaward = awardApprovedSubawardRuleEvent.getApprovedSubaward();
        this.errorPath = awardApprovedSubawardRuleEvent.getErrorPathPrefix();
        boolean validOrganization = this.validateApprovedSubawardOrganization();
        return validOrganization;
    }

    public boolean validateApprovedSubawardOrganization() {
        boolean valid = true;
        String organizationName = this.awardApprovedSubaward.getOrganizationName();
        if (organizationName == null) {
            valid = false;
            this.reportError("approvedSubawardFormHelper.newAwardApprovedSubaward.organizationName", "error.awardApprovedSubaward.organization.is.null", new String[0]);
        } else {
            valid = this.validateOrganizationExists(organizationName);
        }
        return valid;
    }

    private boolean validateOrganizationExists(String organizationName) {
        BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("organizationName", organizationName);
        boolean isValid = true;
        if (businessObjectService.countMatching(Organization.class, fieldValues) != 1) {
            this.reportError("approvedSubawardFormHelper.newAwardApprovedSubaward.organizationName", "error.awardApprovedSubaward.invalid.organization.name", organizationName);
            return false;
        }
        return isValid;
    }
}

