/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home.fundingproposal;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonCreditSplit;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.contacts.AwardPersonUnitCreditSplit;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.fundingproposal.FundingProposalMergeType;
import org.kuali.kra.award.home.fundingproposal.ProposalDataFeedCommandBase;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonCreditSplit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnitCreditSplit;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

class ProjectPersonnelDataFeedCommand
extends ProposalDataFeedCommandBase {
    private boolean identicalCreditSplit;

    public ProjectPersonnelDataFeedCommand(Award award, InstitutionalProposal proposal, FundingProposalMergeType mergeType) {
        super(award, proposal, mergeType);
    }

    @Override
    void performDataFeed() {
        if (this.mergeType != FundingProposalMergeType.NOCHANGE) {
            this.identicalCreditSplit = this.isCreditSplitIdentical();
            if (this.mergeType == FundingProposalMergeType.REPLACE && this.doesProposalHaveCreditSplitData() && !this.proposal.getProjectPersons().isEmpty()) {
                this.award.getProjectPersons().clear();
            }
            for (InstitutionalProposalPerson proposalPerson : this.proposal.getProjectPersons()) {
                AwardPerson existingAwardPerson = this.findExistingAwardPerson(proposalPerson);
                if (existingAwardPerson != null) {
                    this.reconcileUnits(proposalPerson, existingAwardPerson);
                    if (this.mergeType != FundingProposalMergeType.MERGE || this.identicalCreditSplit) continue;
                    this.mergeCreditSplit(existingAwardPerson, proposalPerson);
                    continue;
                }
                this.award.add(this.createAwardPerson(proposalPerson));
            }
        }
    }

    private AwardPerson findExistingAwardPerson(InstitutionalProposalPerson proposalPerson) {
        AwardPerson existingAwardPerson = null;
        if (!StringUtils.isBlank((String)proposalPerson.getPersonId())) {
            existingAwardPerson = this.award.getProjectPerson(proposalPerson.getPersonId());
        } else if (proposalPerson.getRolodexId() != null) {
            existingAwardPerson = this.award.getProjectPerson(proposalPerson.getRolodexId());
        }
        return existingAwardPerson;
    }

    private void reconcileUnits(InstitutionalProposalPerson proposalPerson, AwardPerson awardPerson) {
        for (InstitutionalProposalPersonUnit ipPersonUnit : proposalPerson.getUnits()) {
            AwardPersonUnit awardUnit = awardPerson.getUnit(ipPersonUnit.getUnitNumber());
            if (awardUnit == null) {
                awardPerson.add(this.createAwardPersonUnit(awardPerson, ipPersonUnit));
                continue;
            }
            if (this.mergeType != FundingProposalMergeType.MERGE || this.identicalCreditSplit) continue;
            this.mergeUnitCreditSplit(awardUnit, ipPersonUnit);
        }
    }

    private boolean hasLeadUnit(AwardPerson awardPerson) {
        for (AwardPersonUnit unit : awardPerson.getUnits()) {
            if (!unit.isLeadUnit()) continue;
            return true;
        }
        return false;
    }

    private AwardPerson createAwardPerson(InstitutionalProposalPerson proposalPerson) {
        AwardPerson awardPerson = new AwardPerson();
        if (!StringUtils.isBlank((String)proposalPerson.getPersonId())) {
            awardPerson.setPersonId(proposalPerson.getPersonId());
        } else {
            awardPerson.setRolodexId(proposalPerson.getRolodexId());
        }
        this.populateRoleCodes(awardPerson, proposalPerson);
        awardPerson.setAcademicYearEffort(proposalPerson.getAcademicYearEffort());
        awardPerson.setCalendarYearEffort(proposalPerson.getCalendarYearEffort());
        awardPerson.setEmailAddress(proposalPerson.getEmailAddress());
        awardPerson.setFaculty(proposalPerson.isFaculty());
        awardPerson.setFullName(proposalPerson.getFullName());
        awardPerson.setPhoneNumber(proposalPerson.getPhoneNumber());
        awardPerson.setSummerEffort(proposalPerson.getSummerEffort());
        awardPerson.setTotalEffort(proposalPerson.getTotalEffort());
        awardPerson.setMultiplePi(proposalPerson.isMultiplePi());
        for (InstitutionalProposalPersonCreditSplit ipPersonCreditSplit : proposalPerson.getCreditSplits()) {
            awardPerson.add(this.createAwardPersonCreditSplit(ipPersonCreditSplit));
        }
        for (InstitutionalProposalPersonUnit ipPersonUnit : proposalPerson.getUnits()) {
            awardPerson.add(this.createAwardPersonUnit(awardPerson, ipPersonUnit));
        }
        if (awardPerson.isKeyPerson() && !awardPerson.getUnits().isEmpty()) {
            awardPerson.setOptInUnitStatus(true);
        }
        return awardPerson;
    }

    private void populateRoleCodes(AwardPerson awardPerson, InstitutionalProposalPerson proposalPerson) {
        if ("PI".equals(proposalPerson.getRoleCode()) && this.award.getPrincipalInvestigator() != null) {
            awardPerson.setRoleCode("COI");
            awardPerson.setKeyPersonRole("COI");
            awardPerson.setContactRoleCode("COI");
        } else {
            awardPerson.setRoleCode(proposalPerson.getRoleCode());
            awardPerson.setKeyPersonRole(proposalPerson.getKeyPersonRole());
            awardPerson.setContactRoleCode(proposalPerson.getContactRoleCode());
        }
    }

    private AwardPersonCreditSplit createAwardPersonCreditSplit(InstitutionalProposalPersonCreditSplit ipPersonCreditSplit) {
        AwardPersonCreditSplit awardPersonCreditSplit = new AwardPersonCreditSplit();
        awardPersonCreditSplit.setCredit(ipPersonCreditSplit.getCredit());
        awardPersonCreditSplit.setInvCreditTypeCode(ipPersonCreditSplit.getInvCreditTypeCode());
        return awardPersonCreditSplit;
    }

    private AwardPersonUnit createAwardPersonUnit(AwardPerson awardPerson, InstitutionalProposalPersonUnit ipPersonUnit) {
        AwardPersonUnit awardPersonUnit = new AwardPersonUnit();
        awardPersonUnit.setUnitNumber(ipPersonUnit.getUnitNumber());
        if (awardPerson.isPrincipalInvestigator() && !this.hasLeadUnit(awardPerson) && ipPersonUnit.isLeadUnit()) {
            awardPersonUnit.setLeadUnit(true);
            this.award.setLeadUnit(ipPersonUnit.getUnit());
        } else {
            awardPersonUnit.setLeadUnit(false);
        }
        for (InstitutionalProposalPersonUnitCreditSplit ipPersonUnitCreditSplit : ipPersonUnit.getCreditSplits()) {
            AwardPersonUnitCreditSplit awardPersonUnitCreditSplit = new AwardPersonUnitCreditSplit();
            awardPersonUnitCreditSplit.setCredit(ipPersonUnitCreditSplit.getCredit());
            awardPersonUnitCreditSplit.setInvCreditTypeCode(ipPersonUnitCreditSplit.getInvCreditTypeCode());
            awardPersonUnit.add(awardPersonUnitCreditSplit);
        }
        return awardPersonUnit;
    }

    protected void mergeCreditSplit(AwardPerson awardPerson, InstitutionalProposalPerson ipPerson) {
        for (InstitutionalProposalPersonCreditSplit ipPersonCreditSplit : ipPerson.getCreditSplits()) {
            for (AwardPersonCreditSplit awardPersonCreditSplit : awardPerson.getCreditSplits()) {
                if (!StringUtils.equals((String)awardPersonCreditSplit.getInvCreditTypeCode(), (String)ipPersonCreditSplit.getInvCreditTypeCode())) continue;
                awardPersonCreditSplit.setCredit((KualiDecimal)awardPersonCreditSplit.getCredit().add((AbstractKualiDecimal)ipPersonCreditSplit.getCredit()));
            }
        }
    }

    private void mergeUnitCreditSplit(AwardPersonUnit awardUnit, InstitutionalProposalPersonUnit ipPersonUnit) {
        for (InstitutionalProposalPersonUnitCreditSplit ipPersonUnitCreditSplit : ipPersonUnit.getCreditSplits()) {
            for (AwardPersonUnitCreditSplit awardPersonUnitCreditSplit : awardUnit.getCreditSplits()) {
                if (!StringUtils.equals((String)awardPersonUnitCreditSplit.getInvCreditTypeCode(), (String)ipPersonUnitCreditSplit.getInvCreditTypeCode())) continue;
                awardPersonUnitCreditSplit.setCredit((KualiDecimal)awardPersonUnitCreditSplit.getCredit().add((AbstractKualiDecimal)ipPersonUnitCreditSplit.getCredit()));
            }
        }
    }

    protected boolean doesProposalHaveCreditSplitData() {
        for (InstitutionalProposalPerson person : this.proposal.getProjectPersons()) {
            if (person.getCreditSplits().size() > 0) {
                return true;
            }
            for (InstitutionalProposalPersonUnit unit : person.getUnits()) {
                if (unit.getCreditSplits().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isCreditSplitIdentical() {
        boolean identical = true;
        for (InstitutionalProposalPerson person : this.proposal.getProjectPersons()) {
            AwardPerson awardPerson = this.findExistingAwardPerson(person);
            if (awardPerson == null) {
                identical = false;
                continue;
            }
            for (InstitutionalProposalPersonCreditSplit propCreditSplit : person.getCreditSplits()) {
                AwardPersonCreditSplit awardCreditSplit = this.findCreditSplit(awardPerson, propCreditSplit);
                if (awardCreditSplit != null && awardCreditSplit.getCredit().equals((Object)propCreditSplit.getCredit())) continue;
                identical = false;
            }
            for (InstitutionalProposalPersonUnit propUnit : person.getUnits()) {
                AwardPersonUnit awardUnit = awardPerson.getUnit(propUnit.getUnitNumber());
                if (awardUnit == null) {
                    identical = false;
                    continue;
                }
                for (InstitutionalProposalPersonUnitCreditSplit propCreditSplit : propUnit.getCreditSplits()) {
                    AwardPersonUnitCreditSplit awardCreditSplit = this.findCreditSplit(awardUnit, propCreditSplit);
                    if (awardCreditSplit != null && awardCreditSplit.getCredit().equals((Object)propCreditSplit.getCredit())) continue;
                    identical = false;
                }
            }
        }
        return identical;
    }

    protected AwardPersonCreditSplit findCreditSplit(AwardPerson person, InstitutionalProposalPersonCreditSplit creditSplit) {
        for (AwardPersonCreditSplit awardCreditSplit : person.getCreditSplits()) {
            if (!StringUtils.equals((String)awardCreditSplit.getInvCreditTypeCode(), (String)creditSplit.getInvCreditTypeCode())) continue;
            return awardCreditSplit;
        }
        return null;
    }

    protected AwardPersonUnitCreditSplit findCreditSplit(AwardPersonUnit unit, InstitutionalProposalPersonUnitCreditSplit creditSplit) {
        for (AwardPersonUnitCreditSplit awardCreditSplit : unit.getCreditSplits()) {
            if (!StringUtils.equals((String)awardCreditSplit.getInvCreditTypeCode(), (String)creditSplit.getInvCreditTypeCode())) continue;
            return awardCreditSplit;
        }
        return null;
    }

    protected boolean isIdenticalCreditSplit() {
        return this.identicalCreditSplit;
    }

    protected void setIdenticalCreditSplit(boolean identicalCreditSplit) {
        this.identicalCreditSplit = identicalCreditSplit;
    }
}

