/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home.fundingproposal;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.AwardCommentFactory;
import org.kuali.kra.award.home.fundingproposal.FundingProposalMergeType;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;

abstract class ProposalDataFeedCommandBase {
    Award award;
    InstitutionalProposal proposal;
    FundingProposalMergeType mergeType;
    AwardCommentFactory awardCommentFactory;

    ProposalDataFeedCommandBase(Award award, InstitutionalProposal proposal, FundingProposalMergeType mergeType) {
        this.award = award;
        this.proposal = proposal;
        this.mergeType = mergeType;
        this.awardCommentFactory = new AwardCommentFactory();
    }

    void appendComments(AwardComment comment, String newComments) {
        if (!StringUtils.isEmpty((String)newComments)) {
            String comments = comment.getComments();
            comment.setComments(StringUtils.isEmpty((String)comments) ? newComments : String.format("%s\n%s", comments, newComments));
        }
    }

    AwardComment findGeneralComment() {
        return this.findOrCreateCommentOfSpecifiedType(new AwardCommentFactory().createGeneralComment());
    }

    AwardComment findOrCreateCommentOfSpecifiedType(AwardComment template) {
        AwardComment comment = this.award.findCommentOfSpecifiedType(template);
        if (comment == null) {
            comment = template;
            this.award.add(comment);
        }
        return comment;
    }

    abstract void performDataFeed();

    void setAwardCommentFactory(AwardCommentFactory awardCommentFactory) {
        this.awardCommentFactory = awardCommentFactory;
    }
}

