/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.lookup.AwardTransactionLookupService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardTransactionLookupServiceImpl
implements AwardTransactionLookupService {
    private BusinessObjectService businessObjectService;
    private static final Log LOG = LogFactory.getLog(AwardTransactionLookupServiceImpl.class);

    @Override
    public Map<Integer, String> getApplicableTransactionIds(String awardNumber, Integer sequenceNumber) {
        if (this.isAuthorizedToAccess(awardNumber)) {
            if (StringUtils.isNotBlank((String)awardNumber) && awardNumber.contains(":")) {
                awardNumber = StringUtils.split((String)awardNumber, (String)":")[0];
            }
            ArrayList<Long> transactionIds = new ArrayList<Long>();
            HashMap<String, String> awardValues = new HashMap<String, String>();
            awardValues.put("awardNumber", awardNumber);
            Collection awards = this.getBusinessObjectService().findMatchingOrderBy(Award.class, awardValues, "sequenceNumber", true);
            ArrayList<Long> excludedTransactionIds = new ArrayList<Long>();
            for (Award award : awards) {
                if (award.getSequenceNumber() < sequenceNumber) {
                    for (AwardAmountInfo amountInfo : award.getAwardAmountInfos()) {
                        if (amountInfo.getTransactionId() == null) continue;
                        excludedTransactionIds.add(amountInfo.getTransactionId());
                    }
                    continue;
                }
                if (award.getSequenceNumber().intValue() != sequenceNumber.intValue()) continue;
                for (AwardAmountInfo amountInfo : award.getAwardAmountInfos()) {
                    if (amountInfo.getTransactionId() == null) continue;
                    transactionIds.add(amountInfo.getTransactionId());
                }
            }
            Award currentAward = this.getAwardVersion(awardNumber, sequenceNumber);
            transactionIds.removeAll(excludedTransactionIds);
            TreeMap<Integer, String> retval = new TreeMap<Integer, String>(new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return o1.compareTo(o2) * -1;
                }
            });
            for (Long id : transactionIds) {
                if (id == null) continue;
                retval.put(this.getAwardAmountInfoIndex(currentAward, id), id.toString());
            }
            if (sequenceNumber == 1) {
                retval.put(0, "Initial");
            }
            return retval;
        }
        return new TreeMap<Integer, String>();
    }

    protected int getAwardAmountInfoIndex(Award award, Long transactionId) {
        for (int i = 0; i < award.getAwardAmountInfos().size(); ++i) {
            if (!ObjectUtils.equals((Object)award.getAwardAmountInfos().get(i).getTransactionId(), (Object)transactionId)) continue;
            return i;
        }
        return 0;
    }

    protected Award getAwardVersion(String awardNumber, int sequenceNumber) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("awardNumber", awardNumber);
        values.put("sequenceNumber", sequenceNumber);
        Collection awards = this.businessObjectService.findMatching(Award.class, values);
        return (Award)awards.iterator().next();
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    private boolean isAuthorizedToAccess(String awardNumber) {
        boolean isAuthorized = true;
        if (awardNumber.contains(":")) {
            if (GlobalVariables.getUserSession() != null) {
                Map editModes;
                Object formObj;
                String[] invalues = StringUtils.split((String)awardNumber, (String)":");
                String docFormKey = invalues[1];
                isAuthorized = StringUtils.isBlank((String)docFormKey) ? false : ((formObj = GlobalVariables.getUserSession().retrieveObject(docFormKey)) == null || !(formObj instanceof AwardForm) ? false : BooleanUtils.toBoolean((String)((String)(editModes = ((AwardForm)formObj).getEditingMode()).get("fullEntry"))) || BooleanUtils.toBoolean((String)((String)editModes.get("viewOnly"))));
            } else {
                LOG.info((Object)"dwr/ajax does not have session ");
            }
        }
        return isAuthorized;
    }
}

