/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.lookup.AwardTransactionLookupService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardTransactionValuesFinder
extends KeyValuesBase {
    private AwardTransactionLookupService transactionLookupService = KraServiceLocator.getService(AwardTransactionLookupService.class);
    private BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);

    public List<KeyValue> getKeyValues() {
        AwardForm form = this.getAwardForm();
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        Integer usableSequence = form.getAwardPrintChangeReport().getAwardVersion();
        if (usableSequence == null) {
            usableSequence = form.getAwardDocument().getAward().getSequenceNumber();
        }
        Map<Integer, String> transactionValues = this.transactionLookupService.getApplicableTransactionIds(form.getAwardDocument().getAward().getAwardNumber(), usableSequence);
        for (Map.Entry<Integer, String> entry : transactionValues.entrySet()) {
            keyValues.add((KeyValue)new ConcreteKeyValue(entry.getKey().toString(), entry.getValue()));
        }
        return keyValues;
    }

    private AwardForm getAwardForm() {
        return (AwardForm)KNSGlobalVariables.getKualiForm();
    }

    public void setTransactionLookupService(AwardTransactionLookupService transactionLookupService) {
        this.transactionLookupService = transactionLookupService;
    }
}

