/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.contacts.AwardSponsorContact;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.KeyValuesService;
import org.kuali.rice.krad.service.PersistenceService;

public class ContactsValuesFinder
extends KeyValuesBase {
    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add((KeyValue)new ConcreteKeyValue("", "select "));
        Long awardId = ((AwardForm)KNSGlobalVariables.getKualiForm()).getAwardDocument().getAward().getAwardId();
        HashMap<String, Long> keyMap = new HashMap<String, Long>();
        keyMap.put("awardId", awardId);
        Collection awardSponsorContacts = this.getKeyValuesService().findMatching(AwardSponsorContact.class, keyMap);
        for (AwardSponsorContact awardSponsorContact : awardSponsorContacts) {
            if (awardSponsorContact.getContactRole() == null) {
                awardSponsorContact.refreshReferenceObject("contactRole");
            }
            String desc = awardSponsorContact.getContactRole().getRoleDescription() + " - ";
            desc = StringUtils.isNotBlank((String)awardSponsorContact.getFullName()) ? desc + awardSponsorContact.getFullName() : desc + awardSponsorContact.getContactOrganizationName();
            keyValues.add((KeyValue)new ConcreteKeyValue(awardSponsorContact.getAwardContactId().toString(), desc));
        }
        return keyValues;
    }

    protected KeyValuesService getKeyValuesService() {
        return KraServiceLocator.getService(KeyValuesService.class);
    }

    private void refreshAwardSponsorContacts(Collection<AwardSponsorContact> awardSponsorContacts) {
        ArrayList<AwardSponsorContact> persistableObjects = new ArrayList<AwardSponsorContact>();
        ArrayList<String> referenceObjectNames = new ArrayList<String>();
        for (AwardSponsorContact awardSponsorContact : awardSponsorContacts) {
            persistableObjects.add(awardSponsorContact);
            referenceObjectNames.add("award");
        }
        if (persistableObjects.size() > 0 && referenceObjectNames.size() > 0) {
            this.getPersistenceService().retrieveReferenceObjects(persistableObjects, referenceObjectNames);
        }
    }

    protected PersistenceService getPersistenceService() {
        return KraServiceLocator.getService(PersistenceService.class);
    }
}

